/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    private static TokenSet ourHtmlTokens;
    private static TokenSet ourHtmlTokens2;
    private final DialectOptionHolder myDialectOptionsHolder;
    public static final TextAttributesKey JS_KEYWORD;
    protected static final TextAttributesKey JS_STRING;
    static final TextAttributesKey JS_NUMBER;
    static final TextAttributesKey JS_REGEXP;
    static final TextAttributesKey JS_LINE_COMMENT;
    static final TextAttributesKey JS_BLOCK_COMMENT;
    static final TextAttributesKey JS_DOC_COMMENT;
    protected static final TextAttributesKey JS_OPERATION_SIGN;
    static final TextAttributesKey JS_PARENTHS;
    static final TextAttributesKey JS_BRACKETS;
    static final TextAttributesKey JS_BRACES;
    static final TextAttributesKey JS_COMMA;
    static final TextAttributesKey JS_DOT;
    static final TextAttributesKey JS_SEMICOLON;
    static final TextAttributesKey JS_BAD_CHARACTER;
    static final TextAttributesKey JS_DOC_TAG;
    static final TextAttributesKey JS_DOC_MARKUP;
    static final TextAttributesKey JS_VALID_STRING_ESCAPE;
    static final TextAttributesKey JS_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey JS_LOCAL_VARIABLE;
    static final TextAttributesKey JS_PARAMETER;
    public static final TextAttributesKey JS_INSTANCE_MEMBER_VARIABLE;
    static final TextAttributesKey JS_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey JS_GLOBAL_VARIABLE;
    static final TextAttributesKey JS_GLOBAL_FUNCTION;
    static final TextAttributesKey JS_STATIC_MEMBER_FUNCTION;
    static final TextAttributesKey JS_INSTANCE_MEMBER_FUNCTION;
    static final TextAttributesKey JS_CLASS;
    static final TextAttributesKey JS_INTERFACE;
    static final TextAttributesKey JS_LABEL;
    static final TextAttributesKey JS_MODULE_NAME;
    public static final TextAttributesKey FUNCTION_ARROW;
    static final TokenSet OPERATORS_LIKE;

    public JSHighlighter(DialectOptionHolder dialectOptionsHolder) {
        this.myDialectOptionsHolder = dialectOptionsHolder;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        JavaScriptHighlightingLexer javaScriptHighlightingLexer = new JavaScriptHighlightingLexer(this.myDialectOptionsHolder, ourHtmlTokens, ourHtmlTokens2);
        if (javaScriptHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter", "getHighlightingLexer"));
        }
        return javaScriptHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (this.getKeywords().contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = JSHighlighter.pack((TextAttributesKey)JS_KEYWORD);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = JSHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    public TextAttributesKey getMappedKey(TextAttributesKey original) {
        return original;
    }

    public static void registerHtmlMarkup(IElementType[] htmlTokens, IElementType[] htmlTokens2) {
        ourHtmlTokens = TokenSet.create((IElementType[])htmlTokens);
        ourHtmlTokens2 = TokenSet.create((IElementType[])htmlTokens2);
    }

    public DialectOptionHolder getDialectOptionsHolder() {
        return this.myDialectOptionsHolder;
    }

    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_WORDS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter", "getKeywords"));
        }
        return tokenSet;
    }

    static {
        IElementType[] javadoc;
        JS_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"JS.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        JS_STRING = TextAttributesKey.createTextAttributesKey((String)"JS.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JS_NUMBER = TextAttributesKey.createTextAttributesKey((String)"JS.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        JS_REGEXP = TextAttributesKey.createTextAttributesKey((String)"JS.REGEXP", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JS_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        JS_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        JS_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        JS_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"JS.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        JS_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"JS.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        JS_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"JS.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        JS_BRACES = TextAttributesKey.createTextAttributesKey((String)"JS.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        JS_COMMA = TextAttributesKey.createTextAttributesKey((String)"JS.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        JS_DOT = TextAttributesKey.createTextAttributesKey((String)"JS.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        JS_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"JS.SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        JS_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"JS.BADCHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        JS_DOC_TAG = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_TAG", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
        JS_DOC_MARKUP = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_MARKUP", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_MARKUP);
        JS_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JS.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        JS_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JS.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        JS_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.LOCAL_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        JS_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"JS.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        JS_INSTANCE_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        JS_STATIC_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.STATIC_MEMBER_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
        JS_GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.GLOBAL_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
        JS_GLOBAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.GLOBAL_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        JS_STATIC_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.STATIC_MEMBER_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
        JS_INSTANCE_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        JS_CLASS = TextAttributesKey.createTextAttributesKey((String)"JS.CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        JS_INTERFACE = TextAttributesKey.createTextAttributesKey((String)"JS.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        JS_LABEL = TextAttributesKey.createTextAttributesKey((String)"JS.LABEL", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
        JS_MODULE_NAME = TextAttributesKey.createTextAttributesKey((String)"JS.MODULE_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        FUNCTION_ARROW = TextAttributesKey.createTextAttributesKey((String)"JS.FUNCTION_ARROW", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        OPERATORS_LIKE = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSTokenTypes.ARROWS});
        keys1 = new THashMap();
        keys2 = new THashMap();
        JSHighlighter.fillMap(keys1, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)JS_OPERATION_SIGN);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JS_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(JSTokenTypes.NUMERIC_LITERAL, JS_NUMBER);
        keys1.put(JSTokenTypes.STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.STRING_TEMPLATE_PART, JS_STRING);
        keys1.put(JSTokenTypes.BACKQUOTE, JS_STRING);
        keys1.put(JSTokenTypes.REGEXP_LITERAL, JS_REGEXP);
        keys1.put(JSTokenTypes.LPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.RPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.LBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.RBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.LBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.RBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.COMMA, JS_COMMA);
        keys1.put(JSTokenTypes.DOT, JS_DOT);
        keys1.put(JSTokenTypes.SEMICOLON, JS_SEMICOLON);
        keys1.put(JSTokenTypes.C_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.DOC_COMMENT, JS_DOC_COMMENT);
        keys1.put(JSTokenTypes.END_OF_LINE_COMMENT, JS_LINE_COMMENT);
        keys1.put(JSTokenTypes.BAD_CHARACTER, JS_BAD_CHARACTER);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_COMMENT);
        keys2.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_TAG);
        for (IElementType type2 : javadoc = IElementType.enumerate(type -> type instanceof JSDocElementType)) {
            keys1.put(type2, JS_DOC_COMMENT);
        }
        keys1.put(JSDocTokenTypes.DOC_TAG_VALUE, JS_DOC_COMMENT);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, JS_DOC_COMMENT);
        for (IElementType type2 : JSTokenTypes.XML_TOKENS.getTypes()) {
            keys1.put(type2, XmlHighlighterColors.XML_TAG);
        }
        keys2.put(JSTokenTypes.XML_TAG_NAME, XmlHighlighterColors.XML_TAG_NAME);
        keys2.put(JSTokenTypes.XML_NAME, XmlHighlighterColors.XML_ATTRIBUTE_NAME);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_END, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_START, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_EQUAL, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ENTITY_REF, XmlHighlighterColors.XML_ENTITY_REFERENCE);
        keys2.put(JSTokenTypes.JSDOC_MARKUP, JS_DOC_MARKUP);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, XmlHighlighterColors.XML_COMMENT);
        keys1.put(JSTokenTypes.XML_TAG_CONTENT, XmlHighlighterColors.XML_TAG_DATA);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(keys1, keys2);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(keys1, keys2);
        THashMap keywords = new THashMap();
        JSHighlighter.fillMap((Map)keywords, (TokenSet)JSKeywordSets.ES6_RESERVED_WORDS, (TextAttributesKey)JS_KEYWORD);
        JSHighlighter.fillMap((Map)keywords, (TokenSet)JSKeywordSets.ES6_SPECIAL_WORDS, (TextAttributesKey)JS_KEYWORD);
        JSHighlighter.fillMap((Map)keywords, (TokenSet)JSKeywordSets.ES7_SPECIAL_WORDS, (TextAttributesKey)JS_KEYWORD);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes((Map)keywords, null);
        XmlFileHighlighter.registerEmbeddedTokenAttributes((Map)keywords, null);
    }
}

