/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    @Nullable
    public String getName() {
        return "Recursive call";
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "collectSlowLineMarkers"));
        }
        THashSet visited = ContainerUtil.newTroveSet();
        for (PsiElement element : elements) {
            JSFunction containingFunction;
            ProgressManager.checkCanceled();
            if (!(element instanceof JSReferenceExpression)) continue;
            JSReferenceExpression referenceExpression = (JSReferenceExpression)element;
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class});
            if (statement == null || visited.contains(statement) || (containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class)) == null) continue;
            if (JSRecursiveCallLineMarkerProvider.isInCallExpression(referenceExpression) && JSRecursiveCallLineMarkerProvider.isRecursiveCall(referenceExpression, containingFunction)) {
                visited.add(statement);
                result.add(new RecursiveMethodCallMarkerInfo((JSExpression)referenceExpression.getParent()));
                continue;
            }
            if (!containingFunction.isGetProperty() && !containingFunction.isSetProperty() || !JSRecursiveCallLineMarkerProvider.isRecursivePropertyCall(referenceExpression, containingFunction)) continue;
            visited.add(statement);
            result.add(new RecursiveMethodCallMarkerInfo((JSExpression)referenceExpression));
        }
    }

    private static boolean isRecursivePropertyCall(@NotNull JSReferenceExpression expression, @NotNull JSFunction function) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isRecursivePropertyCall"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isRecursivePropertyCall"));
        }
        ReadWriteAccessDetector.Access accessType = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression);
        return (accessType == ReadWriteAccessDetector.Access.ReadWrite || function.isGetProperty() && accessType == ReadWriteAccessDetector.Access.Read || function.isSetProperty() && accessType == ReadWriteAccessDetector.Access.Write) && JSRecursiveCallLineMarkerProvider.isRecursiveCall(expression, function);
    }

    private static boolean isInCallExpression(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isInCallExpression"));
        }
        PsiElement parent = referenceExpression.getParent();
        return parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
    }

    private static boolean isRecursiveCall(@NotNull JSReferenceExpression ref, @NotNull JSFunction parentFunction) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isRecursiveCall"));
        }
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFunction", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isRecursiveCall"));
        }
        String name = ref.getReferenceName();
        if (name == null) {
            return false;
        }
        if (!name.equals(parentFunction.getName())) {
            return false;
        }
        return JSRecursiveCallLineMarkerProvider.isClassOrLiteralMethodRecursiveCall(ref, parentFunction) || JSRecursiveCallLineMarkerProvider.isGlobalFunctionRecursiveCall(ref, parentFunction);
    }

    private static boolean isClassOrLiteralMethodRecursiveCall(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isClassOrLiteralMethodRecursiveCall"));
        }
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFunction", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isClassOrLiteralMethodRecursiveCall"));
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)parentFunction);
        if (parent instanceof JSClass || parent instanceof JSObjectLiteralExpression || parent instanceof JSProperty) {
            return referenceExpression.getQualifier() instanceof JSThisExpression;
        }
        return false;
    }

    private static boolean isGlobalFunctionRecursiveCall(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isGlobalFunctionRecursiveCall"));
        }
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFunction", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "isGlobalFunctionRecursiveCall"));
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        return JSRecursiveCallLineMarkerProvider.checkResolvedEqual(referenceExpression, parentFunction);
    }

    private static boolean checkResolvedEqual(@NotNull JSReferenceExpression referenceExpression, @NotNull JSFunction parentFunction) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "checkResolvedEqual"));
        }
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFunction", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "checkResolvedEqual"));
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        PsiElement expectedElement = JSRecursiveCallLineMarkerProvider.getExpectedElement(parentFunction);
        return resolve != null && resolve.isEquivalentTo(expectedElement);
    }

    @NotNull
    private static PsiElement getExpectedElement(@NotNull JSFunction parentFunction) {
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFunction", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "getExpectedElement"));
        }
        if (parentFunction instanceof JSFunctionExpression) {
            PsiElement parent = parentFunction.getParent();
            Object object = parent instanceof JSVariable ? parent : parentFunction;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "getExpectedElement"));
            }
            return object;
        }
        JSFunction jSFunction = parentFunction;
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider", "getExpectedElement"));
        }
        return jSFunction;
    }

    private static class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<JSExpression> {
        private RecursiveMethodCallMarkerInfo(@NotNull JSExpression methodCall) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/lang/javascript/highlighting/JSRecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo", "<init>"));
            }
            super((PsiElement)methodCall, methodCall.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<JSExpression>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }
    }
}

