/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
extends JSModuleImportOptimizerBase {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
        }
        final Collection<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)file);
        if (declarations.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
            }
            return list;
        }
        final ArrayList infos = ContainerUtil.newArrayList();
        for (ES6ImportDeclaration declaration : declarations) {
            ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.getInfo(declaration);
            if (!info.isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration) == null) continue;
            infos.add(info);
        }
        final List<String> importTexts = this.buildNewImportsText(file, infos);
        JSModuleImportOptimizerBase.UnusedModuleInfo info = new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            public List<String> getImportTexts() {
                return importTexts;
            }

            @Override
            public PsiElement getAnchor() {
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                if (item != null) {
                    return item.getDeclaration();
                }
                return (PsiElement)ContainerUtil.getFirstItem((Collection)declarations);
            }

            @Override
            public List<PsiElement> getOldImports() {
                return infos.stream().map(el -> el.getDeclaration()).collect(Collectors.toList());
            }
        };
        List list = ContainerUtil.createMaybeSingletonList((Object)info);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
        }
        return list;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports((PsiElement)file);
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        ArrayList toProcessInfos = ContainerUtil.newArrayList(infos);
        ES6ImportOptimizer.sortByModuleName(file, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection mergedImports;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList sideEffectImportWithComments = ContainerUtil.newArrayList();
                ES6ImportOptimizer.addSideEffectImport(file, document, sideEffectImportWithComments, info);
                JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            ArrayList currentImports = ContainerUtil.newArrayList();
            if (merge) {
                this.processMergedImports(file, document, currentImports, fromText, mergedImports);
            } else {
                HashSet visitedBindingNames = ContainerUtil.newHashSet();
                HashSet visitedSpecifierNames = ContainerUtil.newHashSet();
                for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                    List<String> importBodyText = this.getImportBodyText(file, document, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText, visitedBindingNames, visitedSpecifierNames);
                    currentImports.addAll(importBodyText);
                }
            }
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, currentImports);
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        return arrayList;
    }

    private static void sortByModuleName(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)file);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator((PsiElement)file);
        ContainerUtil.sort(infos, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    protected void processMergedImports(@NotNull PsiFile file, @Nullable Document document, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "processMergedImports"));
        }
        importsResult.addAll(this.getImportBodyText(file, document, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @Nullable Document document, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String name = declaration.getImportModuleText();
        if (!StringUtil.isEmpty((String)name)) {
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration);
            importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(prevComments));
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ImportStyle style = ES6ImportOptimizer.getImportStyle(file, declaration);
            ES6ImportOptimizer.addFromPartWithoutKeyword(style, StringUtil.unquoteString((String)name), builder);
            JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)declaration, builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        return linkedMultiMap;
    }

    private static boolean isSuppressedUnused(ES6ImportExportDeclaration declaration) {
        return SuppressionUtil.isSuppressedInStatement((PsiElement)declaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        HashSet bindings = ContainerUtil.newHashSet();
        HashSet specifiers = ContainerUtil.newHashSet();
        return this.getImportBodyText(file, document, mergedImports, fromPart, bindings, specifiers);
    }

    @NotNull
    private static <PartType extends ES6ImportExportDeclarationPart> MultiMap<PartType, ES6ImportDeclaration> getUniqueImportParts(@NotNull List<PartType> parts, @NotNull Collection<String> visitedNames) {
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getUniqueImportParts"));
        }
        if (visitedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedNames", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getUniqueImportParts"));
        }
        MultiMap mergedParts = MultiMap.createLinked();
        HashMap names = ContainerUtil.newHashMap();
        for (ES6ImportExportDeclarationPart importPart : parts) {
            String name = importPart.getDeclaredName();
            if (name == null || visitedNames.contains(name)) continue;
            ES6ImportExportDeclarationPart storedPart = (ES6ImportExportDeclarationPart)ContainerUtil.getOrCreate((Map)names, (Object)name, (Object)importPart);
            mergedParts.putValue((Object)storedPart, (Object)((ES6ImportDeclaration)importPart.getDeclaration()));
        }
        visitedNames.addAll(names.keySet());
        MultiMap multiMap = mergedParts;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getUniqueImportParts"));
        }
        return multiMap;
    }

    protected List<String> getImportBodyText(@NotNull PsiFile context, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedBindingNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedBindingNames", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedSpecifierNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedSpecifierNames", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        ArrayList bindings = ContainerUtil.newArrayList();
        ArrayList specifiers = ContainerUtil.newArrayList();
        ArrayList prevCommentsToProcess = ContainerUtil.newArrayList();
        HashMap lineCommentsToProcess = ContainerUtil.newHashMap();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = JSOptimizeImportUtil.getLineComment(document, (PsiElement)declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration));
        }
        ES6ImportOptimizer.sortSpecifiers(context, specifiers);
        MultiMap uniqueBindings = ES6ImportOptimizer.getUniqueImportParts(bindings, visitedBindingNames);
        MultiMap uniqueSpecifiers = ES6ImportOptimizer.getUniqueImportParts(specifiers, visitedSpecifierNames);
        ImportBuilder importBuilder = new ImportBuilder(ES6ImportOptimizer.getImportStyle(context, mergedImports), this.getImportPrefix(mergedImports), fromPart);
        ArrayList resultListOfImports = ContainerUtil.newArrayList();
        importBuilder = ES6ImportOptimizer.appendBindings(uniqueBindings, importBuilder, lineCommentsToProcess, resultListOfImports);
        ES6ImportOptimizer.appendSpecifiers(uniqueSpecifiers, importBuilder, lineCommentsToProcess);
        if (!importBuilder.isEmpty()) {
            resultListOfImports.add(importBuilder.createImportString());
        }
        return ContainerUtil.concat(JSOptimizeImportUtil.getPsiElementsAsStrings(prevCommentsToProcess), (List)resultListOfImports);
    }

    private static void sortSpecifiers(@NotNull PsiFile context, @NotNull List<ES6ImportSpecifier> specifiers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortSpecifiers"));
        }
        if (specifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifiers", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortSpecifiers"));
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)context).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator((PsiElement)context);
            ContainerUtil.sort(specifiers, comparator);
        }
    }

    private static ImportBuilder appendBindings(@NotNull MultiMap<ES6ImportedBinding, ES6ImportDeclaration> uniqueBindings, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull List<String> listOfImports) {
        if (uniqueBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uniqueBindings", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendBindings"));
        }
        if (importBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBuilder", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendBindings"));
        }
        if (lineCommentsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendBindings"));
        }
        if (listOfImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOfImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendBindings"));
        }
        int bindingCount = 0;
        boolean lastIsAll = false;
        for (Map.Entry bindingWithDeclarations : uniqueBindings.entrySet()) {
            ES6ImportedBinding binding = (ES6ImportedBinding)bindingWithDeclarations.getKey();
            if (bindingCount > 0) {
                if (bindingCount == 1 && !lastIsAll && binding.isNamespaceImport()) {
                    importBuilder.append(", ");
                } else {
                    listOfImports.add(importBuilder.createImportString());
                    importBuilder = importBuilder.cloneBuilder();
                    bindingCount = 0;
                }
            }
            ++bindingCount;
            ImportBuilder finalImportBuilder = importBuilder;
            ((Collection)bindingWithDeclarations.getValue()).forEach(decl -> {
                if (lineCommentsToProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "lambda$appendBindings$1"));
                }
                ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, finalImportBuilder, decl);
            });
            importBuilder.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            listOfImports.add(importBuilder.createImportString());
            return importBuilder.cloneBuilder();
        }
        return importBuilder;
    }

    private static void appendSpecifiers(@NotNull MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess) {
        if (uniqueSpecifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uniqueSpecifiers", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendSpecifiers"));
        }
        if (importBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBuilder", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendSpecifiers"));
        }
        if (lineCommentsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "appendSpecifiers"));
        }
        if (uniqueSpecifiers.isEmpty()) {
            return;
        }
        if (!importBuilder.isEmpty()) {
            importBuilder.append(", ");
        }
        importBuilder.append("{");
        String specifierList = StringUtil.join((Collection)uniqueSpecifiers.entrySet(), el -> {
            if (lineCommentsToProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "lambda$appendSpecifiers$3"));
            }
            if (importBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBuilder", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "lambda$appendSpecifiers$3"));
            }
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)el.getKey();
            ((Collection)el.getValue()).forEach(decl -> {
                if (lineCommentsToProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "lambda$null$2"));
                }
                if (importBuilder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBuilder", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "lambda$null$2"));
                }
                ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, importBuilder, decl);
            });
            return specifier.getText();
        }, (String)", ");
        importBuilder.append(specifierList);
        if (importBuilder.myStyle.myAddTrailingComma) {
            importBuilder.append(", ");
        }
        importBuilder.append("}");
    }

    private static void addLineCommentsToBuilder(@NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull ImportBuilder builder, @NotNull ES6ImportDeclaration declaration) {
        if (lineCommentsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentsToProcess", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addLineCommentsToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addLineCommentsToBuilder"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addLineCommentsToBuilder"));
        }
        PsiElement comment = lineCommentsToProcess.remove(declaration);
        if (comment != null) {
            builder.addLineComment(comment);
        }
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration);
        ES6ImportOptimizer.fillUsedSpecifiers(specifiers, importInfo, declaration, isSuppressedUnused);
        ES6ImportOptimizer.fillUsedBindings(bindings, importInfo, declaration, isSuppressedUnused);
    }

    private static void fillUsedBindings(List<ES6ImportedBinding> bindings, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        ES6ImportedBinding[] currentBindings = declaration.getImportedBindings();
        Collection<Object> unusedBindings = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedBindings();
        bindings.addAll(Arrays.stream(currentBindings).filter(el -> !unusedBindings.contains(el)).collect(Collectors.toList()));
    }

    private static void fillUsedSpecifiers(List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        ES6ImportSpecifier[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedSpecifiers();
        specifiers.addAll(Arrays.stream(currentSpecifiers).filter(el -> !unusedSpecifiers.contains(el)).collect(Collectors.toList()));
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        if ("import " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        return "import ";
    }

    private static void addFromPart(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPart"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPart"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPart"));
        }
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(style, fromPart, importBody);
    }

    @NotNull
    private static ImportStyle getImportStyle(PsiFile context, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportStyle"));
        }
        ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(mergedImports);
        if (item == null) {
            ImportStyle importStyle = ES6ImportOptimizer.getDefaultImportStyle(context);
            if (importStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportStyle"));
            }
            return importStyle;
        }
        ES6ImportDeclaration declaration = item.getDeclaration();
        ImportStyle importStyle = ES6ImportOptimizer.getImportStyle(context, declaration);
        if (importStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportStyle"));
        }
        return importStyle;
    }

    @NotNull
    private static ImportStyle getDefaultImportStyle(@NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getDefaultImportStyle"));
        }
        ImportStyle importStyle = new ImportStyle(JSCodeStyleSettings.getQuote((PsiElement)context), false, JSCodeStyleSettings.getSemicolon(context));
        if (importStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getDefaultImportStyle"));
        }
        return importStyle;
    }

    private static ImportStyle getImportStyle(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportStyle"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportStyle"));
        }
        String semicolon = ES6ImportOptimizer.getSemicolon(context, declaration);
        String quote = ES6ImportOptimizer.getQuote(context, declaration);
        boolean shouldAddTrailingCommaToSpecifiers = ES6ImportOptimizer.shouldAddTrailingCommaToSpecifiers(context, declaration);
        return new ImportStyle(quote, shouldAddTrailingCommaToSpecifiers, semicolon);
    }

    private static boolean shouldAddTrailingCommaToSpecifiers(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "shouldAddTrailingCommaToSpecifiers"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "shouldAddTrailingCommaToSpecifiers"));
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        if (specifiers.length == 0) {
            return false;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)context);
        if (settings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Remove) {
            return false;
        }
        ES6ImportSpecifier lastSpecifier = specifiers[specifiers.length - 1];
        PsiElement sibling = JSPsiImplUtils.getNextSiblingIgnoreWhitespace((PsiElement)lastSpecifier);
        return sibling != null && sibling.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static String getQuote(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getQuote"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getQuote"));
        }
        ASTNode declarationNode = declaration.getNode();
        ES6FromClause clause = declaration.getFromClause();
        ASTNode parentNode = clause == null ? declarationNode : clause.getNode();
        ASTNode stringLiteral = parentNode.findChildByType(JSTokenTypes.STRING_LITERAL);
        return ES6ImportPsiUtil.getQuote((PsiElement)context, stringLiteral);
    }

    private static String getSemicolon(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getSemicolon"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getSemicolon"));
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)context);
        if (settings.FORCE_SEMICOLON_STYLE) {
            return JSCodeStyleSettings.getSemicolon(context);
        }
        ASTNode declarationNode = declaration.getNode();
        ASTNode semicolonNode = declarationNode.findChildByType(JSTokenTypes.SEMICOLON);
        return semicolonNode == null ? "" : semicolonNode.getText();
    }

    private static void addFromPartWithoutKeyword(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        String quote = style.myQuote;
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(style.mySemicolon);
    }

    static class ImportBuilder {
        @NotNull
        private final ImportStyle myStyle;
        @NotNull
        private final String myImportPrefix;
        @NotNull
        private final String myFromPart;
        @NotNull
        private final StringBuilder myCurrentText;
        @NotNull
        private final List<PsiElement> myLineComments;

        public ImportBuilder(@NotNull ImportStyle style, @NotNull String importPrefix, @NotNull String fromPart) {
            if (style == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "<init>"));
            }
            if (importPrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPrefix", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "<init>"));
            }
            if (fromPart == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "<init>"));
            }
            this.myStyle = style;
            this.myImportPrefix = importPrefix;
            this.myFromPart = fromPart;
            this.myCurrentText = new StringBuilder();
            this.myLineComments = ContainerUtil.newArrayList();
        }

        private void append(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "append"));
            }
            this.myCurrentText.append(text);
        }

        private boolean isEmpty() {
            return this.myCurrentText.length() == 0;
        }

        private void addLineComment(@NotNull PsiElement comment) {
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "addLineComment"));
            }
            this.myLineComments.add(comment);
        }

        @NotNull
        private String createImportString() {
            assert (!this.isEmpty());
            ES6ImportOptimizer.addFromPart(this.myStyle, this.myFromPart, this.myCurrentText);
            JSOptimizeImportUtil.addSameLineComments(this.myCurrentText, JSOptimizeImportUtil.getPsiElementsAsStrings(this.myLineComments));
            String string = this.myImportPrefix + this.myCurrentText.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "createImportString"));
            }
            return string;
        }

        @NotNull
        private ImportBuilder cloneBuilder() {
            ImportBuilder importBuilder = new ImportBuilder(this.myStyle, this.myImportPrefix, this.myFromPart);
            if (importBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder", "cloneBuilder"));
            }
            return importBuilder;
        }
    }

    private static class ImportStyle {
        private final String mySemicolon;
        private final String myQuote;
        private final boolean myAddTrailingComma;

        public ImportStyle(String quote, boolean addTrailingComma, String semicolon) {
            this.mySemicolon = semicolon;
            this.myQuote = quote;
            this.myAddTrailingComma = addTrailingComma;
        }
    }
}

