/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSModuleImportOptimizerBase
implements ImportOptimizer {
    @NotNull
    public Runnable processFile(PsiFile file) {
        if (!JSOptimizeImportUtil.isAvailable(file)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "processFile"));
            }
            return runnable;
        }
        Collection<UnusedModuleInfo> infos = this.getModulesInfo(file);
        if (infos.isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "processFile"));
            }
            return runnable;
        }
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            if (document != null) {
                manager.commitDocument(document);
            }
            Project project = file.getProject();
            infos.forEach(info -> this.processModule(document, project, (UnusedModuleInfo)info));
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "processFile"));
        }
        return runnable;
    }

    public void processModule(Document document, Project project, UnusedModuleInfo info) {
        List<PsiElement> oldImports = info.getOldImports();
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> commentInfos = JSModuleImportOptimizerBase.getCommentInfos(oldImports, document);
        List<String> importTexts = info.getImportTexts();
        PsiElement anchor = info.getAnchor();
        if (anchor == null) {
            return;
        }
        if (!importTexts.isEmpty()) {
            JSOptimizeImportUtil.addNewImportTexts(importTexts, project, document, anchor);
        }
        this.removeOldImports(oldImports, commentInfos);
    }

    protected void removeOldImports(@NotNull List<PsiElement> oldImports, @NotNull Map<PsiElement, JSOptimizeImportUtil.CommentHolder> comments) {
        if (oldImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldImports", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "removeOldImports"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "removeOldImports"));
        }
        for (int i = 0; i < oldImports.size(); ++i) {
            boolean isFirst = i == 0;
            PsiElement declaration = oldImports.get(i);
            JSOptimizeImportUtil.CommentHolder pair = comments.get(declaration);
            List<PsiElement> prevComments = pair.prevComments;
            PsiElement sameLineEndComment = pair.lineComment;
            boolean hasComments = prevComments.size() > 0;
            PsiElement beforeElement = hasComments ? prevComments.get(0) : declaration;
            PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
            JSOptimizeImportUtil.deleteSiblingWhitespaceBetweenImports(beforeElement, afterElement, !isFirst);
            if (hasComments || sameLineEndComment != null) {
                declaration.getParent().deleteChildRange(beforeElement, afterElement);
                continue;
            }
            declaration.delete();
        }
    }

    @NotNull
    private static HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> getCommentInfos(@NotNull List<PsiElement> imports, @Nullable Document document) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "getCommentInfos"));
        }
        HashMap prevDeclarations = ContainerUtil.newHashMap();
        for (PsiElement declaration : imports) {
            prevDeclarations.put(declaration, new JSOptimizeImportUtil.CommentHolder(JSOptimizeImportUtil.getPrevComments(document, declaration), JSOptimizeImportUtil.getLineComment(document, declaration)));
        }
        HashMap hashMap = prevDeclarations;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase", "getCommentInfos"));
        }
        return hashMap;
    }

    @NotNull
    public abstract Collection<UnusedModuleInfo> getModulesInfo(PsiFile var1);

    public static interface UnusedModuleInfo {
        public List<String> getImportTexts();

        @Nullable
        public PsiElement getAnchor();

        public List<PsiElement> getOldImports();
    }
}

