/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6BindWithArrowFunctionInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression function) {
                Pair pair;
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection$1", "visitJSFunctionExpression"));
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)function)) {
                    return;
                }
                boolean anonymousArrow = JSPsiImplUtils.isArrowFunction((JSFunction)function);
                if (anonymousArrow && (pair = ES6BindWithArrowFunctionInspection.checkForBindingFunctions(function)) != null && pair.getFirst() != null && pair.getSecond() != null) {
                    JSExpression expression = ((JSCallExpression)pair.getSecond()).getMethodExpression();
                    holder.registerProblem((PsiElement)(expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceNameElement() : expression), JSBundle.message((String)"js.suspicious.bind.with.arrow.function", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                super.visitJSFunctionExpression(function);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static Pair<String, JSCallExpression> checkForBindingFunctions(@NotNull JSFunctionExpression function) {
        JSCallExpression callExpression;
        JSExpression[] arguments;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection", "checkForBindingFunctions"));
        }
        PsiElement parent = function.getParent();
        if (parent instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCallExpression && "bind".equals(ES6BindWithArrowFunctionInspection.getCallExpressionName((JSCallExpression)parent.getParent())) && (arguments = (callExpression = (JSCallExpression)parent.getParent()).getArguments()).length == 1) {
            return Pair.create((Object)"bind", (Object)callExpression);
        }
        return null;
    }

    private static String getCallExpressionName(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection", "getCallExpressionName"));
        }
        if (call.getMethodExpression() instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)call.getMethodExpression()).getReferenceName();
        }
        return null;
    }
}

