/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportQuickFix;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertModuleExportToExportInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
                if (assignment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection$1", "visitJSAssignmentExpression"));
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)assignment)) {
                    return;
                }
                List nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment);
                if (nameParts == null) {
                    return;
                }
                List exportedNameParts = ES6ConvertModuleExportToExportInspection.isExport(nameParts, false);
                if (exportedNameParts == null) {
                    return;
                }
                String exportedName = exportedNameParts.isEmpty() ? null : (String)exportedNameParts.get(0);
                boolean onlyHighlight = "exports".equals(nameParts.get(0)) && exportedNameParts.isEmpty() || exportedNameParts.size() > 1 || !exportedNameParts.isEmpty() && ("prototype".equals(exportedName) || "constructor".equals(exportedName) || exportedName != null && exportedName.startsWith("["));
                JSExpression expression = assignment.getDefinitionExpression().getExpression();
                assert (expression != null);
                if (onlyHighlight) {
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertModuleExportToExportQuickFix(assignment, exportedName)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    static boolean checkContext(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection", "checkContext"));
        }
        if (!ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel((JSElement)assignment)) {
            return false;
        }
        PsiElement parent = assignment.getParent();
        return parent instanceof JSSourceElement || parent instanceof JSCommaExpression;
    }

    private static List<String> checkAssignmentGetDefinitionReference(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection", "checkAssignmentGetDefinitionReference"));
        }
        if (assignment.getOperationSign() != JSTokenTypes.EQ) {
            return null;
        }
        JSDefinitionExpression definition = assignment.getDefinitionExpression();
        if (definition == null || definition.getInitializerOrStub() == null || definition.getExpression() == null) {
            return null;
        }
        if (!ES6ConvertModuleExportToExportInspection.checkContext(assignment)) {
            return null;
        }
        return JSSymbolUtil.getReferenceParts(definition.getExpression());
    }

    @Nullable
    static List<String> checkAssignmentToBeExport(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection", "checkAssignmentToBeExport"));
        }
        List<String> nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment);
        if (nameParts == null) {
            return null;
        }
        return ES6ConvertModuleExportToExportInspection.isExport(nameParts, true);
    }

    @Nullable
    private static List<String> isExport(@NotNull List<String> nameParts, boolean ignoreShortDefaultExport) {
        if (nameParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameParts", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection", "isExport"));
        }
        if ("exports".equals(nameParts.get(0))) {
            return ignoreShortDefaultExport && nameParts.size() == 1 ? null : nameParts.subList(1, nameParts.size());
        }
        if ("module".equals(nameParts.get(0)) && nameParts.size() > 1 && "exports".equals(nameParts.get(1))) {
            return nameParts.subList(2, nameParts.size());
        }
        return null;
    }
}

