/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportInspection;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertModuleExportToExportQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    @Nullable
    private final String myExportedName;

    public ES6ConvertModuleExportToExportQuickFix(@NotNull JSAssignmentExpression assignment, @Nullable String exportedName) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "<init>"));
        }
        super((PsiElement)assignment);
        this.myExportedName = exportedName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.module.exports.into.es6.export.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "getText"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.module.exports.into.es6.export.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSExpression initializer;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "invoke"));
        }
        assert (this.getStartElement() instanceof JSAssignmentExpression);
        JSAssignmentExpression element = (JSAssignmentExpression)this.getStartElement();
        JSDefinitionExpression definition = element.getDefinitionExpression();
        if (definition == null || (initializer = JSPsiImplUtils.getInitializer(definition.getNode())) == null || initializer.getPrevSibling() == null) {
            return;
        }
        JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSourceElement.class);
        if (sourceElement == null || !ES6ConvertModuleExportToExportInspection.checkContext(element)) {
            return;
        }
        SmartList toReformat = new SmartList();
        List<PsiComment> comments = this.collectInlineCommentsToBeRemoved(definition, initializer);
        JSElement createdElement = this.myExportedName == null ? ES6ConvertModuleExportToExportQuickFix.createDefaultExport(project, element, sourceElement, initializer, (List<FormatFixer>)toReformat) : (initializer instanceof JSFunction ? ES6ConvertModuleExportToExportQuickFix.createFunctionExport(project, element, (JSFunction)initializer, this.myExportedName) : (initializer instanceof JSClass ? ES6ConvertModuleExportToExportQuickFix.createClassExport(project, element, (JSClass)initializer, this.myExportedName) : (initializer instanceof JSReferenceExpression && ((JSReferenceExpression)initializer).getQualifier() == null && !ES6ConvertModuleExportToExportQuickFix.isPredefinedConstant((JSReferenceExpression)initializer) ? ES6ConvertModuleExportToExportQuickFix.createReferenceExport(project, element, (JSReferenceExpression)initializer, this.myExportedName) : ES6ConvertModuleExportToExportQuickFix.createConstExport(project, element, initializer, this.myExportedName))));
        if (this.myExportedName != null) {
            ES6ConvertModuleExportToExportQuickFix.simplifyExportedObjectDetails(element, this.myExportedName);
        }
        PsiElement createdInFile = ES6ConvertModuleExportToExportQuickFix.createEquivalentExpression(element, sourceElement, createdElement, comments);
        toReformat.add(ES6ConvertModuleExportToExportQuickFix.createFixerForReformatWithoutBody(createdInFile));
        toReformat.forEach(FormatFixer::fixFormat);
        ES6ConvertModuleExportToExportQuickFix.caretAtStartOfCreatedExport(editor, createdInFile);
    }

    @NotNull
    private List<PsiComment> collectInlineCommentsToBeRemoved(JSDefinitionExpression definition, JSExpression initializer) {
        List<PsiComment> comments;
        if (this.myExportedName != null && initializer instanceof JSFunction && ((JSFunction)initializer).getParameterList() != null) {
            JSParameterList parameterList = ((JSFunction)initializer).getParameterList();
            assert (parameterList != null);
            comments = JSChangeUtil.getCommentsInBetween((PsiElement)definition, (PsiElement)parameterList);
            ASTNode leftBrace = JSRefactoringUtil.getLeftBrace((PsiElement)initializer);
            if (leftBrace != null) {
                comments.addAll(JSChangeUtil.getCommentsInBetween((PsiElement)parameterList, leftBrace.getPsi()));
            }
        } else {
            comments = JSChangeUtil.getCommentsInBetween((PsiElement)definition, (PsiElement)initializer);
        }
        List<PsiComment> list = comments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "collectInlineCommentsToBeRemoved"));
        }
        return list;
    }

    private static FormatFixer createFixerForReformatWithoutBody(@NotNull PsiElement createdInFile) {
        JSExpression expression;
        if (createdInFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdInFile", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFixerForReformatWithoutBody"));
        }
        PsiElement element = createdInFile;
        if (createdInFile instanceof ES6ExportDefaultAssignment && (expression = ((ES6ExportDefaultAssignment)createdInFile).getExpression()) != null) {
            element = expression;
        }
        return JSRefactoringUtil.createFixerForReformatWithoutBody(createdInFile, element);
    }

    @NotNull
    private static JSElement createDefaultExport(@NotNull Project project, @NotNull JSAssignmentExpression mainAssignment, @NotNull JSSourceElement sourceElement, @NotNull JSExpression initializer, @NotNull List<FormatFixer> toReformat) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        if (mainAssignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainAssignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        if (toReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReformat", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        List<Pair<JSAssignmentExpression, List<String>>> list = PsiTreeUtil.findChildrenOfType((PsiElement)mainAssignment.getContainingFile(), JSAssignmentExpression.class).stream().map(assignment -> Pair.create((Object)assignment, ES6ConvertModuleExportToExportInspection.checkAssignmentToBeExport(assignment))).filter(pair -> pair.getSecond() != null && ((JSAssignmentExpression)pair.getFirst()).getDefinitionExpression() != null).filter(pair -> !((List)pair.getSecond()).isEmpty() && ("prototype".equals(((List)pair.getSecond()).get(0)) || "constructor".equals(((List)pair.getSecond()).get(0)))).sorted(Comparator.comparingInt(o -> ((List)o.getSecond()).size())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            JSElement jSElement = ES6ConvertModuleExportToExportQuickFix.createClassLikeDefaultExport(project, mainAssignment, sourceElement, initializer, list, toReformat);
            if (jSElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
            }
            return jSElement;
        }
        boolean omitSemicolon = initializer instanceof JSFunction || initializer instanceof JSClass;
        String text = omitSemicolon ? "export default {}" : "export default 1" + JSCodeStyleSettings.getSemicolon(mainAssignment.getContainingFile());
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)mainAssignment));
        assert (astNode != null);
        ES6ExportDefaultAssignment exportDefaultAssignment = (ES6ExportDefaultAssignment)astNode.getPsi(ES6ExportDefaultAssignment.class);
        assert (exportDefaultAssignment.getExpression() != null);
        exportDefaultAssignment.getExpression().replace(initializer.copy());
        ES6ExportDefaultAssignment eS6ExportDefaultAssignment = exportDefaultAssignment;
        if (eS6ExportDefaultAssignment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createDefaultExport"));
        }
        return eS6ExportDefaultAssignment;
    }

    private static JSElement createClassLikeDefaultExport(@NotNull Project project, @NotNull JSAssignmentExpression mainAssignment, @NotNull JSSourceElement sourceElement, @NotNull JSExpression initializer, @NotNull List<Pair<JSAssignmentExpression, List<String>>> otherAssignments, @NotNull List<FormatFixer> toReformat) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        if (mainAssignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainAssignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        if (otherAssignments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherAssignments", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        if (toReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReformat", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassLikeDefaultExport"));
        }
        String varName = JSChangeUtil.generateNewVarName("_export", (PsiElement)mainAssignment.getContainingFile());
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)mainAssignment);
        String semicolon = JSCodeStyleSettings.getSemicolon(mainAssignment.getContainingFile());
        assert (!otherAssignments.isEmpty());
        otherAssignments.forEach(pair -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "lambda$createClassLikeDefaultExport$4"));
            }
            ASTNode refNode = JSChangeUtil.createExpressionFromText(project, varName + "." + StringUtil.join((Collection)((Collection)pair.getSecond()), (String)"."), dialect);
            assert (refNode != null);
            JSReferenceExpression newRef = (JSReferenceExpression)refNode.getPsi(JSReferenceExpression.class);
            ((JSAssignmentExpression)pair.getFirst()).getDefinitionExpression().getExpression().replace((JSExpression)newRef);
        });
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, "const " + varName + "=1" + semicolon + "\n", dialect);
        assert (astNode != null);
        JSVarStatement statement = (JSVarStatement)astNode.getPsi(JSVarStatement.class);
        assert (statement.getVariables().length == 1);
        JSVariable variable = statement.getVariables()[0];
        assert (variable.getInitializer() != null);
        variable.getInitializer().replace(initializer);
        PsiElement added = sourceElement.getParent().addBefore((PsiElement)statement, (PsiElement)sourceElement);
        toReformat.add(ES6ConvertModuleExportToExportQuickFix.createFixerForReformatWithoutBody(added));
        String text = "export default " + varName + semicolon;
        ASTNode exportNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)mainAssignment));
        assert (exportNode != null);
        return (JSElement)exportNode.getPsi(ES6ExportDefaultAssignment.class);
    }

    @NotNull
    private static JSElement createConstExport(@NotNull Project project, @NotNull JSAssignmentExpression element, @NotNull JSExpression initializer, @NotNull String name) {
        JSVarStatement createdElement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createConstExport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createConstExport"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createConstExport"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createConstExport"));
        }
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, "export const " + name + " = 1" + JSCodeStyleSettings.getSemicolon(element.getContainingFile()), DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSVarStatement statement = (JSVarStatement)astNode.getPsi(JSVarStatement.class);
        assert (statement.getVariables()[0].getInitializer() != null);
        statement.getVariables()[0].getInitializer().replace(initializer);
        JSVarStatement jSVarStatement = createdElement = statement;
        if (jSVarStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createConstExport"));
        }
        return jSVarStatement;
    }

    @NotNull
    private static JSElement createReferenceExport(@NotNull Project project, @NotNull JSAssignmentExpression element, @NotNull JSReferenceExpression ref, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createReferenceExport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createReferenceExport"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createReferenceExport"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createReferenceExport"));
        }
        String text = name.equals(ref.getReferenceName()) ? String.format("export {%s}", name) : String.format("export {%s as %s}", ref.getText(), name);
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSElement jSElement = (JSElement)astNode.getPsi(ES6ExportDeclaration.class);
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createReferenceExport"));
        }
        return jSElement;
    }

    @NotNull
    private static JSElement createClassExport(@NotNull Project project, JSAssignmentExpression element, JSClass clazz, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassExport"));
        }
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, "export class " + name + "{}", DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSClass createdClass = (JSClass)astNode.getPsi(JSClass.class);
        ASTNode brace = createdClass.getNode().findChildByType(JSTokenTypes.RBRACE);
        assert (brace != null);
        ASTNode[] children = clazz.getNode().getChildren(null);
        boolean afterBracket = false;
        for (ASTNode child : children) {
            if (afterBracket) {
                if (child.getElementType() == JSTokenTypes.RBRACE) break;
                createdClass.addBefore(child.getPsi().copy(), brace.getPsi());
                continue;
            }
            if (child.getElementType() != JSTokenTypes.LBRACE) continue;
            afterBracket = true;
        }
        JSClass jSClass = createdClass;
        if (jSClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createClassExport"));
        }
        return jSClass;
    }

    @NotNull
    private static JSElement createFunctionExport(@NotNull Project project, @NotNull JSAssignmentExpression element, @NotNull JSFunction function, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFunctionExport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFunctionExport"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFunctionExport"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFunctionExport"));
        }
        String text = String.format("export %s function%s %s(){}", JSFunctionsHelper.getFunctionAttributesModifiersText(function), function.isGenerator() ? "*" : "", name);
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSFunction createdFunction = (JSFunction)astNode.getPsi(JSFunction.class);
        assert (createdFunction != null);
        JSFunctionsHelper.copyFunctionFilling(function, createdFunction);
        JSFunction jSFunction = createdFunction;
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createFunctionExport"));
        }
        return jSFunction;
    }

    private static boolean isPredefinedConstant(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "isPredefinedConstant"));
        }
        return Stream.of("undefined", "NaN", "Infinity").anyMatch(name -> {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "lambda$isPredefinedConstant$5"));
            }
            return JSSymbolUtil.isAccurateReferenceExpressionName(ref, name);
        });
    }

    @NotNull
    private static PsiElement createEquivalentExpression(@NotNull JSAssignmentExpression element, @NotNull JSSourceElement sourceElement, @NotNull JSElement createdElement, @NotNull List<PsiComment> comments) {
        PsiElement createdInFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createEquivalentExpression"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createEquivalentExpression"));
        }
        if (createdElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdElement", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createEquivalentExpression"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createEquivalentExpression"));
        }
        Map<PsiComment, PsiComment> map = comments.stream().collect(Collectors.toMap(Function.identity(), e -> (PsiComment)e.copy()));
        CommentsMover mover = new CommentsMover(sourceElement);
        if (element.getParent() instanceof JSSourceElement) {
            createdInFile = element.getParent().replace((PsiElement)createdElement);
        } else {
            createdInFile = sourceElement.getNextSibling() != null ? JSChangeUtil.doDoAddBeforePure(sourceElement.getParent(), (PsiElement)createdElement, sourceElement.getNextSibling()) : JSChangeUtil.doDoAddAfter(sourceElement.getParent(), (PsiElement)createdElement, (PsiElement)sourceElement);
            if (element.getParent() instanceof JSCommaExpression) {
                JSChangeUtil.deletePartOfCommaExpression(element, (Consumer<PsiComment>)((Consumer)comment -> {
                    if (comments == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "lambda$createEquivalentExpression$7"));
                    }
                    comments.add((PsiComment)comment);
                    map.put((PsiComment)comment, (PsiComment)comment.copy());
                }));
            } else {
                JSChangeUtil.removeRangeWithRemovalOfCommas(element.getNode(), element.getParent().getNode());
            }
        }
        if (!sourceElement.isValid()) {
            Set set = ContainerUtil.set((Object[])new PsiElement[]{createdInFile});
            mover.move(set, set);
        }
        ES6ConvertModuleExportToExportQuickFix.moveInlineComments(comments, map, createdInFile);
        PsiElement psiElement = createdInFile;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "createEquivalentExpression"));
        }
        return psiElement;
    }

    private static void moveInlineComments(@NotNull List<PsiComment> comments, @NotNull Map<PsiComment, PsiComment> map, @NotNull PsiElement createdInFile) {
        PsiElement added;
        PsiElement sibling;
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "moveInlineComments"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "moveInlineComments"));
        }
        if (createdInFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdInFile", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "moveInlineComments"));
        }
        Ref firstAddedComment = new Ref();
        comments.forEach(comment -> {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "lambda$moveInlineComments$8"));
            }
            if (createdInFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdInFile", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "lambda$moveInlineComments$8"));
            }
            PsiComment copy = (PsiComment)map.get(comment);
            PsiElement added = JSChangeUtil.doDoAddBeforePure(createdInFile.getParent(), (PsiElement)copy, createdInFile);
            if (firstAddedComment.isNull()) {
                firstAddedComment.set((Object)added);
            }
        });
        if (!(firstAddedComment.isNull() || (sibling = (added = (PsiElement)firstAddedComment.get()).getPrevSibling()) instanceof PsiWhiteSpace && sibling.getText().contains("\n"))) {
            JSChangeUtil.addWs(added.getParent().getNode(), added.getNode(), "\n");
        }
    }

    private static void caretAtStartOfCreatedExport(@Nullable Editor editor, @NotNull PsiElement createdInFile) {
        if (createdInFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdInFile", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "caretAtStartOfCreatedExport"));
        }
        if (editor == null) {
            editor = PsiUtilBase.findEditor((PsiElement)createdInFile);
        }
        if (editor != null) {
            PsiElement sibling;
            int offset = createdInFile.getTextRange().getStartOffset();
            JSDocComment comment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)createdInFile, JSDocComment.class);
            if (comment != null && (sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)comment, (Class[])new Class[]{PsiWhiteSpace.class})) != null) {
                offset = sibling.getTextRange().getStartOffset();
            }
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static void simplifyExportedObjectDetails(@NotNull JSAssignmentExpression mainAssignment, @NotNull String name) {
        if (mainAssignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainAssignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "simplifyExportedObjectDetails"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix", "simplifyExportedObjectDetails"));
        }
        JSDefinitionExpression definition = mainAssignment.getDefinitionExpression();
        if (definition == null) {
            return;
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)mainAssignment);
        ASTNode astNode = JSChangeUtil.createExpressionFromText(mainAssignment.getProject(), name, dialect);
        assert (astNode != null);
        JSExpression newExpression = (JSExpression)astNode.getPsi(JSExpression.class);
        Collection references = ReferencesSearch.search((PsiElement)definition, (SearchScope)GlobalSearchScope.fileScope((PsiFile)mainAssignment.getContainingFile())).findAll();
        references.forEach(ref -> {
            if (!ref.equals(definition) && ref instanceof PsiElement) {
                ((PsiElement)ref).replace((PsiElement)newExpression);
            }
        });
    }
}

