/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHeaderKeeper {
    @NotNull
    private final PsiElement myContainer;
    @Nullable
    private CutState myCutState;
    @Nullable
    private final SmartPsiElementPointer<PsiComment> mySmartPointToComment;

    public FileHeaderKeeper(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/inspections/FileHeaderKeeper", "<init>"));
        }
        this.myContainer = container;
        PsiComment comment = this.findJSDocForFirstElement();
        this.mySmartPointToComment = comment == null ? null : SmartPointerManager.getInstance((Project)container.getProject()).createSmartPsiElementPointer((PsiElement)comment);
    }

    public void saveStateAndCutHeader() {
        this.myCutState = this.cutHeader();
    }

    public boolean canMove() {
        return this.getComment() != null;
    }

    @Nullable
    private PsiComment getComment() {
        return this.mySmartPointToComment == null ? null : (PsiComment)this.mySmartPointToComment.getElement();
    }

    public void moveHeader() {
        this.restoreHeader(this.cutHeader());
    }

    public void returnHeaderForSavedState() {
        CutState state = this.myCutState;
        PsiElement newHeader = this.restoreHeader(state);
        if (state != null && newHeader != null) {
            state.myEraser.process(newHeader);
        }
    }

    public CutState cutHeader() {
        PsiComment comment = this.getComment();
        if (comment == null) {
            return null;
        }
        PsiComment header = (PsiComment)comment.copy();
        ArrayList afterSpaces = ContainerUtil.newArrayList();
        PsiElement prevElement = comment.getPrevSibling();
        PsiWhiteSpace beforeHeader = prevElement instanceof PsiWhiteSpace ? (PsiWhiteSpace)prevElement.copy() : null;
        NewLineEraser eraser = new NewLineEraser((PsiElement)comment);
        PsiElement current = comment.getNextSibling();
        comment.delete();
        while (current instanceof PsiWhiteSpace && current.isValid()) {
            afterSpaces.add((PsiWhiteSpace)current.copy());
            PsiElement next = current.getNextSibling();
            current.delete();
            current = next;
        }
        return new CutState(header, beforeHeader, afterSpaces, eraser);
    }

    @Nullable
    private PsiComment findJSDocForFirstElement() {
        PsiElement firstElement = FileHeaderKeeper.getFirstNotWhiteSpace(this.myContainer);
        if (firstElement == null || firstElement instanceof PsiComment) {
            return null;
        }
        PsiElement child = FileHeaderKeeper.getFirstNotWhiteSpace(firstElement);
        return child instanceof PsiComment ? (PsiComment)child : null;
    }

    @Nullable
    private static PsiElement getFirstNotWhiteSpace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/FileHeaderKeeper", "getFirstNotWhiteSpace"));
        }
        PsiElement firstElement = element.getFirstChild();
        if (firstElement instanceof PsiWhiteSpace) {
            firstElement = JSRefactoringUtil.skipWhitespaces(firstElement, true);
        }
        return firstElement;
    }

    private PsiElement restoreHeader(@Nullable CutState state) {
        if (state == null || state.myHeader == null) {
            return null;
        }
        PsiElement anchor = this.getInsertionAnchor();
        if (anchor != null) {
            anchor = this.myContainer.addBefore((PsiElement)state.myHeader, anchor);
            if (state.myBeforeHeader != null) {
                this.myContainer.addBefore((PsiElement)state.myBeforeHeader, anchor);
            }
        } else {
            anchor = this.myContainer.add((PsiElement)state.myHeader);
        }
        PsiElement newHeader = anchor;
        for (PsiWhiteSpace space : state.myAfterSpaces) {
            anchor = this.myContainer.addAfter((PsiElement)space, anchor);
        }
        return newHeader;
    }

    private PsiElement getInsertionAnchor() {
        return this.myContainer.getFirstChild();
    }

    private static class CutState {
        @Nullable
        private final PsiWhiteSpace myBeforeHeader;
        @NotNull
        private final List<PsiWhiteSpace> myAfterSpaces;
        @Nullable
        private final PsiComment myHeader;
        @NotNull
        private final NewLineEraser myEraser;

        CutState(@Nullable PsiComment header, @Nullable PsiWhiteSpace beforeHeader, @NotNull List<PsiWhiteSpace> afterSpaces, @NotNull NewLineEraser eraser) {
            if (afterSpaces == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterSpaces", "com/intellij/lang/javascript/inspections/FileHeaderKeeper$CutState", "<init>"));
            }
            if (eraser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eraser", "com/intellij/lang/javascript/inspections/FileHeaderKeeper$CutState", "<init>"));
            }
            this.myBeforeHeader = beforeHeader;
            this.myAfterSpaces = afterSpaces;
            this.myHeader = header;
            this.myEraser = eraser;
        }
    }
}

