/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSBitwiseOperatorUsageInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                JSType type;
                IElementType sign = node.getOperationSign();
                if ((JSTokenTypes.AND.equals(sign) || JSTokenTypes.OR.equals(sign)) && (type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)) != null && "Boolean".equals(type.getTypeText())) {
                    ASTNode astNode = node.getNode();
                    JSBinaryExpression problemNode = astNode != null ? astNode.findChildByType(sign).getPsi() : node;
                    holder.registerProblem((PsiElement)problemNode, JSBundle.message((String)"js.bitwise.operator.usage.popup", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceBitwiseOperatorQuickFix(sign)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.bitwise.operator.usage.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection", "getDisplayName"));
        }
        return string;
    }

    static class ReplaceBitwiseOperatorQuickFix
    implements LocalQuickFix {
        @NotNull
        private final IElementType myNewOperator;
        private final String myNewOperatorText;

        public ReplaceBitwiseOperatorQuickFix(IElementType originalOperator) {
            Object object = JSTokenTypes.AND.equals(originalOperator) ? JSTokenTypes.ANDAND : (this.myNewOperator = JSTokenTypes.OR.equals(originalOperator) ? JSTokenTypes.OROR : null);
            if (this.myNewOperator == null) {
                throw new IllegalArgumentException("Replace bitwise operator must be & or |");
            }
            this.myNewOperatorText = JSTokenTypes.ANDAND.equals(this.myNewOperator) ? "&&" : "||";
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.bitwise.operator.usage.quickfix", (Object[])new Object[]{this.myNewOperatorText});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSBitwiseOperatorUsageInspection$ReplaceBitwiseOperatorQuickFix", "applyFix"));
            }
            PsiElement element = descriptor2.getPsiElement();
            if (element instanceof LeafElement) {
                LeafElement oldLeaf = (LeafElement)element;
                LeafElement newLeaf = ASTFactory.leaf((IElementType)this.myNewOperator, (CharSequence)this.myNewOperatorText);
                CodeEditUtil.setNodeGenerated((ASTNode)newLeaf, (boolean)true);
                oldLeaf.getTreeParent().replaceChild((ASTNode)oldLeaf, (ASTNode)newLeaf);
            }
        }
    }
}

