/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDeclarationsAtScopeStartInspection
extends JSInspection {
    public static final String SHORT_NAME = JSDeclarationsAtScopeStartInspection.calcShortNameFromClass(JSDeclarationsAtScopeStartInspection.class);
    public boolean myMakeSingleVarStatement;

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.declarations.at.scope.start.inspection", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"js.make.single.var.statement", (Object[])new Object[0]), (InspectionProfileEntry)this, "myMakeSingleVarStatement");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVarStatement(JSVarStatement node) {
                JSStatement firstStatement = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)node);
                if (firstStatement != null) {
                    if (!JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement) {
                        while (firstStatement != null && firstStatement != node && (firstStatement instanceof JSVarStatement || !(firstStatement instanceof JSStatement))) {
                            firstStatement = firstStatement.getNextSibling();
                        }
                    }
                    if (firstStatement != node) {
                        LocalQuickFix action = JSFixFactory.getInstance().jsMoveToScopeStartIntentionAction(JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement);
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.declaration.is.not.at.scope.start", (Object[])new Object[0]), new LocalQuickFix[]{action});
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Nullable
    public static JSStatement findContainingFunctionFirstStatement(@Nullable PsiElement element) {
        return JSPsiImplUtils.findFirstFunctionStatement((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class, (boolean)false));
    }

    public static boolean isEnabledForElement(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        LocalInspectionToolWrapper localInspectionToolWrapper = (LocalInspectionToolWrapper)inspectionProfile.getInspectionTool(SHORT_NAME, element);
        return localInspectionToolWrapper != null && inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)SHORT_NAME), element);
    }
}

