/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSForInStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSForStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "isSuppressedFor"));
        }
        if (!IntentionAndInspectionFilter.isInspectionSupportedForElement(toolId, element)) {
            return true;
        }
        return SuppressionUtil.isSuppressedInStatement((PsiElement)element, (String)toolId, JSInspectionSuppressor.getHolderClass(element));
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "getSuppressActions"));
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.findById((String)toolId);
        assert (highlightDisplayKey != null) : toolId;
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{JSFixFactory.getInstance().suppressByCommentFix(highlightDisplayKey, JSInspectionSuppressor.getHolderClass(element))};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    @NotNull
    public static Class<? extends JSSuppressionHolder> getHolderClass(PsiElement element) {
        JSSuppressionHolder parent = (JSSuppressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, JSSuppressionHolder.class);
        if (parent instanceof JSVarStatement) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSForStatement) {
                if (JSForStatementImpl.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "getHolderClass"));
                }
                return JSForStatementImpl.class;
            }
            if (grandParent instanceof JSForInStatement) {
                if (JSForInStatementImpl.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "getHolderClass"));
                }
                return JSForInStatementImpl.class;
            }
        }
        if (JSSuppressionHolder.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspectionSuppressor", "getHolderClass"));
        }
        return JSSuppressionHolder.class;
    }
}

