/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMismatchedCollectionQueryUpdateInspectionBase
extends JSInspection {
    protected final List<String> myQueryNames = new ArrayList<String>();
    protected final List<String> myUpdateNames = new ArrayList<String>();
    @NonNls
    public String queries = "trace,write,forEach";
    @NonNls
    public String updates = "pop,push,shift,splice,unshift,add,insert,remove";

    public JSMismatchedCollectionQueryUpdateInspectionBase() {
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.queries, this.myQueryNames);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    protected static void parseString(String string, Collection<String> out) {
        out.clear();
        out.addAll(StringUtil.split((String)string, (String)","));
    }

    private static String formatString(Collection<String> strings) {
        int size = strings.size();
        if (size > 0) {
            StringBuilder out = new StringBuilder();
            for (String s : strings) {
                out.append(s).append(',');
            }
            return out.substring(0, out.length() - 1);
        }
        return "";
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.queries, this.myQueryNames);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase", "writeSettings"));
        }
        this.queries = JSMismatchedCollectionQueryUpdateInspectionBase.formatString(this.myQueryNames);
        this.updates = JSMismatchedCollectionQueryUpdateInspectionBase.formatString(this.myUpdateNames);
        super.writeSettings(node);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.mismatched.update.collection.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MismatchedCollectionQueryUpdateVisitor mismatchedCollectionQueryUpdateVisitor = new MismatchedCollectionQueryUpdateVisitor(holder);
        if (mismatchedCollectionQueryUpdateVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase", "createVisitor"));
        }
        return mismatchedCollectionQueryUpdateVisitor;
    }

    private class CollectionQueryCalledVisitor
    extends Visitor {
        private boolean queried;

        public CollectionQueryCalledVisitor(JSVariable variable) {
            super(variable);
        }

        public void visitJSCallExpression(JSCallExpression node) {
            super.visitJSCallExpression(node);
            if (!this.queried) {
                PsiElement parent = node.getParent();
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    if (parent instanceof JSExpressionStatement && !Visitor.checkMethodName((JSReferenceExpression)methodExpression, JSMismatchedCollectionQueryUpdateInspectionBase.this.myQueryNames)) {
                        return;
                    }
                    JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                    if (this.checkReference((PsiElement)qualifier)) {
                        this.queried = true;
                    }
                }
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            JSEmbeddedContent content;
            super.visitJSReferenceExpression(node);
            if (!this.queried && DialectDetector.isJSX((PsiElement)node) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class)) != null && this.checkReference((PsiElement)node)) {
                this.queried = true;
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            super.visitJSForInStatement(node);
            if (!this.queried) {
                JSExpression collectionExpression = node.getCollectionExpression();
                this.queried = this.checkReference((PsiElement)collectionExpression);
            }
        }

        public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.queried && !((parent = node.getParent()) instanceof JSDefinitionExpression)) {
                JSExpression qualifier = node.getQualifier();
                this.queried = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isQueryCalled() {
            return this.queried;
        }
    }

    private class CollectionUpdateCalledVisitor
    extends Visitor {
        private boolean updated;

        public CollectionUpdateCalledVisitor(JSVariable variable) {
            super(variable);
        }

        public void visitElement(PsiElement element) {
            if (!this.updated) {
                super.visitElement(element);
            }
        }

        public void visitJSCallExpression(JSCallExpression node) {
            JSExpression methodExpression;
            super.visitJSCallExpression(node);
            if (!this.updated && (methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
                if (!Visitor.checkMethodName((JSReferenceExpression)methodExpression, JSMismatchedCollectionQueryUpdateInspectionBase.this.myUpdateNames)) {
                    return;
                }
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (this.checkReference((PsiElement)qualifier)) {
                    this.updated = true;
                }
            }
        }

        public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.updated && (parent = node.getParent()) instanceof JSDefinitionExpression) {
                JSExpression qualifier = node.getQualifier();
                this.updated = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isUpdateCalled() {
            return this.updated;
        }
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends JSElementVisitor {
        private ProblemsHolder myHolder;
        private JSType myType;

        public MismatchedCollectionQueryUpdateVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        private void registerError(JSVariable variable, boolean updated) {
            PsiElement element = variable.getNameIdentifier();
            if (element == null) {
                element = variable;
            }
            this.myHolder.registerProblem(element, JSBundle.message((String)(updated ? "collection.updated.but.not.queried" : "collection.queried.but.not.update"), (Object[])new Object[0]), new LocalQuickFix[0]);
        }

        public void visitJSVarStatement(JSVarStatement varStatement) {
            super.visitJSVarStatement(varStatement);
            PsiElement nearestParent = varStatement.getParent();
            if (nearestParent instanceof JSForInStatement && ((JSForInStatement)nearestParent).getDeclarationStatement() == varStatement) {
                return;
            }
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)nearestParent, JSBlockStatement.class, (boolean)false);
            if (parent == null && !((parent = varStatement.getParent()) instanceof JSClass)) {
                return;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                this.process(variable, (JSElement)parent);
            }
        }

        private void process(@NotNull JSVariable variable, @NotNull JSElement parent) {
            JSAttributeList attributeList;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "process"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "process"));
            }
            if (parent instanceof JSClass && ((attributeList = variable.getAttributeList()) == null || attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE)) {
                return;
            }
            if (!this.checkVariable(variable, parent)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(variable, parent);
            boolean read = this.collectionContentsAreQueried(variable, parent);
            if (read != written) {
                this.registerError(variable, written);
            }
        }

        private boolean collectionContentsAreQueried(JSVariable variable, JSElement context) {
            return this.collectionQueryCalled(variable, context);
        }

        private boolean collectionContentsAreUpdated(JSVariable variable, JSElement context) {
            if (this.collectionUpdateCalled(variable, context)) {
                return true;
            }
            JSExpression initializer = variable.getInitializer();
            if (initializer != null && !this.isEmptyInitializer(initializer)) {
                return true;
            }
            return VariableAccessUtil.variableIsAssigned(variable, context);
        }

        private boolean isEmptyInitializer(@NotNull JSExpression initializer) {
            if (initializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "isEmptyInitializer"));
            }
            if (initializer instanceof JSArrayLiteralExpression) {
                JSExpression[] expressions = ((JSArrayLiteralExpression)initializer).getExpressions();
                if (expressions.length != 0) {
                    return false;
                }
            } else if (initializer instanceof JSNewExpression) {
                JSArrayLiteralExpression psi;
                ASTNode arrayLiteral;
                ASTNode node;
                JSExpression[] arguments;
                JSArgumentList argumentList = ((JSNewExpression)initializer).getArgumentList();
                if (argumentList != null && !JSGenericTypeImpl.isGenericActionScriptVectorType(this.myType) ? (arguments = argumentList.getArguments()).length != 0 : (node = initializer.getNode()) != null && (arrayLiteral = node.findChildByType(JSElementTypes.ARRAY_LITERAL_EXPRESSION)) != null && (psi = (JSArrayLiteralExpression)arrayLiteral.getPsi(JSArrayLiteralExpression.class)) != null && psi.getExpressions().length != 0) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private boolean checkVariable(JSVariable variable, JSElement context) {
            this.myType = variable.getType();
            if (this.myType == null || !JSTypeUtils.isIndexableType(this.myType)) {
                return false;
            }
            if (VariableAccessUtil.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtil.variableIsReturned(variable, context)) {
                return false;
            }
            if (VariableAccessUtil.variableIsPassedAsMethodArgument(variable, context)) {
                return false;
            }
            if (VariableAccessUtil.variableIsUsedAsObjectProperty(variable, context)) {
                return false;
            }
            return !VariableAccessUtil.variableIsUsedInArrayLiteral(variable, context);
        }

        private boolean collectionQueryCalled(JSVariable variable, JSElement context) {
            CollectionQueryCalledVisitor visitor = new CollectionQueryCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueryCalled();
        }

        private boolean collectionUpdateCalled(@NotNull JSVariable variable, @NotNull JSElement context) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "collectionUpdateCalled"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "collectionUpdateCalled"));
            }
            CollectionUpdateCalledVisitor visitor = new CollectionUpdateCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isUpdateCalled();
        }
    }

    private static abstract class Visitor
    extends JSRecursiveElementVisitor {
        protected final JSVariable myVariable;

        public Visitor(JSVariable variable) {
            this.myVariable = variable;
        }

        protected static boolean checkMethodName(JSReferenceExpression methodExpression, Collection<String> names) {
            if (!(methodExpression.getParent() instanceof JSCallExpression)) {
                return false;
            }
            String functionName = methodExpression.getReferencedName();
            if (functionName == null) {
                return false;
            }
            if (!names.contains(functionName)) {
                boolean found = false;
                for (String name : names) {
                    if (!functionName.startsWith(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            return true;
        }

        protected boolean checkReference(PsiElement element) {
            if (element instanceof JSReferenceExpression) {
                if (this.myVariable.equals(element = ((JSReferenceExpression)element).resolve())) {
                    return true;
                }
            } else if (element instanceof JSParenthesizedExpression) {
                return this.checkReference((PsiElement)((JSParenthesizedExpression)element).getInnerExpression());
            }
            return false;
        }
    }
}

