/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUndeclaredVariableInspection
extends JSInspection {
    public boolean myCheckGlobalDefinitions;
    @NonNls
    public static final String SHORT_NAME = "JSUndeclaredVariable";

    @Nullable
    private static JSVarStatement findPreviousVarStatement(PsiElement anchor) {
        PsiElement prevSibling = anchor;
        while (prevSibling != null && !(prevSibling instanceof PsiFile)) {
            if ((prevSibling = prevSibling.getPrevSibling()) instanceof JSVarStatement) {
                return (JSVarStatement)prevSibling;
            }
            if (prevSibling != null) continue;
            prevSibling = anchor = anchor.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.undeclared.variable.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSSourceElement element;
                PsiElement parentElement = node.getParent();
                if (!(parentElement instanceof JSCallExpression) && node.shouldCheckReferences() && node.getQualifier() == null && parentElement instanceof JSDefinitionExpression && ((element = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSWithStatement.class, JSFunction.class, JSLoopStatement.class})) != null || JSUndeclaredVariableInspection.this.myCheckGlobalDefinitions) && !(element instanceof JSWithStatement)) {
                    PsiElement nameIdentifier;
                    ResolveResult[] resolveResults;
                    boolean varReferenceWithoutVar = true;
                    for (ResolveResult r : resolveResults = node.multiResolve(false)) {
                        PsiElement resolveResult = r.getElement();
                        if (!(resolveResult instanceof JSVariable) && !(resolveResult instanceof JSFunction) && (!(resolveResult instanceof JSImplicitElement) || ((JSImplicitElement)resolveResult).getType() != JSImplicitElement.Type.Tag) && (!(resolveResult instanceof JSImplicitFunctionImpl) || !((JSImplicitFunctionImpl)resolveResult).isGetProperty() && !((JSImplicitFunctionImpl)resolveResult).isSetProperty())) continue;
                        varReferenceWithoutVar = false;
                        break;
                    }
                    if (varReferenceWithoutVar && resolveResults.length > 0 && (nameIdentifier = node.getReferenceNameElement()) != null) {
                        LinkedList<Object> fixes = new LinkedList<Object>();
                        if (JSUndeclaredVariableInspection.this.myOnTheFly) {
                            PsiFile file = node.getContainingFile();
                            fixes.add(new DeclareJSVariableIntentionAction(node.getReferencedName()));
                            PsiElement anchor = JSUtils.findStatementAnchor((PsiElement)node, file);
                            JSVarStatement varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor);
                            if (varStatement != null) {
                                fixes.add(new DeclareJSVariableInPreviousVarStatementQuickFix(node.getReferencedName()));
                            }
                        }
                        holder.registerProblem(nameIdentifier, JSBundle.message((String)"javascript.undeclared.variable.name.message", (Object[])new Object[]{node.getReferencedName()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, !fixes.isEmpty() ? fixes.toArray(new LocalQuickFix[fixes.size()]) : null);
                    }
                }
                super.visitJSReferenceExpression(node);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"javascript.check.global.definitions", (Object[])new Object[0]), (InspectionProfileEntry)this, "myCheckGlobalDefinitions");
    }

    private static boolean isImplicitlyDeclared(JSReferenceExpression node, PsiElement parentElement) {
        if (parentElement instanceof JSForInStatement) {
            JSExpression varExpression = ((JSForInStatement)parentElement).getVariableExpression();
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        if (parentElement instanceof JSForStatement) {
            JSExpression varExpression = ((JSForStatement)parentElement).getInitialization();
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        return false;
    }

    private static class DeclareJSVariableInPreviousVarStatementQuickFix
    implements LocalQuickFix {
        private final String myVarName;

        private DeclareJSVariableInPreviousVarStatementQuickFix(String varName) {
            this.myVarName = varName;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.declare.variable.in.previous.var.statement.intention.name", (Object[])new Object[]{this.myVarName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix", "applyFix"));
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)descriptor2.getPsiElement().getParent();
            PsiElement anchor = JSUtils.findStatementAnchor((PsiElement)referenceExpression, file = referenceExpression.getContainingFile());
            JSVarStatement varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor);
            if (varStatement == null) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return;
            }
            JSVariable[] variables = varStatement.getVariables();
            JSVariable lastVar = variables[variables.length - 1];
            int endOffset = lastVar.getTextRange().getEndOffset();
            StringBuilder declaration = new StringBuilder(", ").append(referenceExpression.getReferencedName());
            document.insertString(endOffset, (CharSequence)declaration);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformatText(file, varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getStartOffset() + declaration.length());
        }
    }

    private static class DeclareJSVariableIntentionAction
    implements LocalQuickFix {
        private final String myVarName;

        DeclareJSVariableIntentionAction(String varName) {
            this.myVarName = varName;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.declare.variable.intention.name", (Object[])new Object[]{this.myVarName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSExpression initialization;
            JSStatement statement;
            PsiFile file;
            PsiElement anchor;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction", "applyFix"));
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)descriptor2.getPsiElement().getParent();
            boolean implicitlyDeclared = JSUndeclaredVariableInspection.isImplicitlyDeclared(referenceExpression, anchor = JSUtils.findStatementAnchor((PsiElement)referenceExpression, file = referenceExpression.getContainingFile()));
            if (implicitlyDeclared && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)(anchor = referenceExpression), (Class[])new Class[]{JSForStatement.class, JSStatement.class})) instanceof JSForStatement && (initialization = ((JSForStatement)statement).getInitialization()) instanceof JSBinaryExpression && ((JSBinaryExpression)initialization).getOperationSign() == JSTokenTypes.COMMA) {
                anchor = ((JSAssignmentExpression)((JSBinaryExpression)initialization).getLOperand()).getLOperand();
            }
            if (anchor != null) {
                JSExpression expr;
                boolean anchorChanged = false;
                if (!implicitlyDeclared) {
                    PsiElement parent = anchor.getParent();
                    while (parent instanceof JSBlockStatement || parent instanceof JSIfStatement || parent instanceof JSLoopStatement) {
                        PsiElement newAnchor = parent.getParent();
                        if (newAnchor instanceof JSIfStatement || newAnchor instanceof JSWithStatement || newAnchor instanceof JSLoopStatement || newAnchor instanceof JSTryStatement || newAnchor instanceof JSSwitchStatement) {
                            anchor = newAnchor;
                            parent = anchor.getParent();
                            anchorChanged = true;
                            continue;
                        }
                        if (!(newAnchor instanceof JSFile)) break;
                        anchor = parent;
                        anchorChanged = true;
                        break;
                    }
                }
                TextRange textRange = anchor.getTextRange();
                int startOffset = textRange.getStartOffset();
                StringBuilder builder = new StringBuilder();
                builder.append(JSChangeUtil.getVariablePrefix((PsiElement)file));
                builder.append(" ");
                if (anchor instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)anchor).getExpression()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)expr).getOperationSign() != JSTokenTypes.EQ) {
                    anchorChanged = true;
                }
                if (!(!anchorChanged && anchor instanceof JSExpressionStatement || implicitlyDeclared)) {
                    builder.append(referenceExpression.getReferencedName()).append(";\n");
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                document.replaceString(startOffset, startOffset, (CharSequence)builder);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                try {
                    CodeStyleManager.getInstance((Project)project).reformatText(file, startOffset, textRange.getEndOffset() + builder.length());
                }
                catch (IncorrectOperationException e) {
                    e.printStackTrace();
                }
                file.navigate(true);
            }
        }
    }
}

