/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommentsMover {
    private final List<PsiElement> myBeforeComments;
    private final List<PsiElement> myAfterComments;

    public CommentsMover(@NotNull JSSourceElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/intentions/CommentsMover", "<init>"));
        }
        this.myBeforeComments = CommentsMover.collectBeforeComments(statement);
        this.myAfterComments = CommentsMover.collectAfterComments(statement);
    }

    public void move(@NotNull Set<PsiElement> created, @NotNull Collection<PsiElement> touched) {
        if (created == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "created", "com/intellij/lang/javascript/intentions/CommentsMover", "move"));
        }
        if (touched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touched", "com/intellij/lang/javascript/intentions/CommentsMover", "move"));
        }
        if (this.myBeforeComments.isEmpty() && this.myAfterComments.isEmpty()) {
            return;
        }
        PsiElement min = Collections.min(created, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        if (min == null) {
            return;
        }
        if (!(min instanceof JSSourceElement)) {
            JSSourceElement statement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)min, JSSourceElement.class);
            if (statement == null) {
                return;
            }
            min = statement;
        }
        if (!this.myBeforeComments.isEmpty() && this.myBeforeComments.get(0) instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc((PsiComment)this.myBeforeComments.get(0), min);
        } else {
            Collections.reverse(this.myBeforeComments);
            CommentsMover.moveCommentsList(min, this.myBeforeComments, touched);
        }
        if (!this.myAfterComments.isEmpty()) {
            CommentsMover.moveCommentsList(min.getNextSibling(), this.myAfterComments, touched);
        }
    }

    public boolean hasAfterComments() {
        return !this.myAfterComments.isEmpty();
    }

    @NotNull
    private static List<PsiElement> collectBeforeComments(JSSourceElement statement) {
        SmartList comments = new SmartList();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (!(comment instanceof JSDocComment)) {
            PsiElement current = statement.getPrevSibling();
            boolean commentsFound = false;
            while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
                comments.add(current);
                if (commentsFound && current instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)current.getText()) > 1) break;
                commentsFound |= current instanceof PsiComment;
                current = current.getPrevSibling();
            }
            if (!commentsFound) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectBeforeComments"));
                }
                return list;
            }
        } else {
            comments.add(comment);
        }
        SmartList smartList = comments;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectBeforeComments"));
        }
        return smartList;
    }

    public static PsiElement createNewLine(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/intentions/CommentsMover", "createNewLine"));
        }
        return CommentsMover.createWhiteSpace(context, "\n");
    }

    public static PsiElement createWhiteSpace(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/intentions/CommentsMover", "createWhiteSpace"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/CommentsMover", "createWhiteSpace"));
        }
        return JSChangeUtil.createJSFileFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context)).getFirstChild();
    }

    @NotNull
    private static List<PsiElement> collectAfterComments(JSSourceElement statement) {
        SmartList comments = new SmartList();
        boolean commentsFound = false;
        PsiElement current = statement.getNextSibling();
        while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
            comments.add(current);
            if (commentsFound && current instanceof PsiWhiteSpace) break;
            commentsFound |= current instanceof PsiComment;
            if (current.getText().contains("\n")) break;
            current = current.getNextSibling();
        }
        if (!commentsFound) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectAfterComments"));
            }
            return list;
        }
        SmartList smartList = comments;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CommentsMover", "collectAfterComments"));
        }
        return smartList;
    }

    private static void moveCommentsList(@NotNull PsiElement target, @NotNull List<PsiElement> comments, @NotNull Collection<PsiElement> touched) {
        int numNewlinesAfterMove;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/intentions/CommentsMover", "moveCommentsList"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/intentions/CommentsMover", "moveCommentsList"));
        }
        if (touched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touched", "com/intellij/lang/javascript/intentions/CommentsMover", "moveCommentsList"));
        }
        if (comments.isEmpty()) {
            return;
        }
        for (PsiElement element : comments) {
            if (!element.isValid()) {
                return;
            }
            if (!(element instanceof PsiComment) || !touched.contains(CommentsMover.findAssociatedElementForComment((PsiComment)element))) continue;
            return;
        }
        JSChangeUtil.addComments(comments, target);
        PsiElement before = comments.get(0).getPrevSibling();
        PsiElement lastComment = comments.get(comments.size() - 1);
        PsiElement after = lastComment.getNextSibling();
        for (PsiElement element : comments) {
            element.getParent().getNode().removeChild(element.getNode());
        }
        int lastSpaceNewLines = Math.max(1, CommentsMover.countNewLinesIfSpace(lastComment));
        if (before != null && after != null && (numNewlinesAfterMove = CommentsMover.countNewLinesIfSpace(before) + CommentsMover.countNewLinesIfSpace(after)) < lastSpaceNewLines) {
            String str = StringUtil.repeat((String)"\n", (int)(lastSpaceNewLines - numNewlinesAfterMove));
            JSChangeUtil.addWs(after.getParent().getNode(), after.getNode(), str);
        }
    }

    private static int countNewLinesIfSpace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/CommentsMover", "countNewLinesIfSpace"));
        }
        return element instanceof PsiWhiteSpace ? StringUtil.countNewLines((CharSequence)element.getText()) : 0;
    }

    static PsiElement findAssociatedSameLineElementForComment(PsiComment current) {
        Document document = PsiDocumentManager.getInstance((Project)current.getProject()).getDocument(current.getContainingFile());
        if (document == null) {
            return null;
        }
        int startLine = document.getLineNumber(current.getTextRange().getStartOffset());
        for (PsiElement currentOnLine = current.getPrevSibling(); currentOnLine != null && startLine == document.getLineNumber(currentOnLine.getTextRange().getStartOffset()); currentOnLine = currentOnLine.getPrevSibling()) {
            if (!(currentOnLine instanceof JSElement) || currentOnLine instanceof PsiComment) continue;
            return currentOnLine;
        }
        return null;
    }

    static PsiElement findAssociatedElementForComment(PsiComment current) {
        PsiElement sameLineElementForComment = CommentsMover.findAssociatedSameLineElementForComment(current);
        if (sameLineElementForComment != null) {
            return sameLineElementForComment;
        }
        return JSDocumentationUtils.findAttachedElementFromComment(current);
    }
}

