/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyingAnnotationHolder
extends AnnotationHolderImpl {
    private final ProblemsHolder myProblemsHolder;
    private final PsiFile myFile;
    @NotNull
    private final String myPrefix;

    public ProxyingAnnotationHolder(@NotNull AnnotationSession session, @NotNull ProblemsHolder holder, @Nullable String prefix) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "<init>"));
        }
        super(session);
        this.myProblemsHolder = holder;
        this.myFile = session.getFile();
        this.myPrefix = StringUtil.notNullize((String)prefix);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String tooltip) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "createAnnotation"));
        }
        Annotation annotation = super.createAnnotation(severity, range, message, tooltip);
        PsiElement element = ProxyingAnnotationHolder.findElementInRange(this.myFile, annotation);
        this.myProblemsHolder.registerProblem(element, this.myPrefix + annotation.getMessage(), ProxyingAnnotationHolder.convertFix(annotation.getQuickFixes()));
        return annotation;
    }

    private static PsiElement findElementInRange(@NotNull PsiFile file, Annotation next) {
        PsiElement current;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "findElementInRange"));
        }
        TextRange range = new TextRange(next.getStartOffset(), next.getEndOffset());
        for (current = file.findElementAt(next.getStartOffset()); current != null && current.getParent() != null; current = current.getParent()) {
            if (range.equals((Object)current.getParent().getTextRange())) {
                return current.getParent();
            }
            if (!current.getParent().getTextRange().contains(range)) continue;
            return current;
        }
        return current;
    }

    private static LocalQuickFix[] convertFix(@Nullable List<Annotation.QuickFixInfo> info) {
        if (info == null || info.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return info.stream().map(i -> (LocalQuickFix)i.quickFix).collect(Collectors.toList()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyingAnnotationHolder getOrCreate(@NotNull AnnotationSession session, @NotNull ProblemsHolder holder, @NotNull String prefix, @NotNull String name) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "getOrCreate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "getOrCreate"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "getOrCreate"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "getOrCreate"));
        }
        Key key = Key.create((String)("ProxyingAnnotationHolder." + name));
        AnnotationSession annotationSession = session;
        synchronized (annotationSession) {
            HashMap map = (HashMap)session.getUserData(key);
            if (map == null) {
                map = new HashMap();
                session.putUserDataIfAbsent(key, map);
            }
            return (ProxyingAnnotationHolder)((Object)ContainerUtil.getOrCreate(map, (Object)holder, () -> {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "lambda$getOrCreate$1"));
                }
                if (holder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "lambda$getOrCreate$1"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/json/ProxyingAnnotationHolder", "lambda$getOrCreate$1"));
                }
                return new ProxyingAnnotationHolder(session, holder, prefix);
            }));
        }
    }
}

