/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;

public class JSLinterUtil {
    public static final Language VUE = Language.findLanguageByID((String)"Vue");
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Linter Language Service", NotificationDisplayType.BALLOON, true);

    private JSLinterUtil() {
    }

    @NotNull
    public static NativeObject convertPredefToRhinoMap(@NotNull Object predef) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefToRhinoMap"));
        }
        HashMap map = new HashMap();
        if (predef instanceof String) {
            Map<String, Boolean> boolMap = JSLinterUtil.convertPredefStrToMap((String)predef);
            map.putAll(boolMap);
        } else if (predef instanceof List) {
            for (Object o : (List)predef) {
                if (!(o instanceof String)) continue;
                map.put((String)o, false);
            }
        } else if (predef instanceof Map) {
            for (Map.Entry entry : ((Map)predef).entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        NativeObject nativeObject = RhinoUtil.toRhinoMap(map);
        if (nativeObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefToRhinoMap"));
        }
        return nativeObject;
    }

    @NotNull
    public static NativeArray convertPredefStrToNativeArray(@NotNull String predef, @NotNull Scriptable scope) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        Map<String, Boolean> structure = JSLinterUtil.convertPredefStrToMap(predef);
        NativeArray array = RhinoUtil.toRhinoArray(ContainerUtil.newArrayList(structure.keySet()));
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        NativeArray nativeArray = array;
        if (nativeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToNativeArray"));
        }
        return nativeArray;
    }

    @NotNull
    private static Map<String, Boolean> convertPredefStrToMap(@NotNull String predef) {
        if (predef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predef", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToMap"));
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        StringTokenizer st = new StringTokenizer(predef, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int ind = token.indexOf(58);
            String name = token;
            boolean readonly = false;
            if (ind >= 0) {
                String value = token.substring(ind + 1).trim();
                if (Boolean.toString(true).equals(value) || Boolean.toString(false).equals(value)) {
                    name = token.substring(0, ind).trim();
                    readonly = Boolean.parseBoolean(value);
                }
            }
            map.put(name, readonly);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertPredefStrToMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        if (forcedTextAttributes != null) {
            Annotation annotation = holder.createAnnotation(severity, range, message);
            annotation.setEnforcedTextAttributes(forcedTextAttributes);
            annotation.setNeedsUpdateOnTyping(false);
            Annotation annotation2 = annotation;
            if (annotation2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
            }
            return annotation2;
        }
        Annotation annotation = severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(range, message) : holder.createWarningAnnotation(range, message);
        annotation.setNeedsUpdateOnTyping(false);
        JSLinterUtil.setTooltipToAnnotation(annotation);
        Annotation annotation3 = annotation;
        if (annotation3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createAnnotation"));
        }
        return annotation3;
    }

    private static void setTooltipToAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/lang/javascript/linter/JSLinterUtil", "setTooltipToAnnotation"));
        }
        String message = annotation.getMessage();
        String escaped = XmlStringUtil.escapeString((String)message);
        escaped = StringUtil.convertLineSeparators((String)escaped, (String)"\n").replace("\n", "<br/>");
        String tooltip = message == null ? null : XmlStringUtil.wrapInHtml((CharSequence)escaped);
        annotation.setTooltip(tooltip);
    }

    @NotNull
    public static HighlightSeverity getSeverity(@NotNull InspectionProjectProfileManager inspectionProjectProfileManager, @NotNull HighlightDisplayKey inspectionKey, @NotNull PsiFile file) {
        if (inspectionProjectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProjectProfileManager", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        InspectionProfileImpl inspectionProfile = inspectionProjectProfileManager.getCurrentProfile();
        HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(inspectionKey, (PsiElement)file);
        if (errorLevel == null) {
            errorLevel = HighlightDisplayLevel.WARNING;
        }
        HighlightSeverity highlightSeverity = errorLevel.getSeverity();
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getSeverity"));
        }
        return highlightSeverity;
    }

    @NotNull
    public static TextAttributes getTextAttributes(@Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightSeverity severity) {
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        TextAttributes textAttributes = severityRegistrar.getTextAttributesBySeverity(severity);
        if (textAttributes != null) {
            TextAttributes textAttributes2 = textAttributes;
            if (textAttributes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
            }
            return textAttributes2;
        }
        EditorColorsScheme colorsScheme = JSLinterUtil.getColorsScheme(editorColorsScheme);
        HighlightInfoType.HighlightInfoTypeImpl infoType = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
        TextAttributesKey key = infoType.getAttributesKey();
        TextAttributes textAttributes3 = colorsScheme.getAttributes(key);
        if (textAttributes3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getTextAttributes"));
        }
        return textAttributes3;
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getColorsScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public static List<JSLinterError> limitErrorsAtTheSamePosition(@NotNull List<JSLinterError> errors, int limit) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterUtil", "limitErrorsAtTheSamePosition"));
        }
        Collections.sort(errors, (o1, o2) -> o1.compareFully((JSLinterError)o2));
        JSLinterError prev = null;
        ArrayList limited = ContainerUtil.newArrayList();
        int count = 0;
        for (JSLinterError error : errors) {
            if (prev != null && prev.compareLogicalPositionTo(error) == 0) {
                if (prev.getDescription().equals(error.getDescription())) continue;
                ++count;
            } else {
                count = 1;
            }
            if (count <= limit) {
                limited.add(error);
            }
            prev = error;
        }
        ArrayList arrayList = limited;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "limitErrorsAtTheSamePosition"));
        }
        return arrayList;
    }

    @NotNull
    public static TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull Project project, @NotNull String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        JTextField textField = (JTextField)textFieldWithBrowseButton.getChildComponent();
        textField.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
        textFieldWithBrowseButton.addBrowseFolderListener(description, null, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, (Disposable)project);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createTextFieldWithBrowseButton"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public static JEditorPane createDefaultContent(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDefaultContent"));
        }
        JEditorPane jEditorPane = JSLinterUtil.createHtmlViewer(message, null);
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDefaultContent"));
        }
        return jEditorPane;
    }

    @NotNull
    public static JEditorPane createHtmlViewer(@NotNull String innerBodyHtml, @Nullable Font font) {
        if (innerBodyHtml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerBodyHtml", "com/intellij/lang/javascript/linter/JSLinterUtil", "createHtmlViewer"));
        }
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        JEditorPane pane = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null), innerBodyHtml);
        pane.setText(html);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "createHtmlViewer"));
        }
        return jEditorPane;
    }

    public static int getRadioIconWidth() {
        Icon icon = UIManager.getIcon("RadioButton.icon");
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 12;
    }

    public static boolean isVueFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "isVueFile"));
        }
        return VUE != null && VUE.equals(file.getLanguage());
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "isPureHtmlFile"));
        }
        if (file.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        VirtualFile root = project.getBaseDir();
        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getAbsoluteOrRelativePathToProjectRoot"));
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getAbsoluteOrRelativePathToProjectRoot"));
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        return string;
    }

    @Nullable
    public static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @Nullable GeneralCommandLine commandLine, @NotNull ProcessOutput output, @Nullable Icon icon) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDetailsAction"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDetailsAction"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/JSLinterUtil", "createDetailsAction"));
        }
        if (!StringUtil.containsLineBreak((CharSequence)output.getStderr())) {
            return null;
        }
        String presentableFilePath = (String)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "lambda$createDetailsAction$1"));
            }
            if (fileToLint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/JSLinterUtil", "lambda$createDetailsAction$1"));
            }
            return project.isDisposed() ? fileToLint.getPresentableUrl() : JSLinterUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint);
        });
        return new JsqtViewProcessOutputAction("Failed to lint " + presentableFilePath, icon, commandLine, null, output);
    }

    @NotNull
    public static ResultWithError<VirtualFile> checkPath(@NotNull String path, boolean isDir, @NotNull String fieldName) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/JSLinterUtil", "checkPath"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/lang/javascript/linter/JSLinterUtil", "checkPath"));
        }
        VirtualFile virtualFile = JSLinterConfigFileUtil.findLocalFileByPath(path);
        if (virtualFile == null || !virtualFile.isValid() || isDir != virtualFile.isDirectory()) {
            ResultWithError<VirtualFile> resultWithError = ResultWithError.error("Please specify correct path to " + fieldName);
            if (resultWithError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "checkPath"));
            }
            return resultWithError;
        }
        ResultWithError<VirtualFile> resultWithError = ResultWithError.result(virtualFile);
        if (resultWithError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "checkPath"));
        }
        return resultWithError;
    }

    @Nullable
    public static JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @NotNull String packageName, @NotNull JSNpmLinterState<?> linterState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "validateInterpreterAndPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/linter/JSLinterUtil", "validateInterpreterAndPackage"));
        }
        if (linterState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterState", "com/intellij/lang/javascript/linter/JSLinterUtil", "validateInterpreterAndPackage"));
        }
        try {
            NodeJsInterpreter interpreter = linterState.getInterpreterRef().resolve(project);
            NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException e) {
            return new JSLinterFileLevelAnnotation(StringUtil.decapitalize((String)e.getMessage()));
        }
        String packagePath = StringUtil.notNullize((String)linterState.getLinterPackagePath());
        ResultWithError<VirtualFile> packageValidation = JSLinterUtil.checkPath(packagePath, true, packageName);
        return packageValidation.getError() == null ? null : JSLinterUtil.createLinterPackageError(project, packagePath, packageName);
    }

    public static JSLinterFileLevelAnnotation createLinterPackageError(@NotNull Project project, @NotNull String packagePath, @NonNls @NotNull String packageName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "createLinterPackageError"));
        }
        if (packagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePath", "com/intellij/lang/javascript/linter/JSLinterUtil", "createLinterPackageError"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/linter/JSLinterUtil", "createLinterPackageError"));
        }
        if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
            return new JSLinterFileLevelAnnotation(String.format("Please specify path to '%s' package", packageName));
        }
        File path = new File(packagePath);
        if (path.getParentFile() != null && "node_modules".equals(path.getParentFile().getName()) && Objects.equals(path.getParentFile().getParentFile(), new File(project.getBasePath()))) {
            String message = String.format("Please install '%s' package", packageName);
            JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(null, message, HighlightSeverity.ERROR, new JSLinterStandardFixes());
            VirtualFile packageJson = project.getBaseDir().findChild("package.json");
            if (packageJson != null) {
                annotation.getFixes().setOtherFixes(Collections.singletonList(new MyInstallNpmIntention()));
            }
            return annotation;
        }
        return new JSLinterFileLevelAnnotation(String.format("Please specify path to '%s' package correctly", packageName));
    }

    @Nullable
    public static Document getDocumentForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSLinterUtil", "getDocumentForElement"));
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile.getOriginalFile());
            return PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        }
        return null;
    }

    @NotNull
    public static String convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull String fileContent, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertLineSeparatorsToFileOriginal"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertLineSeparatorsToFileOriginal"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertLineSeparatorsToFileOriginal"));
        }
        String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project);
        if (lineSeparator.equals("\n")) {
            String string = fileContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertLineSeparatorsToFileOriginal"));
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)fileContent, (String)lineSeparator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil", "convertLineSeparatorsToFileOriginal"));
        }
        return string;
    }

    public static void reportCodeStyleSettingsImported(final @NotNull Project project, @NotNull String linterName, final @NotNull VirtualFile file, @NotNull Collection<String> importedRuleNames) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil", "reportCodeStyleSettingsImported"));
        }
        if (linterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterName", "com/intellij/lang/javascript/linter/JSLinterUtil", "reportCodeStyleSettingsImported"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterUtil", "reportCodeStyleSettingsImported"));
        }
        if (importedRuleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedRuleNames", "com/intellij/lang/javascript/linter/JSLinterUtil", "reportCodeStyleSettingsImported"));
        }
        String rulesText = importedRuleNames.stream().sorted().collect(Collectors.joining(", "));
        JSLinterGuesser.NOTIFICATION_GROUP.createNotification(JSBundle.message((String)"javascript.linter.import.notification", (Object[])new Object[]{linterName, file.getName(), rulesText, importedRuleNames.size()}), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(String.format("Edit '%s'", file.getName())){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/JSLinterUtil$1", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/linter/JSLinterUtil$1", "actionPerformed"));
                }
                new OpenFileDescriptor(project, file, 0).navigate(true);
            }
        }).notify(project);
    }

    public static String addHtmlURLMarkupIfNeeded(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterUtil", "addHtmlURLMarkupIfNeeded"));
        }
        if (!URLUtil.canContainUrl((String)message)) {
            return message;
        }
        StringBuilder sb = new StringBuilder("<html>");
        Matcher matcher = URLUtil.URL_PATTERN.matcher(message);
        int prev = 0;
        while (matcher.find()) {
            String url = MessageFormat.format("<a href=\"{0}\">{0}</a>", matcher.group());
            sb.append(message.substring(prev, matcher.start())).append(url);
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message.substring(prev, message.length()));
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static class MyInstallNpmIntention
    implements IntentionAction {
        private MyInstallNpmIntention() {
        }

        @Nls
        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"node.js.quickfix.run.npm.update.text", (Object[])new Object[]{"install"});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.update.modules.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterUtil$MyInstallNpmIntention", "invoke"));
            }
            VirtualFile packageJson = project.getBaseDir().findChild("package.json");
            if (packageJson != null) {
                InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

