/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinterCodeStyleImportSourceTracker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDismissKey;
    @NotNull
    private final Processor<VirtualFile> myFileSelector;
    @NotNull
    private final Runnable myDismissAction;

    public LinterCodeStyleImportSourceTracker(final @NotNull Project project, @NotNull String keyPrefix, @NotNull Processor<VirtualFile> fileSelector) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker", "<init>"));
        }
        if (keyPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyPrefix", "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker", "<init>"));
        }
        if (fileSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSelector", "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker", "<init>"));
        }
        this.myProject = project;
        this.myDismissKey = keyPrefix + ".code.style.apply.dismiss";
        this.myFileSelector = fileSelector;
        this.myDismissAction = () -> {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myDismissKey, true);
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        };
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file) {
                if (file == null) {
                    return;
                }
                VirtualFile vFile = file.getViewProvider().getVirtualFile();
                if (!LinterCodeStyleImportSourceTracker.this.shouldDismiss(vFile)) {
                    EditorNotifications.getInstance((Project)project).updateNotifications(vFile);
                }
            }
        }, (Disposable)project);
    }

    public boolean shouldDismiss(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker", "shouldDismiss"));
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.myDismissKey) || !this.myFileSelector.process((Object)file);
    }

    @NotNull
    public Runnable getDismissAction() {
        Runnable runnable = this.myDismissAction;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker", "getDismissAction"));
        }
        return runnable;
    }
}

