/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private boolean myIsFix;
    private final EslintLanguageServiceClient myLanguageService;

    public EsLintExternalRunner(boolean isOnTheFly, boolean isFix, EslintLanguageServiceClient service) {
        this.myIsOnTheFly = isOnTheFly;
        this.myIsFix = isFix;
        this.myLanguageService = service;
    }

    @Nullable
    private static EslintSessionData createSessionData(@NotNull Project project, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileContentToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContentToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        VirtualFile workingDir = EsLintExternalRunner.guessWorkingDirectory(project, fileToLint);
        if (workingDir == null) {
            LOG.debug("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.debug(String.format("No parent directory for file %s", fileToLint.getPath()));
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        VirtualFile eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileToLint, ".eslintignore");
        VirtualFile eslintIgnoreFileDir = eslintIgnoreFile != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private JSLinterAnnotationResult<EslintState> eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> possibleConfigs) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        if (possibleConfigs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleConfigs", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        long startNanoTime = System.nanoTime();
        if (!EslintUtil.lintThisFileType(input.getProject(), input.getPsiFile(), possibleConfigs, input.getState())) {
            return null;
        }
        JSLinterAnnotationResult<EslintState> result = this.runProcess(input, sessionData, possibleConfigs);
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNanoTime);
        String report = "found " + result.getErrors().size() + " problems";
        LOG.debug(String.format("Done in %d ms, %s", durationMillis, report));
        return result;
    }

    @NotNull
    private JSLinterAnnotationResult<EslintState> runProcess(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> possibleConfigs) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        if (possibleConfigs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleConfigs", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        VirtualFile config2 = sessionData.getSpecifiedConfigFile();
        VirtualFile bestGuessConfig = config2 != null ? config2 : (VirtualFile)ContainerUtil.getFirstItem(possibleConfigs);
        Future<Pair<String, List<JSLinterError>>> future = this.myIsFix ? this.myLanguageService.highlightAndFix(sessionData.getFileToLint(), config2, input.getState().getExtraOptions()) : this.myLanguageService.highlight(sessionData.getFileToLint(), config2, sessionData.getFileToLintContent(), input.getState().getExtraOptions());
        ResultWithError<Pair<String, List<JSLinterError>>> result = JSLanguageServiceUtil.awaitLanguageService(future, this.myLanguageService);
        String error = result.getError() != null ? result.getError() : (result.getResult() == null ? "Can not get result from language service" : (String)result.getResult().getFirst());
        Pair<String, List<JSLinterError>> pair = result.getResult();
        if (error != null) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(error);
            IntentionAction detailsAction = pair == null ? null : JSLinterUtil.createDetailsAction(input.getProject(), sessionData.getFileToLint(), null, output, JavaScriptLanguageIcons.FileTypes.Eslint);
            JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, EsLintExternalRunner.createFileLevelAnnotation(error, detailsAction), bestGuessConfig);
            if (jSLinterAnnotationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
            }
            return jSLinterAnnotationResult;
        }
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(input, pair != null ? (List)pair.getSecond() : Collections.emptyList(), bestGuessConfig);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        return jSLinterAnnotationResult;
    }

    public static JSLinterFileLevelAnnotation createFileLevelAnnotation(String error, @Nullable IntentionAction detailsAction) {
        String[] strings;
        JSLinterFileLevelAnnotation annotation = detailsAction == null ? new JSLinterFileLevelAnnotation(error) : new JSLinterFileLevelAnnotation(error, detailsAction);
        for (String string : strings = StringUtil.filterEmptyStrings((String[])StringUtil.splitByLines((String)error))) {
            if (FileUtil.isAbsolute((String)(string = string.trim())) || string.endsWith(":") && FileUtil.isAbsolute((String)string.substring(0, string.length() - 1)) || string.startsWith("Oops! Something went wrong! :(")) continue;
            annotation.setShortMessage(string);
            break;
        }
        return annotation.withIcon(JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    public JSLinterAnnotationResult<EslintState> execute(@NotNull JSLinterInput<EslintState> input) {
        VirtualFile specifiedConfigFile;
        String additionalRulesError;
        EslintState state;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "execute"));
        }
        VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid() || fileToLint.getParent() == null) {
            return null;
        }
        Project project = input.getProject();
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(project, "eslint", state = input.getState());
        if (error != null) {
            return JSLinterAnnotationResult.create(input, error, null);
        }
        if (!StringUtil.isEmptyOrSpaces((String)state.getAdditionalRulesDirPath()) && (additionalRulesError = JSLinterUtil.checkPath(state.getAdditionalRulesDirPath(), true, "Additional rules directory").getError()) != null) {
            return EsLintExternalRunner.errorForText(input, additionalRulesError);
        }
        if (state.isCustomConfigFileUsed()) {
            ResultWithError<VirtualFile> result = JSLinterUtil.checkPath(state.getCustomConfigFilePath(), false, "ESLint configuration file");
            if (result.getError() != null) {
                return EsLintExternalRunner.errorForText(input, result.getError());
            }
            specifiedConfigFile = result.getResult();
        } else {
            specifiedConfigFile = null;
        }
        EslintSessionData sessionData = (EslintSessionData)ReadAction.compute(() -> {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "lambda$execute$0"));
            }
            if (project.isDisposed()) {
                return null;
            }
            if (this.myIsOnTheFly) {
                EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
            }
            return EsLintExternalRunner.createSessionData(project, fileToLint, input.getFileContent(), specifiedConfigFile);
        });
        if (sessionData == null) {
            return null;
        }
        SmartList possibleConfigs = new SmartList();
        boolean runGranted = (Boolean)ReadAction.compute(() -> this.lambda$execute$1(project, (List)possibleConfigs, sessionData));
        if (runGranted) {
            return this.eslint(input, sessionData, (List<VirtualFile>)possibleConfigs);
        }
        LOG.debug("ESLint postponed because of unsaved configs");
        return null;
    }

    @NotNull
    private static JSLinterAnnotationResult<EslintState> errorForText(@NotNull JSLinterInput<EslintState> input, @NotNull String text) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "errorForText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "errorForText"));
        }
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(text), null);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "errorForText"));
        }
        return jSLinterAnnotationResult;
    }

    private /* synthetic */ Boolean lambda$execute$1(Project project, List possibleConfigs, EslintSessionData sessionData) throws RuntimeException {
        if (project.isDisposed()) {
            return false;
        }
        possibleConfigs.addAll(sessionData.findConfigs());
        return !this.myIsOnTheFly || EslintUnsavedConfigManager.getInstance(project).requestSaveIfNeeded(possibleConfigs);
    }
}

