/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintSessionData {
    private final VirtualFile myWorkingDir;
    private final VirtualFile myFileToLint;
    private final String myFileToLintContent;
    private final VirtualFile mySpecifiedConfigFile;

    public EslintSessionData(@NotNull VirtualFile workingDir, @NotNull VirtualFile fileToLint, @NotNull String fileToLintContent, @Nullable VirtualFile specifiedConfigurationFile) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (fileToLintContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLintContent", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        this.myWorkingDir = workingDir;
        this.myFileToLint = fileToLint;
        this.myFileToLintContent = fileToLintContent;
        this.mySpecifiedConfigFile = specifiedConfigurationFile;
    }

    @NotNull
    public VirtualFile getFileToLint() {
        VirtualFile virtualFile = this.myFileToLint;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLint"));
        }
        return virtualFile;
    }

    @NotNull
    public String getFileToLintContent() {
        String string = this.myFileToLintContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLintContent"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getSpecifiedConfigFile() {
        return this.mySpecifiedConfigFile;
    }

    @NotNull
    public List<VirtualFile> findConfigs() {
        ArrayList configs = ContainerUtil.newArrayList();
        VirtualFile ignoreFile = this.myWorkingDir.findChild(".eslintignore");
        if (ignoreFile != null && ignoreFile.isValid() && !ignoreFile.isDirectory()) {
            configs.add(ignoreFile);
        }
        if (this.mySpecifiedConfigFile != null) {
            configs.add(this.mySpecifiedConfigFile);
        } else {
            configs.addAll(EslintUtil.findAllConfigsWithPackageJsonUpFileSystem(this.myFileToLint));
        }
        ArrayList arrayList = configs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "findConfigs"));
        }
        return arrayList;
    }
}

