/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.ActionScriptCodeContextType;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMacroUtil {
    public static JSNamedElement[] getNamedElementsVisibleAt(ExpressionContext context) {
        return JSMacroUtil.getNamedElementsVisibleAt(context, true);
    }

    public static JSNamedElement[] getNamedElementsVisibleAt(final ExpressionContext context, final boolean skipElementsInsideTemplate) {
        PsiElement elementFromContext = JSMacroUtil.getElementFromContext(context);
        HashSet vars = new HashSet();
        if (elementFromContext != null) {
            int elementFromContextOffset = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(elementFromContext, elementFromContext.getTextOffset());
            ResolveProcessor processor = new ResolveProcessor(null, (Set)vars, elementFromContextOffset, elementFromContext){
                final /* synthetic */ Set val$vars;
                final /* synthetic */ int val$elementFromContextOffset;
                final /* synthetic */ PsiElement val$elementFromContext;
                {
                    this.val$vars = set;
                    this.val$elementFromContextOffset = n;
                    this.val$elementFromContext = psiElement;
                    super(arg0);
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/macro/JSMacroUtil$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/macro/JSMacroUtil$1", "execute"));
                    }
                    if (element instanceof JSNamedElement) {
                        int varOffset = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(element, element.getTextOffset());
                        if (skipElementsInsideTemplate) {
                            if (varOffset < context.getTemplateStartOffset() || varOffset > context.getTemplateEndOffset()) {
                                this.val$vars.add((JSNamedElement)element);
                            }
                        } else if (varOffset < this.val$elementFromContextOffset || varOffset > this.val$elementFromContextOffset + this.val$elementFromContext.getTextLength()) {
                            this.val$vars.add((JSNamedElement)element);
                        }
                    }
                    return true;
                }
            };
            processor.setLocalResolve(true);
            JSResolveUtil.treeWalkUp(processor, elementFromContext, elementFromContext.getParent(), elementFromContext);
        }
        return vars.toArray(new JSNamedElement[vars.size()]);
    }

    @Nullable
    public static PsiElement getElementFromContext(ExpressionContext context) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int offset = context.getStartOffset();
        int delta = offset - editor.getCaretModel().getOffset();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = psiDocumentManager.getPsiFile(editor.getDocument());
        if (file instanceof XmlFile) {
            PsiFile injFile;
            Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file, (int)offset);
            if (injEditor instanceof EditorWindow && (injFile = ((EditorWindow)injEditor).getInjectedFile()) != null) {
                int injOffset = injEditor.getCaretModel().getOffset();
                return injFile.findElementAt(injOffset + delta);
            }
            return null;
        }
        return file == null ? null : file.findElementAt(offset);
    }

    public static boolean isJSLikeContext(TemplateContextType type) {
        return type instanceof JavaScriptCodeContextType || type instanceof ActionScriptCodeContextType || type != null && JSMacroUtil.isJSLikeContext(type.getBaseContextType());
    }
}

