/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportPlaceInfo {
    @NotNull
    private final PsiElement place;
    @Nullable
    private final PsiElement parent;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final PsiElement container;
    private final boolean isStrictContext;

    public JSImportPlaceInfo(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/modules/JSImportPlaceInfo", "<init>"));
        }
        this.place = place;
        this.parent = place.getParent();
        this.file = place.getContainingFile().getOriginalFile().getVirtualFile();
        this.container = ES6PsiUtil.getExportScope(place);
        this.isStrictContext = place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place);
    }

    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.place;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSImportPlaceInfo", "getPlace"));
        }
        return psiElement;
    }

    public boolean isStrictTypeContext() {
        return this.isStrictContext;
    }

    @Nullable
    public PsiElement getParentElement() {
        return this.parent;
    }

    @Nullable
    public PsiElement getContainer() {
        return this.container;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSImportPlaceInfo", "getFile"));
        }
        return virtualFile;
    }
}

