/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleFixCreator {
    @NotNull
    private final List<FixDescriptor> myFixDescriptors;
    private final Set<VirtualFile> myPredefinedFiles;
    private final ModuleReferenceInfo myModuleReferenceInfo;
    private boolean myNoFixesShouldBeSuggested;

    public ModuleFixCreator(Set<VirtualFile> predefinedFiles, ModuleReferenceInfo moduleReferenceInfo) {
        this.myPredefinedFiles = predefinedFiles;
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myFixDescriptors = new ArrayList<FixDescriptor>();
    }

    public void addFix(@NotNull FixDescriptor fixDescriptor) {
        if (fixDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixDescriptor", "com/intellij/lang/javascript/modules/ModuleFixCreator", "addFix"));
        }
        if (this.myNoFixesShouldBeSuggested) {
            return;
        }
        if (this.myPredefinedFiles.contains(fixDescriptor.getFromFile())) {
            this.myNoFixesShouldBeSuggested = true;
            this.myFixDescriptors.clear();
            return;
        }
        if (this.myFixDescriptors.contains(fixDescriptor)) {
            return;
        }
        this.myFixDescriptors.add(fixDescriptor);
    }

    public void checkResolve(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/ModuleFixCreator", "checkResolve"));
        }
        if (element.getContainingFile().isValid() && this.myPredefinedFiles.contains(element.getContainingFile().getVirtualFile()) && element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getNamespace() == null) {
            this.myNoFixesShouldBeSuggested = true;
            this.myFixDescriptors.clear();
        }
    }

    public boolean isNoFixesShouldBeSuggested() {
        return this.myNoFixesShouldBeSuggested;
    }

    public void addShortModules() {
        HashSet<String> set = new HashSet<String>();
        ArrayList<FixDescriptor> descriptors = new ArrayList<FixDescriptor>(this.myFixDescriptors);
        ContainerUtil.iterate(descriptors, descriptor2 -> {
            set.add(descriptor2.getFromPath());
            return true;
        });
        for (FixDescriptor descriptor3 : descriptors) {
            FixDescriptor newDescriptor;
            Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> moduleInPackage;
            VirtualFile file;
            VirtualFile libModuleRoot;
            int idx;
            String key;
            String path;
            if (descriptor3.getModuleType().equals((Object)ModuleType.amd) || (path = descriptor3.getFromPath()).startsWith(".") || path.startsWith("/") || FileUtil.isAbsolute((String)path) || set.contains(key = (idx = path.indexOf(47)) > 0 ? path.substring(0, idx) : path) || key.isEmpty() || "react".equalsIgnoreCase(key) || (libModuleRoot = JSLibraryUtil.getLibraryFolder(file = descriptor3.getFromFile(), "node_modules")) == null || (moduleInPackage = NodeModuleSearchUtil.findMainModuleInPackage(libModuleRoot)).getSecond() == null) continue;
            NodeModuleSearchUtil.ModuleMainFiles mainFiles = (NodeModuleSearchUtil.ModuleMainFiles)moduleInPackage.getSecond();
            VirtualFile selectedMainFile = mainFiles.getMain();
            if (!file.equals(selectedMainFile) && mainFiles.getJsNextMain() != null) {
                selectedMainFile = mainFiles.getJsNextMain();
            }
            if (selectedMainFile == null) continue;
            set.add(key);
            if (this.myModuleReferenceInfo.getParentName() == null) {
                String target = descriptor3.getFirstWordInExportsName();
                if (target == null) {
                    String string = target = descriptor3.getTail() != null && descriptor3.getTail().length > 0 ? descriptor3.getTail()[0] : null;
                }
                if (target == null) {
                    target = descriptor3.getFirstWordInFile();
                }
                newDescriptor = new FixDescriptor(descriptor3.getModuleType(), key, selectedMainFile, descriptor3.getFirstWordInFile(), target);
            } else {
                newDescriptor = new FixDescriptor(descriptor3.getModuleType(), key, selectedMainFile, descriptor3.getFirstWordInFile(), null);
            }
            this.myFixDescriptors.add(newDescriptor);
        }
    }

    @NotNull
    public List<FixDescriptor> getFixDescriptors() {
        List<FixDescriptor> list = this.myFixDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator", "getFixDescriptors"));
        }
        return list;
    }

    public boolean isEmpty() {
        return this.myFixDescriptors.isEmpty();
    }

    public static enum ModuleType {
        nodejs,
        es6,
        amd;

    }

    public static class FixDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @NotNull
        private final String myFromPath;
        @NotNull
        private final VirtualFile myFromFile;
        @NotNull
        private final String myFirstWordInFile;
        @Nullable
        private final String myFirstWordInExportsName;
        @Nullable
        private SmartPsiElementPointer<PsiElement> myTailToReplaceReference;
        @Nullable
        private String[] myTail;
        private boolean myModuleElementIsMissing;
        private ES6ImportPsiUtil.ImportExportType myImportType;
        private boolean myIsFlowType;

        public FixDescriptor(@NotNull ModuleType moduleType, @NotNull String fromPath, @NotNull VirtualFile file, @NotNull String firstWordInFile, @Nullable String firstWordInExportsName) {
            if (moduleType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (fromPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPath", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (firstWordInFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstWordInFile", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            this.myImportType = null;
            this.myModuleType = moduleType;
            this.myFromPath = fromPath;
            this.myFromFile = file;
            this.myFirstWordInFile = firstWordInFile;
            this.myFirstWordInExportsName = firstWordInExportsName;
        }

        public FixDescriptor(@NotNull FixDescriptor descriptor2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            this.myImportType = null;
            this.myModuleType = descriptor2.myModuleType;
            this.myFromPath = descriptor2.myFromPath;
            this.myFromFile = descriptor2.myFromFile;
            this.myFirstWordInFile = descriptor2.myFirstWordInFile;
            this.myFirstWordInExportsName = descriptor2.myFirstWordInExportsName;
        }

        public FixDescriptor moduleElementIsMissing() {
            this.myModuleElementIsMissing = true;
            return this;
        }

        public FixDescriptor withTail(@NotNull SmartPsiElementPointer<PsiElement> tailToReplaceReference, @NotNull String[] tail) {
            if (tailToReplaceReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailToReplaceReference", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "withTail"));
            }
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "withTail"));
            }
            this.myTailToReplaceReference = tailToReplaceReference;
            this.myTail = tail;
            return this;
        }

        public ES6ImportPsiUtil.ImportExportType getImportType() {
            return this.myImportType;
        }

        public void setImportType(@NotNull ES6ImportPsiUtil.ImportExportType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "setImportType"));
            }
            this.myImportType = type;
        }

        public void setDefaultExport(boolean defaultExport) {
            this.myImportType = defaultExport ? ES6ImportPsiUtil.ImportExportType.DEFAULT : null;
        }

        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.myModuleType;
            if (moduleType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getModuleType"));
            }
            return moduleType;
        }

        @NotNull
        public String getFromPath() {
            String string = this.myFromPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFromPath"));
            }
            return string;
        }

        @NotNull
        public VirtualFile getFromFile() {
            VirtualFile virtualFile = this.myFromFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFromFile"));
            }
            return virtualFile;
        }

        @NotNull
        public String getFirstWordInFile() {
            String string = this.myFirstWordInFile;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFirstWordInFile"));
            }
            return string;
        }

        @Nullable
        public String getFirstWordInExportsName() {
            return this.myFirstWordInExportsName;
        }

        @Nullable
        public PsiElement getTailToReplaceReference() {
            return this.myTailToReplaceReference == null ? null : this.myTailToReplaceReference.getElement();
        }

        @Nullable
        public String[] getTail() {
            return this.myTail;
        }

        public boolean isModuleElementIsMissing() {
            return this.myModuleElementIsMissing;
        }

        public void setIsFlowType(boolean flowType) {
            this.myIsFlowType = flowType;
        }

        public boolean isFlowType() {
            return this.myIsFlowType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixDescriptor that = (FixDescriptor)o;
            if (this.myModuleElementIsMissing != that.myModuleElementIsMissing) {
                return false;
            }
            if (this.myModuleType != that.myModuleType) {
                return false;
            }
            if (!this.myFromPath.equals(that.myFromPath)) {
                return false;
            }
            if (!this.myFromFile.equals(that.myFromFile)) {
                return false;
            }
            if (!this.myFirstWordInFile.equals(that.myFirstWordInFile)) {
                return false;
            }
            if (this.myFirstWordInExportsName != null ? !this.myFirstWordInExportsName.equals(that.myFirstWordInExportsName) : that.myFirstWordInExportsName != null) {
                return false;
            }
            if (this.myTailToReplaceReference != null ? !this.myTailToReplaceReference.equals(that.myTailToReplaceReference) : that.myTailToReplaceReference != null) {
                return false;
            }
            if (!Arrays.equals(this.myTail, that.myTail)) {
                return false;
            }
            return this.myImportType == that.myImportType;
        }

        public int hashCode() {
            int result = this.myModuleType.hashCode();
            result = 31 * result + this.myFromPath.hashCode();
            result = 31 * result + this.myFromFile.hashCode();
            result = 31 * result + this.myFirstWordInFile.hashCode();
            result = 31 * result + (this.myFirstWordInExportsName != null ? this.myFirstWordInExportsName.hashCode() : 0);
            result = 31 * result + (this.myTailToReplaceReference != null ? this.myTailToReplaceReference.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.myTail);
            result = 31 * result + (this.myModuleElementIsMissing ? 1 : 0);
            result = 31 * result + Objects.hashCode((Object)this.myImportType);
            return result;
        }
    }
}

