/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        PsiElement[] elements = JSGotoDeclarationHandler.getGotoDeclarationTargetsImpl(sourceElement);
        if (elements != null && elements.length > 0) {
            return (PsiElement[])Arrays.stream(elements).map(el -> JSTargetElementEvaluator.adjustTargetElement(el)).toArray(PsiElement[]::new);
        }
        return elements;
    }

    @Nullable
    public static PsiElement[] getGotoDeclarationTargetsImpl(@NotNull PsiElement sourceElement) {
        PsiElement resolved;
        List<JSFunctionWithSubstitutor> result;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler", "getGotoDeclarationTargetsImpl"));
        }
        ASTNode node = sourceElement.getNode();
        if (node == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements = importedBinding.findReferencedElements();
            if (elements.size() > 0) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        if ((result = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes(parent)).size() > 0) {
            return (PsiElement[])result.stream().map(el -> el.myFunctionItem).toArray(PsiElement[]::new);
        }
        JSReferenceExpression referenceExpression = parent instanceof JSReferenceExpression ? (JSReferenceExpression)parent : null;
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property && ((ES6Property)grandParent).isShorthanded() && (resolved = referenceExpression.resolve()) != null) {
            return new PsiElement[]{resolved};
        }
        return null;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }
}

