/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    protected JSType doGetDeclarationTypeStubSafe() {
        return TypeScriptPsiUtil.getTypeFromDeclaration(this);
    }

    @Override
    @Nullable
    protected final JSType doGetType() {
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            PsiElement parent = this.getParent();
            if (JSDestructuringUtil.isDestructuring(parent)) {
                return new JSDestructuringTypeImpl((Segment)this.getTextRange(), JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
            JSExpression initializer = this.getInitializer();
            if (initializer != null) {
                JSType possibleType;
                if (initializer instanceof JSLiteralExpression && (possibleType = JSTypeUtils.getApparentType(JSTypeEvaluator.getTypeFromConstant(initializer))) != null) {
                    return possibleType;
                }
                return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return null;
    }

    @Override
    protected final JSType doGetStubType(JSVariableStub<JSVariable> stub) {
        String typeString = stub.getTypeString();
        if (typeString == null) {
            return this.doGetDeclarationTypeStubSafe();
        }
        return TypeScriptVariableImpl.getTypeFromStubString(this, stub, typeString);
    }

    @Nullable
    public static JSType getTypeFromStubString(@NotNull JSVariable variable, @NotNull JSVariableStubBase<?> stub, @NotNull String typeString) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "getTypeFromStubString"));
        }
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "getTypeFromStubString"));
        }
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "getTypeFromStubString"));
        }
        return JSTypeUtils.parseSerializedType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)variable, stub.isTypeExplicitlyDeclared()));
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    public String getName() {
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this.myName == null) {
            this.myName = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        }
        return this.myName;
    }

    @Override
    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return super.useLocalSearchScope(declarationScope) && !(declarationScope instanceof TypeScriptModule);
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }
}

