/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeNameValuePairStub;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeNameValuePairImpl
extends JSStubElementImpl<JSAttributeNameValuePairStub>
implements JSAttributeNameValuePair {
    public static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.IDENTIFIER_TOKENS_SET, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DEFAULT_KEYWORD})});

    public JSAttributeNameValuePairImpl(ASTNode node) {
        super(node);
    }

    public JSAttributeNameValuePairImpl(JSAttributeNameValuePairStub node) {
        super(node, (IStubElementType)JSElementTypes.ATTRIBUTE_NAME_VALUE_PAIR);
    }

    public static boolean areEquivalent(@NotNull JSAttributeNameValuePair pair1, @NotNull JSAttributeNameValuePair pair2) {
        if (pair1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair1", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "areEquivalent"));
        }
        if (pair2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair2", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "areEquivalent"));
        }
        return Comparing.equal((String)pair1.getName(), (String)pair2.getName()) && Comparing.equal((String)pair1.getSimpleValue(), (String)pair2.getSimpleValue());
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement parentNavElement;
        PsiElement parent = this.getParent();
        if (parent instanceof JSAttribute && (parentNavElement = parent.getNavigationElement()) != parent) {
            assert (parentNavElement instanceof JSAttribute);
            for (JSAttributeNameValuePair pair : ((JSAttribute)parentNavElement).getValues()) {
                if (!JSAttributeNameValuePairImpl.areEquivalent(this, pair)) continue;
                JSAttributeNameValuePair jSAttributeNameValuePair = pair;
                if (jSAttributeNameValuePair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "getNavigationElement"));
                }
                return jSAttributeNameValuePair;
            }
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAttributeNameValuePair((JSAttributeNameValuePair)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public ItemPresentation getPresentation() {
        final String value = this.getSimpleValue();
        if (value == null || !"name".equals(this.getName())) {
            return super.getPresentation();
        }
        final PsiFile file = this.getContainingFile();
        if (file == null) {
            return super.getPresentation();
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class);
        final String qName = jsClass != null ? jsClass.getQualifiedName() : null;
        return new ItemPresentation(){

            public String getPresentableText() {
                return value;
            }

            public String getLocationString() {
                return qName != null ? qName : file.getName();
            }

            public Icon getIcon(boolean open) {
                return JSAttributeNameValuePairImpl.this.getIcon(0);
            }
        };
    }

    public String getName() {
        JSAttributeNameValuePairStub stub = (JSAttributeNameValuePairStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "setName"));
        }
        throw new IncorrectOperationException();
    }

    @Nullable
    public ASTNode getValueNode() {
        return this.findValueNode();
    }

    @Nullable
    public String getSimpleValue() {
        JSAttributeNameValuePairStub stub = (JSAttributeNameValuePairStub)this.getGreenStub();
        if (stub != null) {
            return stub.getValue();
        }
        ASTNode expression = this.findValueNode();
        return expression != null ? StringUtil.stripQuotesAroundValue((String)expression.getText()) : null;
    }

    @Nullable
    public ASTNode findValueNode() {
        return JSPsiImplUtils.findAnnotationAttributeValueNode(this.getNode());
    }

    @NotNull
    public PsiReference[] getReferences() {
        NameReference nameRef = null;
        ASTNode node = this.getNode().findChildByType(IDENTIFIER_TOKENS_SET);
        if (node != null) {
            nameRef = new NameReference(node);
        }
        Object[] valueRefs = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (nameRef != null) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])valueRefs, (Object)nameRef, PsiReference.class);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "getReferences"));
            }
            return psiReferenceArray;
        }
        if (valueRefs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl", "getReferences"));
        }
        return valueRefs;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(IDENTIFIER_TOKENS_SET);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    private class NameReference
    implements PsiReference,
    EmptyResolveMessageProvider {
        private final ASTNode myNode;

        public NameReference(ASTNode node) {
            this.myNode = node;
        }

        public PsiElement getElement() {
            return JSAttributeNameValuePairImpl.this;
        }

        public TextRange getRangeInElement() {
            int offset = this.myNode.getStartOffset() - JSAttributeNameValuePairImpl.this.getTextOffset();
            return new TextRange(offset, offset + this.myNode.getTextLength());
        }

        public PsiElement resolve() {
            String attributeName = this.getCanonicalText();
            if ("_DEFAULT_".equals(attributeName)) {
                return null;
            }
            XmlElementDescriptor descriptor2 = ((JSAttributeImpl)JSAttributeNameValuePairImpl.this.getParent()).getBackedDescriptor();
            if (descriptor2 != null) {
                XmlAttributeDescriptor attributeDescriptor = descriptor2.getAttributeDescriptor(attributeName, null);
                if (attributeDescriptor != null) {
                    return attributeDescriptor.getDeclaration();
                }
            } else {
                return this.getElement();
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myNode.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "bindToElement"));
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            XmlElementDescriptor elementDescriptor = ((JSAttributeImpl)JSAttributeNameValuePairImpl.this.getParent()).getBackedDescriptor();
            if (elementDescriptor != null) {
                Object[] descriptors = elementDescriptor.getAttributesDescriptors(null);
                for (int i = 0; i < descriptors.length; ++i) {
                    if (!"_DEFAULT_".equals(descriptors[i].getName())) continue;
                    Object[] objectArray = ArrayUtil.remove((Object[])descriptors, (int)i);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "getVariants"));
                    }
                    return objectArray;
                }
                if (descriptors == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "getVariants"));
                }
                return descriptors;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Unknown metadata attribute" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeNameValuePairImpl$NameReference", "getUnresolvedMessagePattern"));
            }
            return "Unknown metadata attribute";
        }
    }
}

