/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSRecursiveNodeVisitor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FunctionNodesVisitor
extends JSRecursiveNodeVisitor {
    FunctionNodesVisitor() {
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
    }

    @Override
    public void visitFunctionProperty(ASTNode node) {
    }

    @Override
    public void visitAttributeList(ASTNode node) {
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    static class JSFunctionNodesCacheVisitor
    extends FunctionNodesVisitor {
        private JSFunctionBaseImpl myBase;
        private final JSFunctionCachedData myCachedData;
        private final List<JSFunction> myNestedFuns;
        private final List<JSType> myEvaluatedReturnTypes;
        private final Map<String, UnqualifiedNamesUsages> myUnqualifiedNamesUsages;

        public JSFunctionNodesCacheVisitor(JSFunctionBaseImpl base, JSFunctionCachedData cachedData, List<JSFunction> nestedFuns, List<JSType> evaluatedReturnTypes) {
            this.myBase = base;
            this.myCachedData = cachedData;
            this.myNestedFuns = nestedFuns;
            this.myEvaluatedReturnTypes = evaluatedReturnTypes;
            this.myUnqualifiedNamesUsages = new THashMap();
        }

        @Override
        protected void visitDestructuringParameter(ASTNode node) {
            super.visitElement(node);
        }

        @Override
        public void visitParameter(ASTNode node) {
            ASTNode child = JSParameterImpl.findParameterNameIdentifier(node);
            if (child == null) {
                child = node.getFirstChildNode();
            }
            UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
            nameUsages.hasDeclaredParameter = true;
        }

        @Override
        public void visitVariable(ASTNode node) {
            super.visitVariable(node);
            ASTNode child = JSVariableBaseImpl.findVariableNameIdentifier(node);
            if (child != null) {
                UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
                nameUsages.hasDeclaredVariable = true;
            }
        }

        @Override
        public void visitReferenceExpression(ASTNode node) {
            ASTNode childNode;
            if (node.findChildByType(JSElementTypes.EXPRESSIONS) == null && JSFunctionBaseImpl.isInJS(node) && (childNode = node.getFirstChildNode()) != null && childNode.getTreeNext() == null) {
                String nodeText = childNode.getText();
                UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(nodeText);
                nameUsages.isReferenced = true;
                return;
            }
            super.visitReferenceExpression(node);
        }

        @Override
        public void visitThisExpression(ASTNode node) {
            this.myCachedData.referencesThis = true;
        }

        @Override
        public void visitFunctionExpression(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
        }

        @Override
        public void visitFunctionDeclaration(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
            ASTNode child = JSPsiImplUtils.findNameIdentifierOfFunction(node);
            if (child != null) {
                UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(child.getText());
                nameUsages.hasDeclaredVariable = true;
            }
        }

        @Override
        public void visitFunctionProperty(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
        }

        @Override
        public void visitBinaryExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.OROR);
            if (child != null) {
                this.addRef(node);
            } else {
                child = node.findChildByType(JSTokenTypes.ANDAND);
                if (child != null) {
                    this.addRef(node);
                } else {
                    ASTNode identifier;
                    ASTNode childByType = node.findChildByType(JSTokenTypes.EQUALITY_OPERATIONS);
                    if (childByType != null && (identifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, childByType)) != null) {
                        if (identifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                            this.addRef(node);
                        } else {
                            ASTNode firstIdentifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                            if (firstIdentifier != null && firstIdentifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                                this.addExpr(identifier);
                            }
                        }
                    }
                }
            }
            super.visitBinaryExpression(node);
        }

        @Override
        public void visitPrefixExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.TYPEOF_KEYWORD);
            if (child == null) {
                child = node.findChildByType(JSTokenTypes.EXCL);
            }
            if (child != null) {
                this.addRef(node);
            }
            super.visitPrefixExpression(node);
        }

        @Override
        public void visitIfStatement(ASTNode node) {
            this.addRef(node);
            super.visitIfStatement(node);
        }

        @Override
        public void visitProperty(ASTNode node) {
            ASTNode expr;
            ASTNode name = JSPropertyImpl.findNameIdentifier(node);
            if (name != null && (expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, name.getTreeNext())) != null && expr != name) {
                this.addExpr(expr);
            }
            super.visitProperty(node);
        }

        @Override
        public void visitArgumentList(ASTNode node) {
            ASTNode expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
            while (expr != null) {
                this.addExpr(expr);
                ASTNode treeNext = expr.getTreeNext();
                expr = treeNext != null ? node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, treeNext) : null;
            }
            super.visitArgumentList(node);
        }

        @Override
        protected void visitYieldExpression(ASTNode node) {
            JSType type;
            JSYieldExpression yieldExpression;
            JSExpression expression;
            if (this.myBase.isGenerator() && (expression = (yieldExpression = (JSYieldExpression)node.getPsi()).getExpression()) != null && (type = this.visitReturnNode(node, expression)) != null) {
                this.addTypeToReturnTypeCollection(yieldExpression.isIterable() ? new JSIterableComponentTypeImpl(type, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : type);
            }
            super.visitYieldExpression(node);
        }

        @Override
        public void visitReturnStatement(ASTNode node) {
            JSType type;
            if (!this.myBase.isGenerator() && (type = this.visitReturnNode(node, ((JSReturnStatement)node.getPsi()).getExpression())) != null) {
                this.addTypeToReturnTypeCollection(type);
            }
            super.visitReturnStatement(node);
        }

        @Nullable
        private JSType visitReturnNode(ASTNode node, JSExpression expression) {
            String text;
            ASTNode invoked;
            ASTNode newExpr = node.findChildByType(JSElementTypes.NEW_EXPRESSIONS);
            if (newExpr != null && (invoked = newExpr.findChildByType(JSElementTypes.REFERENCE_EXPRESSION)) != null && JSReferenceExpressionImpl.getQualifierNode(invoked) == null && (text = invoked.getText()).equals(this.myBase.getName())) {
                UnqualifiedNamesUsages value = this.getOrCreateUnqualifiedNameUsages(text);
                value.isReturnedInNew = true;
            }
            return !this.myBase.shouldEvaluateReturnTypeFromBody() ? null : (expression != null ? JSFunctionNodesCacheVisitor.expressionToType(expression) : new JSUndefinedType(JSTypeSourceFactory.createTypeSource(node.getPsi(), true)));
        }

        private static JSType expressionToType(@NotNull JSExpression expression) {
            JSType possibleType;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/impl/FunctionNodesVisitor$JSFunctionNodesCacheVisitor", "expressionToType"));
            }
            if (expression instanceof JSLiteralExpression && (possibleType = JSTypeUtils.getApparentType(JSTypeEvaluator.getTypeFromConstant(expression))) != null) {
                return possibleType;
            }
            return new JSTypeofTypeImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
        }

        private void addTypeToReturnTypeCollection(@NotNull JSType returnType) {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/lang/javascript/psi/impl/FunctionNodesVisitor$JSFunctionNodesCacheVisitor", "addTypeToReturnTypeCollection"));
            }
            List<JSType> newTypes = JSTypeUtils.addPossibleOption(this.myEvaluatedReturnTypes, returnType);
            this.myEvaluatedReturnTypes.addAll(newTypes);
        }

        @Override
        public void visitCallExpression(ASTNode node) {
            PsiElement callExpression = node.getPsi();
            JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                JSReferenceExpression extensionSymbol;
                JSExpression[] arguments;
                String calledMethodName = ((JSReferenceExpression)methodExpression).getReferenceName();
                if (JSSymbolUtil.isExtendCall(((JSReferenceExpression)methodExpression).getQualifier(), calledMethodName, null) && (arguments = ((JSCallExpression)callExpression).getArguments()).length >= 2 && arguments[0] instanceof JSReferenceExpression && arguments[1] instanceof JSReferenceExpression && (extensionSymbol = (JSReferenceExpression)arguments[1]).getQualifier() == null) {
                    this.myCachedData.extensionSymbols.put(extensionSymbol.getReferenceName(), (JSReferenceExpression)arguments[0]);
                }
            }
            super.visitCallExpression(node);
        }

        private void addRef(ASTNode node) {
            ASTNode treeNext;
            ASTNode treeParent;
            ASTNode firstExpr = node.findChildByType(JSVariableImpl.IDENTIFIER_TOKENS_SET);
            this.addExpr(firstExpr);
            if (firstExpr != null && node.getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeParent = node.getTreeParent()).getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeNext = firstExpr.getTreeNext()) != null) {
                this.addExpr(node.findChildByType(JSElementTypes.EXPRESSIONS, treeNext));
            }
        }

        private void addExpr(ASTNode expr) {
            ASTNode node;
            if (expr != null && expr.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expr) == null && (node = expr.getFirstChildNode()).getTreeNext() == null) {
                String ref = node.getText();
                UnqualifiedNamesUsages nameUsages = this.getOrCreateUnqualifiedNameUsages(ref);
                nameUsages.isOptionalCandidate = true;
            }
        }

        void summarizeNamesUsages(TObjectIntHashMap<String> declaredParameters) {
            for (Map.Entry<String, UnqualifiedNamesUsages> entry : this.myUnqualifiedNamesUsages.entrySet()) {
                String name = entry.getKey();
                UnqualifiedNamesUsages namesUsages = entry.getValue();
                if (namesUsages.hasDeclaredParameter) {
                    this.myCachedData.declaredParameters.add(name);
                }
                if (namesUsages.hasDeclaredVariable) {
                    this.myCachedData.declaredVariableNames.put((Object)name, 0);
                }
                if (namesUsages.isReferenced && !namesUsages.hasDeclaredVariable && !namesUsages.hasDeclaredParameter) {
                    this.myCachedData.referencedVariableNames.put((Object)name, 0);
                }
                if (namesUsages.isOptionalCandidate) {
                    if (namesUsages.hasDeclaredParameter && !namesUsages.hasDeclaredVariable) {
                        declaredParameters.put((Object)name, 1);
                    } else if (!namesUsages.hasDeclaredVariable) {
                        this.myCachedData.referencedVariableNames.put((Object)name, 1);
                    }
                }
                if (!namesUsages.isReturnedInNew || namesUsages.hasDeclaredParameter || namesUsages.hasDeclaredVariable) continue;
                this.myCachedData.constructorCanBeInvokedWithoutNew = this.myCachedData.referencesThis;
            }
        }

        private UnqualifiedNamesUsages getOrCreateUnqualifiedNameUsages(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/FunctionNodesVisitor$JSFunctionNodesCacheVisitor", "getOrCreateUnqualifiedNameUsages"));
            }
            UnqualifiedNamesUsages value = this.myUnqualifiedNamesUsages.get(name);
            if (value == null) {
                value = new UnqualifiedNamesUsages();
                this.myUnqualifiedNamesUsages.put(name, value);
            }
            return value;
        }

        private static class UnqualifiedNamesUsages {
            boolean hasDeclaredParameter;
            boolean hasDeclaredVariable;
            boolean isReferenced;
            boolean isOptionalCandidate;
            boolean isReturnedInNew;

            private UnqualifiedNamesUsages() {
            }
        }
    }
}

