/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSArgumentListImpl
extends JSElementImpl
implements JSArgumentList {
    public JSArgumentListImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public JSExpression[] getArguments() {
        ASTNode[] nodes = JSArgumentListImpl.getArguments(this.getNode());
        if (nodes.length == 0) {
            if (JSExpression.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl", "getArguments"));
            }
            return JSExpression.EMPTY_ARRAY;
        }
        JSExpression[] exprs = new JSExpression[nodes.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = (JSExpression)nodes[i].getPsi();
        }
        if (exprs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl", "getArguments"));
        }
        return exprs;
    }

    @NotNull
    public static ASTNode[] getArguments(@NotNull ASTNode argumentListNode) {
        if (argumentListNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentListNode", "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl", "getArguments"));
        }
        ASTNode[] aSTNodeArray = argumentListNode.getChildren(JSElementTypes.EXPRESSIONS);
        if (aSTNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl", "getArguments"));
        }
        return aSTNodeArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSArgumentListImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSArgumentList((JSArgumentList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void delete() throws IncorrectOperationException {
        PsiElement element = this.getParent();
        element.replace((PsiElement)((JSCallExpression)element).getMethodExpression());
    }

    public boolean hasSpreadElement() {
        return this.getNode().findChildByType(JSElementTypes.SPREAD_EXPRESSION) != null;
    }
}

