/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public class JSArrayLiteralExpressionImpl
extends JSExpressionImpl
implements JSArrayLiteralExpression {
    public JSArrayLiteralExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    public JSExpression[] getExpressions() {
        return (JSExpression[])JSArrayLiteralExpressionImpl.getExpressionsWithSkippedElements((PsiElement)this, (TokenSet)JSElementTypes.EXPRESSIONS, JSExpression[]::new);
    }

    public static <T extends PsiElement> T[] getExpressionsWithSkippedElements(@NotNull PsiElement context, @NotNull TokenSet tokenSet, @NotNull IntFunction<T[]> factory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl", "getExpressionsWithSkippedElements"));
        }
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl", "getExpressionsWithSkippedElements"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl", "getExpressionsWithSkippedElements"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        boolean wasExpression = false;
        for (ASTNode child = context.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (tokenSet.contains(type)) {
                result.add(child.getPsi());
                wasExpression = true;
                continue;
            }
            if (type != JSTokenTypes.COMMA) continue;
            if (wasExpression) {
                wasExpression = false;
                continue;
            }
            result.add(null);
        }
        return (PsiElement[])result.stream().toArray(factory);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSArrayLiteralExpression((JSArrayLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

