/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSCaseClauseImpl
extends JSElementImpl
implements JSCaseClause {
    public JSCaseClauseImpl(IElementType elementType) {
        super(elementType);
    }

    public boolean isDefault() {
        return this.getNode().findChildByType(JSTokenTypes.DEFAULT_KEYWORD) != null;
    }

    public JSExpression getCaseExpression() {
        if (this.isDefault()) {
            return null;
        }
        ASTNode node = this.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    public JSStatement[] getStatements() {
        ASTNode[] nodes = this.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        JSStatement[] statements = new JSStatement[nodes.length];
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = (JSStatement)nodes[i].getPsi();
        }
        return statements;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSCaseClauseImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSCaseClause((JSCaseClause)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

