/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceSetElement
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    @NotNull
    protected final String myCanonicalText;
    @NotNull
    protected final TextRange myRangeInElement;
    protected JSReferenceSet mySet;

    protected JSReferenceSetElement(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "<init>"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "<init>"));
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
    }

    public PsiElement getElement() {
        return this.mySet.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "getRangeInElement"));
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        Object[] resolveResults = this.multiResolve(false);
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        int i = StringUtil.lastIndexOfAny((CharSequence)newElementName, (String)".#~");
        if (i != -1) {
            newElementName = newElementName.substring(0, i);
        }
        return JSReferenceSetElement.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "bindToElement"));
        }
        String qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element);
        if (qName != null) {
            JSReferenceSetElement.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSReferenceUtil.isReferenceTo(this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    public boolean isOnlyFqns() {
        return this.mySet.onlyFqns;
    }

    public Collection<String> getBaseClassFqns() {
        return this.mySet.myBaseClassFqns;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    public LocalQuickFix[] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedNameImpl qName = null;
        for (PsiReference ref : this.mySet.myReferences) {
            qName = JSQualifiedNameImpl.create(ref.getCanonicalText(), qName);
            if (ref == this) break;
        }
        assert (qName != null) : this;
        JSQualifiedNameImpl jSQualifiedNameImpl = qName;
        if (jSQualifiedNameImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement", "getQualifiedName"));
        }
        return jSQualifiedNameImpl;
    }

    public void processLocalVariants(PsiFile psiFile, SinkResolveProcessor<?> processor, PsiElement context) {
    }

    private static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.getManipulator((PsiElement)elt).handleContentChange(elt, range, newElementName);
    }
}

