/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSTextReference
extends JSReferenceSetElement
implements EmptyResolveMessageProvider {
    protected final boolean myMethodRef;

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset, boolean methodRef) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        this(set, s, methodRef, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, boolean methodRef, @NotNull TextRange rangeInElement) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        super(set, s, rangeInElement);
        this.myMethodRef = methodRef;
    }

    public void processToSink(PsiFile containingFile, ResultSink resultSink) {
        MyResolveProcessor processor = this.createResolveProcessor(resultSink.getName(), resultSink.place, resultSink);
        this.doProcess(containingFile, processor);
    }

    protected MyResolveProcessor createResolveProcessor(String name, PsiElement place, ResultSink resultSink) {
        return new MyResolveProcessor(name, place, resultSink);
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        ArrayList<String> contextNames = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref : this.mySet.myReferences) {
            if (ref == this) break;
            if (contextNames == null) {
                contextNames = new ArrayList<String>(3);
            }
            contextNames.add(ref.getCanonicalText());
            prevContextReference = ref;
        }
        if (contextNames == null && this.myRangeInElement.getStartOffset() > 0) {
            JSExpression expression;
            PsiElement elt = this.findNearestClass();
            if (this.myMethodRef && elt instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elt).getExpression()) instanceof JSAssignmentExpression) {
                JSExpression jsExpression = ((JSAssignmentExpression)expression).getLOperand();
                if (jsExpression instanceof JSDefinitionExpression) {
                    jsExpression = ((JSDefinitionExpression)jsExpression).getExpression();
                }
                if (jsExpression instanceof JSReferenceExpression) {
                    String qualifier;
                    JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                    boolean stripQualifier = true;
                    if (rOperand instanceof JSFunction && ((JSFunction)rOperand).isConstructor()) {
                        stripQualifier = false;
                    }
                    if (stripQualifier) {
                        jsExpression = ((JSReferenceExpression)jsExpression).getQualifier();
                    }
                    if (jsExpression != null && (qualifier = JSContextResolver.getQualifierOfExprAsString((JSElement)jsExpression)) != null) {
                        contextNames = new ArrayList<String>(3);
                        BaseJSSymbolProcessor.addIndexListFromQName(qualifier, contextNames);
                    }
                }
            }
        } else if (contextNames != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                contextNames = new ArrayList<String>(3);
                BaseJSSymbolProcessor.addIndexListFromQName(qName, contextNames);
            }
        }
        JSQualifiedNameImpl qualifier = contextNames != null ? JSQualifiedNameImpl.fromComponents(contextNames) : null;
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(this.getCanonicalText(), qualifier);
        if (jSQualifiedNameImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "getQualifiedName"));
        }
        return jSQualifiedNameImpl;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.mySet.element.getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file, this, new MyResolver(this, file), incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    protected ResolveResult[] doResolve(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/psi/impl/JSTextReference", "doResolve"));
        }
        if ("int".equals(this.myCanonicalText) || "uint".equals(this.myCanonicalText) || ("Null".equals(this.myCanonicalText) || "null".equals(this.myCanonicalText) || "Undefined".equals(this.myCanonicalText)) && this.getElement() instanceof JSDocTagValue) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        if (this.useActionScriptIndex(psiFile)) {
            MyResolveProcessor processor = this.createResolveProcessor(this.myCanonicalText, (PsiElement)psiFile, new ResolveResultSink((PsiElement)psiFile, this.myCanonicalText));
            this.doProcess(psiFile, processor);
            return processor.getResultsAsResolveResults();
        }
        return this.doSymbolResolve(psiFile);
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/psi/impl/JSTextReference", "useActionScriptIndex"));
        }
        return DialectDetector.isActionScript((PsiElement)psiFile) || this.mySet.onlyFqns;
    }

    private void doProcess(PsiFile psiFile, SinkResolveProcessor processor) {
        PsiElement nearestClass = this.findNearestClass();
        int index = this.calcMyIndex();
        if (index == 0) {
            if ("this".equals(this.myCanonicalText) && nearestClass instanceof JSClass) {
                processor.addResult(nearestClass);
                return;
            }
            if (this.myRangeInElement.getStartOffset() > 0) {
                if (nearestClass instanceof JSClass && !(this.mySet.element instanceof JSLiteralExpression)) {
                    processor.setToProcessHierarchy(true);
                    processor.setTypeContext(true);
                    processor.configureClassScope((JSClass)nearestClass);
                    if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                        return;
                    }
                }
            } else if (nearestClass instanceof JSClass) {
                processor.setTypeContext(true);
                processor.setToProcessMembers(false);
                if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                    return;
                }
                if (!this.mySet.onlyFqns && this.mySet.element instanceof JSDocTagValue) {
                    String packageName = JSResolveUtil.getPackageName(nearestClass);
                    processor.setForcedPackageName(packageName);
                    String classQName = !packageName.isEmpty() ? packageName + "." + this.myCanonicalText : this.myCanonicalText;
                    PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(nearestClass).getClassResolver().findClassByQName(classQName, nearestClass);
                    if (clazz != null && !clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), clazz, clazz)) {
                        return;
                    }
                }
            }
            PsiElement startFrom = this.mySet.element;
            PsiElement lastParent = this.mySet.element.getParent();
            if (this.mySet.element instanceof JSLiteralExpression) {
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.mySet.element, JSFunction.class);
                while (fun != null) {
                    startFrom = fun;
                    lastParent = fun.getParent();
                    fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
                }
            }
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, this.mySet.element);
            if (!(psiFile instanceof JSFile) && !(psiFile instanceof XmlFile) && psiFile.getContext() == null) {
                JSResolveUtil.processGlobalThings(processor, ResolveState.initial(), (PsiElement)psiFile, (PsiElement)psiFile);
            }
        } else {
            PsiElement psiElement = this.mySet.myReferences[index - 1].resolve();
            if (psiElement instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)psiElement).getType() == JSImplicitElement.Type.Tag) {
                psiElement = ((JSOffsetBasedImplicitElement)psiElement).getElementAtOffset();
            }
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement != null) {
                JSType type = null;
                if (psiElement instanceof JSVariable) {
                    type = ((JSVariable)psiElement).getType();
                } else if (psiElement instanceof JSFunction && ((JSFunction)psiElement).isGetProperty()) {
                    type = ((JSFunction)psiElement).getReturnType();
                }
                if (type != null) {
                    String typeText = type.getTypeText();
                    typeText = JSTypeUtils.getTypeMatchingNamespace(typeText);
                    String qname = JSImportHandlingUtil.resolveTypeName(typeText, psiElement);
                    assert (qname != null);
                    PsiElement typeClass = JSClassResolver.findClassFromNamespace(qname, psiElement);
                    if (typeClass instanceof JSClass) {
                        psiElement = typeClass;
                    }
                }
                if (psiElement instanceof JSClass) {
                    processor.setToProcessHierarchy(true);
                }
                String packageName = null;
                if (psiElement instanceof JSPackageWrapper) {
                    packageName = ((JSPackageWrapper)psiElement).getQualifiedName();
                } else if (psiElement instanceof JSClass) {
                    packageName = JSResolveUtil.getPackageName(psiElement);
                }
                if (packageName != null) {
                    processor.setForcedPackageName(packageName);
                }
                if (psiElement instanceof JSClass) {
                    processor.configureClassScope((JSClass)psiElement);
                    processor.setAllowUnqualifiedStaticsFromInstance(true);
                }
                psiElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), psiElement, psiElement);
            }
        }
        if (psiFile instanceof XmlFile && !JavaScriptSupportLoader.isMxmlOrFxgFile(psiFile)) {
            JSResolveUtil.processTopLevelClasses(processor, ResolveState.initial(), psiFile.getProject(), JSResolveUtil.getResolveScope((PsiElement)psiFile), this.mySet.onlyFqns ? JSResolveUtil.GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : JSResolveUtil.GlobalSymbolsAcceptanceState.WHATEVER, false);
        }
    }

    private int calcMyIndex() {
        int i;
        for (i = 0; i < this.mySet.myReferences.length && this.mySet.myReferences[i] != this; ++i) {
        }
        return i;
    }

    private PsiElement findNearestClass() {
        PsiElement originalElement;
        PsiElement parent;
        PsiElement elt = this.mySet.element;
        PsiElement candidateBlock = null;
        while (!((parent = elt.getParent()) instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTagChild)) {
            if (parent instanceof JSBlockStatement) {
                candidateBlock = elt;
            }
            if ((elt = parent) != null && !(elt instanceof JSClass)) continue;
        }
        if (parent instanceof XmlTag) {
            if (XmlBackedJSClassImpl.isComponentTag((XmlTag)parent)) {
                XmlTag[] subtags = ((XmlTag)parent).getSubTags();
                if (subtags.length > 0) {
                    elt = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]);
                }
            } else {
                XmlFile xmlFile = (XmlFile)parent.getContainingFile();
                if (JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)xmlFile)) {
                    elt = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
                }
            }
        }
        if (elt != null && !(elt instanceof JSClass) && candidateBlock != null) {
            elt = candidateBlock;
        }
        if (elt != null && (originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)elt)) != null) {
            elt = originalElement;
        }
        return elt;
    }

    private ResolveResult[] doSymbolResolve(PsiFile psiFile) {
        String name;
        if ("*".equals(this.myCanonicalText) || "?".equals(this.myCanonicalText)) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        if (this.mySet.element instanceof JSDocTagValue && this.myRangeInElement.getStartOffset() == 0 && this.mySet.myReferences.length == 1 && "property".equals(name = ((JSDocTag)this.mySet.element.getParent()).getName())) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        String text = this.myCanonicalText;
        PsiElement elt = this.getElement();
        if ((elt instanceof JSDocTagValue || elt instanceof JSDocComment) && this.mySet.myReferences.length == 1 && this.mySet.myReferences[this.mySet.myReferences.length - 1] == this && !this.myMethodRef) {
            text = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(text);
        }
        return JSTextReference.defaultResolve(this, psiFile, text);
    }

    public static ResolveResult[] defaultResolve(JSReferenceSetElement element, PsiFile psiFile, String text) {
        ResolveResult[] localResults;
        PsiElement referenceElement = element.mySet.element;
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(text, psiFile, referenceElement);
        JSQualifiedName qualifiedName = element.getQualifiedName();
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            processor.addTypeHierarchy(new JSNamespaceImpl(qualifier, JSContext.UNKNOWN, true), null);
        }
        processor.allowPartialResults();
        processor.setAddOnlyCompleteMatches(qualifier != null || !(referenceElement instanceof JSLiteralExpression));
        String str = qualifiedName.getQualifiedName();
        PsiElement context = psiFile.getContext();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(referenceElement, str));
            element.processLocalVariants(psiFile, localProcessor, context);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            return localResults;
        }
        if (context != null) {
            JSResolveUtil.tryProcessXmlFileImplicitElements(context, processor);
        }
        JSReferenceExpressionResolver.processAllSymbols(processor);
        return processor.getResults();
    }

    @Override
    public void processLocalVariants(PsiFile psiFile, SinkResolveProcessor<?> processor, PsiElement context) {
        this.doProcessLocalVariants(psiFile, processor, context, (Condition<PsiElement>)((Condition)element -> {
            JSNamedElement namedElement = element instanceof JSNamedElement ? (JSNamedElement)element : null;
            return namedElement != null && !JSUtils.isLocallyDefined(namedElement, (PsiElement)JSPsiImplUtils.getScopeNode(namedElement));
        }));
    }

    protected final void doProcessLocalVariants(PsiFile psiFile, final SinkResolveProcessor<?> processor, PsiElement context, final Condition<PsiElement> filter) {
        if (context == null && this.mySet.myReferences[0] != this) {
            return;
        }
        String name = processor.getName();
        JSResolveUtil.treeWalkUp(new ResolveProcessor(name){
            {
                super(name);
                this.setProcessingOptions(new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions());
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSTextReference$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSTextReference$1", "execute"));
                }
                if (filter.value((Object)element)) {
                    return processor.execute(element, state);
                }
                return true;
            }
        }, this.mySet.element, this.mySet.element, this.mySet.element);
        if (context != null) {
            JSResolveUtil.treeWalkUp(processor, (PsiElement)psiFile, (PsiElement)psiFile, this.mySet.element);
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String text = this.getCanonicalText();
        text = "'" + text.replace("'", "''") + "'";
        String string = JSBundle.message((String)(this.mySet.element.getParent() instanceof TypeScriptImportStatement ? "javascript.unresolved.file" : "javascript.unresolved.variable.or.type.name.message2"), (Object[])new Object[]{text});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    static class MyResolver
    implements ResolveCache.PolyVariantResolver<JSTextReference> {
        private final JSTextReference myTextReference;
        private final PsiFile myContainingFile;

        MyResolver(JSTextReference reference, PsiFile file) {
            this.myTextReference = reference;
            this.myContainingFile = file;
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull JSTextReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolver", "resolve"));
            }
            ResolveResult[] resolveResultArray = this.myTextReference.doResolve(this.myContainingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolver", "resolve"));
            }
            return resolveResultArray;
        }
    }

    protected class MyResolveProcessor
    extends SinkResolveProcessor {
        private String normalizedQN;

        public MyResolveProcessor(String name, @NotNull PsiElement _place, ResultSink sink) {
            if (sink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "<init>"));
            }
            super(name, _place, sink);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            String qName;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "execute"));
            }
            if (JSTextReference.this.mySet.onlyFqns) {
                if (!(element instanceof JSPackageWrapper) && !(element instanceof JSClass)) {
                    return true;
                }
                if (this.myName != null && element instanceof JSClass && this.myName.equals(((JSClass)element).getName())) {
                    if (this.normalizedQN == null) {
                        this.normalizedQN = StringUtil.stripQuotesAroundValue((String)JSTextReference.this.mySet.myReferenceText).replace(':', '.');
                    }
                    if (!this.normalizedQN.equals(((JSClass)element).getQualifiedName())) {
                        return true;
                    }
                }
            }
            if (JSTextReference.this.mySet.myOnlyDefaultPackage && element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.isEmpty((String)StringUtil.getPackageName((String)qName))) {
                return true;
            }
            return super.execute(element, state);
        }
    }

    public static interface JSDeclarationModuleReference {
    }
}

