/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableBaseImpl<T extends JSVariableStubBase<T2>, T2 extends JSVariable>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSVariable {
    protected String myName;
    public static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.JS_IDENTIFIER_TOKENS_SET, JSKeywordSets.AS_IDENTIFIER_TOKENS_SET, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final TokenSet PROPERTY_NAME_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final IElementType[] TYPES_TO_SKIP = new IElementType[]{JSTokenTypes.DOC_COMMENT, JSStubElementTypes.ATTRIBUTE_LIST, JSStubElementTypes.ACTION_SCRIPT_ATTRIBUTE_LIST, JSElementTypes.REFERENCE_EXPRESSION, JSTokenTypes.WHITE_SPACE};
    private static final Key<ParameterizedCachedValue<JSType, JSVariableBaseImpl<?, ?>>> TYPE_KEY = Key.create((String)"js.variable.base.type");
    private static final ParameterizedCachedValueProvider<JSType, JSVariableBaseImpl<?, ?>> TYPE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSVariableBaseImpl<?, ?>>(){

        @Nullable
        public CachedValueProvider.Result<JSType> compute(JSVariableBaseImpl<?, ?> psi) {
            return this.captureCompute(psi);
        }

        private <StubT extends JSVariableStubBase<PsiT>, PsiT extends JSVariable> CachedValueProvider.Result<JSType> captureCompute(JSVariableBaseImpl<StubT, PsiT> psi) {
            JSVariableStubBase stub = (JSVariableStubBase)psi.getGreenStub();
            JSType type = stub != null ? psi.doGetStubType(stub) : psi.doGetType();
            return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    private static final Key<ParameterizedCachedValue<JSNamespace, JSVariableBaseImpl<?, ?>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"js.var.symbol.namespace");
    private static final ParameterizedCachedValueProvider<JSNamespace, JSVariableBaseImpl<?, ?>> NAMESPACE_PROVIDER = new ParameterizedCachedValueProvider<JSNamespace, JSVariableBaseImpl<?, ?>>(){

        @Nullable
        public CachedValueProvider.Result<JSNamespace> compute(JSVariableBaseImpl<?, ?> param) {
            JSVariableStubBase stub = (JSVariableStubBase)param.getGreenStub();
            JSNamespace data = stub != null ? stub.getJSNamespace() : ((JSVariableBaseImpl)param).calculateSymbolNamespace();
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{param.getContainingFile()});
        }
    };

    protected JSVariableBaseImpl(ASTNode node) {
        super(node);
    }

    protected <PsiT extends JSVariable> JSVariableBaseImpl(T stub, JSStubElementType<? extends JSVariableStubBase<PsiT>, PsiT> elementType) {
        super(stub, (IStubElementType)elementType);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myName = null;
        JSFunctionExpression initializer = this.tryGetFunctionExpressionInitializer();
        if (initializer instanceof JSStubElementImpl) {
            ((JSStubElementImpl)initializer).clearCaches();
        }
    }

    public boolean hasInitializer() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Nullable
    public JSExpression getInitializerOrStub() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getStub();
        if (stub != null) {
            if (!stub.keepsInitializerStub()) {
                return null;
            }
            StubElement initializerStub = StubTreeUtil.findChildStubByType(stub, JSElementTypes.EXPRESSIONS);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getInitializer();
    }

    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralOrReferenceInitializerText();
        }
        JSExpression expression = this.getInitializer();
        return expression instanceof JSLiteralExpression && !(expression instanceof JSXmlLiteralExpressionImpl) || expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)expression) ? expression.getText() : null;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope;
        if (this.hasBlockScope() && this.useLocalSearchScope(declarationScope = this.getDeclarationScope())) {
            LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getUseScope"));
        }
        return searchScope;
    }

    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return !(declarationScope instanceof PsiFile);
    }

    public String getName() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this.myName == null) {
            String referencedName;
            PsiElement element;
            ASTNode name = this.findNameIdentifier();
            if (name != null && (element = name.getPsi()) instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)element).getReferencedName()) != null) {
                return referencedName;
            }
            this.myName = name != null ? StringUtil.replaceUnicodeEscapeSequences((String)name.getText()) : "";
        }
        return this.myName;
    }

    public ASTNode findNameIdentifier() {
        return JSVariableBaseImpl.findVariableNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findVariableNameIdentifier(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "findVariableNameIdentifier"));
        }
        return node.findChildByType(PROPERTY_NAME_TOKENS_SET);
    }

    public JSAttributeList getAttributeList() {
        PsiElement parent = this.getParent();
        while (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSVarStatementBase)) {
            Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error("Containing var statement was not found for variable:" + this.getText() + " in " + this.getContainingFile().getName());
            return null;
        }
        JSVarStatementStub stub = (JSVarStatementStub)((JSVarStatementBase)parent).getGreenStub();
        if (stub == null) {
            IElementType type;
            for (ASTNode element = parent.getNode().getFirstChildNode(); element != null && !JSTokenTypes.VAR_MODIFIERS.contains(type = element.getElementType()); element = element.getTreeNext()) {
                if (!JSStubElementTypes.ATTRIBUTE_LISTS.contains(type)) continue;
                return (JSAttributeList)element.getPsi();
            }
            return null;
        }
        ArrayFactory factory = JSAttributeList[]::new;
        Object[] elements = (JSAttributeList[])stub.getChildrenByType(JSStubElementTypes.ATTRIBUTE_LISTS, factory);
        return (JSAttributeList)ArrayUtil.getFirstElement((Object[])elements);
    }

    public void setInitializer(JSExpression expr) throws IncorrectOperationException {
        throw new UnsupportedOperationException("TODO: implement");
    }

    @Nullable
    public JSType getType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
    }

    @Nullable
    protected JSType doGetStubType(T stub) {
        String typeString = stub.getTypeString();
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeDeclaration[] typeElements = (JSTypeDeclaration[])stub.getChildrenByType(JSElementTypes.TYPESCRIPT_OR_ES6_TYPES, JSTypeDeclaration.ARRAY_FACTORY);
        JSVariableBaseImpl scopeElement = typeElements.length > 0 ? typeElements[0] : this;
        return JSTypeUtils.parseSerializedType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)scopeElement, stub.isTypeExplicitlyDeclared()));
    }

    @Deprecated
    @Nullable
    public String getTypeString() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getTypeString();
        }
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }

    public PsiElement getTypeElement() {
        ASTNode node = JSPsiImplUtils.getTypeExpressionFromDeclaration(this);
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    protected JSType doGetType() {
        ASTNode typeExpr = JSPsiImplUtils.getTypeExpressionFromDeclaration(this);
        JSType typeFromDeclaration = JSPsiImplUtils.getTypeFromTypeExpr(typeExpr, this);
        if (typeFromDeclaration != null) {
            return typeFromDeclaration;
        }
        JSType typeFromComments = JSDocumentationUtils.findTypeFromComments((JSNamedElement)this);
        if (typeFromComments != null) {
            return typeFromComments;
        }
        return null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "setName"));
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null) {
            return this;
        }
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name);
        this.getNode().replaceChild(nameNode, nameElement);
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVariable((JSVariable)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    public boolean isConst() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConst();
        }
        ASTNode parent = JSDestructuringUtil.getParentSkippingDestructuring(this.getNode());
        if (parent == null) {
            return false;
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(parent.getElementType())) {
            ASTNode node;
            for (node = parent.getFirstChildNode(); node != null && ArrayUtil.contains((Object)node.getElementType(), (Object[])TYPES_TO_SKIP); node = node.getTreeNext()) {
            }
            if (node != null && node.getElementType() == JSTokenTypes.CONST_KEYWORD) {
                return true;
            }
        }
        return JSDocumentationUtils.calculateConst((PsiElement)this);
    }

    public boolean isLocal() {
        return this.getNamespace() == null && !this.isNamespaceExplicitlyDeclared() && PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class}) != null && JSDocumentationUtils.isClassOrInterface(this) == JSElementBase.ClassOrInterface.NONE;
    }

    public boolean hasBlockScope() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasBlockScope();
        }
        return JSVariableBaseImpl.hasBlockScope(this.getNode());
    }

    public static boolean hasBlockScope(@NotNull ASTNode varNode) {
        IElementType grandparentType;
        if (varNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varNode", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "hasBlockScope"));
        }
        ASTNode parent = JSDestructuringUtil.getParentSkippingDestructuring(varNode);
        if (parent == null) {
            return false;
        }
        IElementType varKeyword = parent.getFirstChildNode().getElementType();
        return JSElementTypes.VAR_STATEMENTS.contains(parent.getElementType()) && (varKeyword == JSTokenTypes.LET_KEYWORD || varKeyword == JSTokenTypes.CONST_KEYWORD && JSTreeUtil.getLanguage(varNode) != JavaScriptSupportLoader.ECMA_SCRIPT_L4) && !((grandparentType = parent.getTreeParent().getElementType()) instanceof IFileElementType) && !JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(grandparentType);
    }

    @Override
    public boolean isDeprecated() {
        if (JSPsiImplUtils.isDeprecatedFromAttribute((JSAttributeListOwner)this)) {
            return true;
        }
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated((PsiElement)this);
    }

    public PsiElement getDeclarationScope() {
        if (this.hasBlockScope()) {
            return PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class});
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
    }

    public Icon getIcon(int flags) {
        JSFunctionExpression functionExpression;
        boolean inClass = JSPsiImplUtils.isClassMember((PsiElement)this);
        Icon baseIcon = inClass ? PlatformIcons.FIELD_ICON : ((functionExpression = this.tryGetFunctionExpressionInitializer()) != null ? JSFunctionImpl.getFunctionBaseIcon((JSFunctionItem)functionExpression) : PlatformIcons.VARIABLE_ICON);
        return JSVariableBaseImpl.getIcon((JSPsiElementBase)this, baseIcon, flags);
    }

    public void delete() throws IncorrectOperationException {
        ASTNode myNode = this.getNode();
        ASTNode parent = myNode.getTreeParent();
        if (JSElementTypes.VAR_STATEMENTS.contains(parent.getElementType())) {
            JSVariable[] jsVariables = ((JSVarStatement)parent.getPsi()).getVariables();
            if (jsVariables.length == 1) {
                parent.getPsi().delete();
            } else {
                JSChangeUtil.removeRangeWithRemovalOfCommas(myNode, parent);
            }
            return;
        }
        throw new IncorrectOperationException("Cannot delete variable from parent : " + parent.getElementType());
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "processDeclarations"));
        }
        if (lastParent != null && lastParent.getParent() == this && JSPsiImplUtils.getExecutionScope(place) == JSPsiImplUtils.getExecutionScope((PsiElement)this)) {
            boolean skipLocal = true;
            if (ActionScriptResolveUtil.isSpecialCallResolveCaseEcmaScript(place, lastParent)) {
                skipLocal = false;
            }
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
            if (skipLocal) {
                return true;
            }
        }
        return processor.execute((PsiElement)this, state);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return this.getJSNamespace().getQualifiedName();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getJSNamespace().isExplicitlyDeclared();
    }

    @NotNull
    private JSNamespace calculateSymbolNamespace() {
        PsiElement declarationScope;
        JSNamespace fromJSDoc = JSDocumentationUtils.getNamespaceFromJSDoc((JSNamedElement)this);
        boolean namespaceExplicitlyDeclared = fromJSDoc.isExplicitlyDeclared();
        JSQualifiedName namespace = fromJSDoc.getQualifiedName();
        if (!namespaceExplicitlyDeclared) {
            namespace = JSPsiImplUtils.getNamespace((JSNamedElement)this);
            boolean bl = namespaceExplicitlyDeclared = namespace != null;
        }
        if (!namespaceExplicitlyDeclared) {
            JSQualifiedNamedElement parent = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this, JSQualifiedNamedElement.class);
            namespaceExplicitlyDeclared = parent == null || parent instanceof JSVariable && parent.isNamespaceExplicitlyDeclared();
        }
        boolean isLocal = ((declarationScope = this.getDeclarationScope()) instanceof JSFunction || declarationScope instanceof JSBlockStatement) && !namespaceExplicitlyDeclared;
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(namespace, JSSymbolUtil.getContext(this), namespaceExplicitlyDeclared, isLocal);
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "calculateSymbolNamespace"));
        }
        return jSNamespaceImpl;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.calcAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getAccessType"));
        }
        return accessType;
    }

    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "calcAccessType"));
        }
        return accessType;
    }

    @Nullable
    public JSFunctionExpression tryGetFunctionExpressionInitializer() {
        StubElement type;
        JSVariableStubBase stub = (JSVariableStubBase)this.getStub();
        JSExpression initializer = stub != null ? ((type = StubTreeUtil.findChildStubByType(stub, JSElementTypes.FUNCTION_EXPRESSIONS)) != null ? (JSExpression)type.getPsi() : null) : this.getInitializer();
        return initializer instanceof JSFunctionExpression && !((JSFunctionExpression)initializer).isAnonymousFunctionCall() ? (JSFunctionExpression)initializer : null;
    }

    @NotNull
    public JSContext getJSContext() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getJSContext"));
            }
            return jSContext;
        }
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, NAMESPACE_PROVIDER_KEY, NAMESPACE_PROVIDER, false, (Object)this);
        if (jSNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl", "getJSNamespace"));
        }
        return jSNamespace;
    }
}

