/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDocReference
extends JSTextReference {
    protected JSDocReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement, boolean methodRef) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "<init>"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "<init>"));
        }
        super(set, s, methodRef, rangeInElement);
    }

    @Override
    public void processLocalVariants(PsiFile psiFile, SinkResolveProcessor<?> processor, PsiElement context) {
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSDocComment.class);
        if (docComment != null) {
            List currentParameters = docComment.getGenericParameters();
            if (!currentParameters.isEmpty()) {
                JSDocReference.processGenericParameters(currentParameters, docComment, processor);
            } else {
                List parameters;
                JSDocComment definitionComment;
                JSQualifiedName namespace;
                PsiElement element2 = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                if (element2 instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element2).getNamespace()) != null && (definitionComment = JSGenericsIndex.findGenericParametersComment(namespace.getQualifiedName(), GlobalSearchScope.fileScope((PsiFile)psiFile))) != null && !(parameters = definitionComment.getGenericParameters()).isEmpty()) {
                    JSDocReference.processGenericParameters(parameters, definitionComment, processor);
                }
            }
        }
        if (this.myMethodRef && docComment != null) {
            PsiElement next = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
            if (next instanceof JSProperty) {
                JSResolveUtil.treeWalkUp(processor, this.mySet.getElement(), this.mySet.getElement(), next);
            }
        } else {
            this.doProcessLocalVariants(psiFile, processor, context, (Condition<PsiElement>)((Condition)element -> true));
        }
    }

    private static void processGenericParameters(@NotNull List<String> parameters, @NotNull JSDocComment comment, @NotNull SinkResolveProcessor<?> processor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "processGenericParameters"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "processGenericParameters"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference", "processGenericParameters"));
        }
        for (String parameter : parameters) {
            processor.execute((PsiElement)new JSImplicitElementImpl(parameter, (PsiElement)comment), ResolveState.initial());
        }
    }
}

