/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompletionPlaceFilter {
    public static final JSCompletionPlaceFilter ANY = new JSCompletionPlaceFilter(){};
    private static final JSCompletionPlaceFilter JS_TYPE_CONTEXT = new JSCompletionPlaceFilter(){

        @Override
        public boolean isPartialResult(@NotNull JSPsiElementBase element) {
            boolean lowerCasedSymbol;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$2", "isPartialResult"));
            }
            String name = element.getName();
            if (name == null) {
                return false;
            }
            boolean bl = lowerCasedSymbol = !name.isEmpty() && Character.isLowerCase(name.charAt(0));
            if (lowerCasedSymbol) {
                JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)element);
                if (element instanceof JSImplicitElement && !((JSImplicitElement)element).getType().providesNamespace() || possibleFunction != null && !possibleFunction.isConstructor() && JSPsiImplUtils.signatureIsExplicitlyDeclared((JSFunctionItem)possibleFunction)) {
                    return true;
                }
            }
            return false;
        }
    };
    private static final JSCompletionPlaceFilter AS_TYPE_CONTEXT = new JSCompletionPlaceFilter(){

        @Override
        public boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$3", "isAcceptable"));
            }
            if (AS_STRICT_TYPE_CONTEXT.isAcceptable(element)) {
                return true;
            }
            return !(element.getContext() instanceof JSClass) && (element instanceof JSFunction || element instanceof JSVariable);
        }
    };
    private static final JSCompletionPlaceFilter AS_STRICT_TYPE_CONTEXT = new JSCompletionPlaceFilter(){

        @Override
        public boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$4", "isAcceptable"));
            }
            return (element instanceof JSClass || element instanceof JSPackage) && !"Arguments".equals(element.getName());
        }

        @Override
        public boolean isPartialResult(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$4", "isPartialResult"));
            }
            return false;
        }
    };
    private static final JSCompletionPlaceFilter CLASS_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$5", "isAcceptable"));
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (clazz.isInterface()) {
                    return false;
                }
                JSAttributeList attributeList = clazz.getAttributeList();
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                    return false;
                }
            }
            return true;
        }
    };
    private static final JSCompletionPlaceFilter INTERFACE_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$6", "isAcceptable"));
            }
            return !(element instanceof JSClass) || ((JSClass)element).isInterface();
        }
    };
    private static final JSCompletionPlaceFilter AS_NEW_EXPRESSION_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$7", "isAcceptable"));
            }
            if (element instanceof JSClass && ((JSClass)element).isInterface() || element instanceof JSFunction && element.getParent() instanceof JSClass && !((JSFunction)element).isConstructor() && (!((JSFunction)element).isGetProperty() || !this.typeCanBePresentInNew(((JSFunction)element).getReturnType()))) {
                return false;
            }
            return !(element instanceof JSVariable) || this.typeCanBePresentInNew(((JSVariable)element).getType());
        }

        private boolean typeCanBePresentInNew(@Nullable JSType type) {
            if (type == null || type instanceof JSAnyType) {
                return false;
            }
            return type.getTypeText().equals("Class");
        }
    };
    private static final JSCompletionPlaceFilter JS_NEW_EXPRESSION_FILTER = new JSCompletionPlaceFilter(){

        @Override
        boolean isAcceptable(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$8", "isAcceptable"));
            }
            return JS_TYPE_CONTEXT.isAcceptable(element);
        }

        @Override
        boolean isPartialResult(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$8", "isPartialResult"));
            }
            return JS_TYPE_CONTEXT.isPartialResult(element);
        }

        @Override
        boolean isLoweredPriority(@NotNull JSPsiElementBase element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter$8", "isLoweredPriority"));
            }
            if (element instanceof JSClass) {
                return false;
            }
            JSFunctionItem item = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)element);
            return item == null;
        }
    };

    boolean isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter", "isAcceptable"));
        }
        return true;
    }

    boolean isPartialResult(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter", "isPartialResult"));
        }
        return false;
    }

    boolean isLoweredPriority(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter", "isLoweredPriority"));
        }
        return false;
    }

    public static JSCompletionPlaceFilter forPlace(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSCompletionPlaceFilter", "forPlace"));
        }
        boolean isActionScript = DialectDetector.isActionScript(place);
        if (place instanceof JSReferenceExpression && place.getParent() instanceof JSReferenceListMember) {
            PsiElement parent = place.getParent().getParent();
            if (JSElementTypes.EXTENDS_LISTS.contains(parent.getNode().getElementType())) {
                PsiElement element = parent.getParent();
                if (element instanceof JSClass) {
                    return ((JSClass)element).isInterface() ? INTERFACE_FILTER : CLASS_FILTER;
                }
            } else {
                return INTERFACE_FILTER;
            }
            return ANY;
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() == null) {
            if (ResolveProcessor.completeConstructorName(place)) {
                return isActionScript ? AS_NEW_EXPRESSION_FILTER : JS_NEW_EXPRESSION_FILTER;
            }
            boolean strictTypeContext = JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place);
            if (strictTypeContext) {
                return isActionScript ? AS_STRICT_TYPE_CONTEXT : JS_TYPE_CONTEXT;
            }
            if (isActionScript && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion(place)) {
                return AS_TYPE_CONTEXT;
            }
        } else if (place instanceof JSDocTagValue) {
            return isActionScript ? AS_TYPE_CONTEXT : JS_TYPE_CONTEXT;
        }
        return ANY;
    }
}

