/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSGenericParameterApplierImpl
extends JSGenericParameterImpl {
    public JSGenericParameterApplierImpl(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "<init>"));
        }
        super(type.getTypeText(), type.getSource(), ((JSGenericParameterImpl)type).getConstraintType());
    }

    private JSGenericParameterApplierImpl(@NotNull String name, @NotNull JSTypeSource source, @Nullable JSType constraintType, boolean env) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "<init>"));
        }
        super(name, source, constraintType, env);
    }

    @Override
    @NotNull
    protected JSGenericParameterImpl createNewParameter(JSType newConstraint) {
        JSGenericParameterApplierImpl jSGenericParameterApplierImpl = new JSGenericParameterApplierImpl(this.getName(), this.getSource(), newConstraint, this.isCallEnvironment());
        if (jSGenericParameterApplierImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "createNewParameter"));
        }
        return jSGenericParameterApplierImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (processingContext == null) {
            return true;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null && !super.isEquivalentToImpl(elementType, processingContext, true)) {
            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)elementType);
        }
        return true;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        boolean areEqual;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl", "isEquivalentToImpl"));
        }
        if (!allowResolve) {
            return false;
        }
        if (type instanceof JSGenericParameterImpl && (areEqual = super.isEquivalentToImpl(type, processingContext, true))) {
            return true;
        }
        if (processingContext == null) {
            return false;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null) {
            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)type);
        }
        return false;
    }
}

