/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericParameterApplierImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypesEvaluator {
    private static JSGenericTypesEvaluator INSTANCE = null;
    static final Key<MultiMap<String, JSType>> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");

    protected JSGenericTypesEvaluator() {
    }

    public static JSGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, null);
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter) {
        JSExpression qualifier;
        JSFunctionItem functionItem;
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression)) != null) {
            resolvedFunction = functionItem;
        }
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            type = this.evaluateGenericsFromQualifier(type, qualifier, (JSReferenceExpression)methodExpression);
        }
        if (methodExpression != null && methodExpression.getParent() instanceof JSCallExpression && resolvedFunction != null) {
            JSTypeSubstitutor substitutor = JSGenericTypesEvaluator.inferGenericTypesForCall(resolvedFunction, (JSCallExpression)methodExpression.getParent(), reporter);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor, reporter);
        }
        return type;
    }

    @NotNull
    private static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallExpression expression) {
        if (typeParametersOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParametersOwner", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
        }
        if (JSTypeUtils.hasTypeArguments(expression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
            }
            return jSTypeSubstitutor;
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSType type = JSGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            substitutor.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getDefaultTypeSubstitutor"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getTypeParameterDefaultType"));
        }
        TypeScriptType defaultType = parameter.getDefault();
        if (defaultType == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSAnyType.get((PsiElement)parameter, true) : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)defaultType);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getTypeParameterDefaultType"));
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        return !(type instanceof JSAnyType) && !(type instanceof JSSpecialNamedTypeImpl) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSVoidType);
    }

    @NotNull
    public static JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter) {
        if (resolvedFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedFunction", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "inferGenericTypesForCall"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "inferGenericTypesForCall"));
        }
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        result.putAll((Map)JSGenericTypesEvaluator.getDefaultTypeSubstitutor(resolvedFunction, callExpression));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSParameterItem[] parameters;
            JSFunctionItem functionItem = (JSFunctionItem)resolvedFunction;
            List parameterTypes = ContainerUtil.newSmartList();
            for (JSParameterItem parameter : parameters = functionItem.getParameters()) {
                parameterTypes.add(parameter.getType());
            }
            JSExpression[] arguments = callExpression.getArguments();
            MultiMap<String, JSType> genericArguments = JSGenericTypesEvaluator.inferGenericArgumentsFromCall(parameterTypes, arguments);
            result.putAll((Map)JSGenericTypesEvaluator.intersectGenerics(genericArguments, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "inferGenericTypesForCall"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor intersectGenerics(MultiMap<String, JSType> map, @Nullable GenericErrorReporter reporter) {
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        for (Map.Entry entry : map.entrySet()) {
            JSType type;
            Collection value = (Collection)entry.getValue();
            assert (value.size() > 0);
            if (value.size() == 1) {
                result.put(entry.getKey(), ContainerUtil.getFirstItem((Collection)value));
                continue;
            }
            Collection types = (Collection)entry.getValue();
            boolean hasImplicitly = false;
            for (JSType type2 : types) {
                if (type2 != null && type2.getSource().isExplicitlyDeclared()) continue;
                hasImplicitly = true;
                break;
            }
            if ((type = JSGenericTypesEvaluator.intersectTypes(types)) != null) {
                result.put(entry.getKey(), (Object)type);
                continue;
            }
            if (reporter != null && hasImplicitly) continue;
        }
        JSTypeSubstitutor jSTypeSubstitutor = result;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "intersectGenerics"));
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    public static JSType intersectTypes(@NotNull Collection<JSType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "intersectTypes"));
        }
        List typesForSearch = ContainerUtil.skipNulls((Collection)ContainerUtil.newArrayList(types));
        JSType firstNamed = null;
        for (JSType type : types) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isExplicitlyDeclared()) continue;
            boolean result = true;
            for (JSType jsType : typesForSearch) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, null)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static MultiMap<String, JSType> inferGenericArgumentsFromCall(List<JSType> parameterTypes, JSExpression[] arguments) {
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.length && i < parameterTypes.size(); ++i) {
            JSType paramType;
            JSExpression argument = arguments[i];
            JSType exprType = JSResolveUtil.getExpressionJSType(argument);
            if (exprType != null && exprType.getSource().isTypeScript()) {
                exprType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(argument, exprType);
            }
            if ((paramType = parameterTypes.get(i)) instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "inferGenericArgumentsFromCall"));
        }
        return multiMap;
    }

    public static MultiMap<String, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType) {
        if (exprType == null || paramType == null) {
            return MultiMap.EMPTY;
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        return genericArguments;
    }

    private static void matchGenericTypes(@NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "matchGenericTypes"));
        }
        if (paramType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramType", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "matchGenericTypes"));
        }
        paramType = JSTypeUtils.applyCompositeMapping(paramType, (Function<JSType, JSType>)((Function)type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            return new JSGenericParameterApplierImpl((JSType)type);
        }));
        paramType.isDirectlyAssignableType(exprType, processingContext);
    }

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, JSReferenceExpression methodExpression) {
        JSType qualifierType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                List<String> genericParameters = javaScriptGenericParameters;
                type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
                    if (type1 instanceof JSTypeImpl && genericParameters.contains(type1.getTypeText())) {
                        return new JSGenericParameterImpl(type1.getTypeText(), type1.getSource());
                    }
                    return type1;
                }));
            }
        }
        if (javaScriptGenericParameters != null && JSTypeUtils.hasGenericParameter(type) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
        }
        JSType jSType = type;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        if (genericType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericType", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        if (parentClassNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassNamespace", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        if (qName == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (parentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassName", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
            typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getTypeArgumentsMap(JSType genericType, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getTypeArgumentsMap"));
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            return JSTypeSubstitutor.EMPTY;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
        }
        return typeArguments;
    }

    public static interface GenericErrorReporter {
        public void error(String var1);
    }
}

