/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedNameResolver {
    @NotNull
    protected abstract JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement var1);

    @NotNull
    public abstract Collection<PsiElement> resolveQualifiedName(@NotNull String var1);

    protected boolean isStrictTypeContext() {
        return false;
    }

    @NotNull
    protected final Collection<PsiElement> expandElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
        }
        if (element instanceof TypeScriptImportStatement) {
            Collection<PsiElement> rawElements;
            Collection<PsiElement> elements;
            TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)element).getExternalModuleReference();
            TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)element).getInternalModuleReference();
            if (externalModuleReference != null) {
                Collection resolveResults = externalModuleReference.multiResolve();
                Collection<PsiElement> collection = this.processExternalModules(resolveResults);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
                }
                return collection;
            }
            if (internalModuleReference != null && !(elements = this.processWithResolveImportReferences(rawElements = JSResolveResult.toElements(internalModuleReference.multiResolve(false)), ContainerUtil.newHashSet())).isEmpty()) {
                Collection<PsiElement> collection = elements;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
                }
                return collection;
            }
        } else if (JSQualifiedNameResolver.isImport(element)) {
            Collection<PsiElement> resolvedImports = this.resolveImport(element, ContainerUtil.newHashSet());
            if (!resolvedImports.isEmpty()) {
                Collection<PsiElement> collection = resolvedImports;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
                }
                return collection;
            }
        } else if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            Collection<PsiElement> collection = this.processExternalModules(((TypeScriptGlobalModuleExportDeclaration)element).getModules());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
            }
            return collection;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "expandElement"));
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> processWithResolveImportReferences(@NotNull Collection<? extends PsiElement> elements, @Nullable Set<PsiElement> visited) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processWithResolveImportReferences"));
        }
        if (elements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processWithResolveImportReferences"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (JSQualifiedNameResolver.isImport(psiElement)) {
                Collection<PsiElement> resolved = this.resolveImport(psiElement, visited);
                result.addAll(resolved);
                continue;
            }
            result.add(psiElement);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processWithResolveImportReferences"));
        }
        return list;
    }

    private static boolean isImport(@Nullable PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    @NotNull
    private Collection<PsiElement> processExternalModules(@NotNull Collection<PsiElement> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processExternalModules"));
        }
        if (modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processExternalModules"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement element : modules) {
            TypeScriptExportAssignment exportAssignment;
            if (TypeScriptPsiUtil.isTopLevelContainer(element) && (exportAssignment = TypeScriptPsiUtil.findExportAssignment(element)) != null) {
                result.addAll(this.processAssignExpression((JSExportAssignment)exportAssignment));
                continue;
            }
            result.add(element);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processExternalModules"));
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> processAssignExpression(@NotNull JSExportAssignment assignment) {
        JSElement candidate;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processAssignExpression"));
        }
        String referenceName = assignment.getInitializerReference();
        if (referenceName != null) {
            JSQualifiedNameResolver resolver = this.createNestedResolver((PsiElement)assignment);
            Collection<PsiElement> collection = this.processWithResolveImportReferences(resolver.resolveQualifiedName(referenceName), ContainerUtil.newHashSet());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processAssignExpression"));
            }
            return collection;
        }
        JSElement stubElement = assignment.getStubSafeElement();
        Object object = candidate = stubElement == null ? assignment.getExpression() : stubElement;
        if (candidate instanceof JSClass) {
            List<JSElement> list = Collections.singletonList(candidate);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processAssignExpression"));
            }
            return list;
        }
        if (candidate instanceof JSReferenceExpression) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((JSReferenceExpression)candidate).multiResolve(false)), null);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processAssignExpression"));
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processAssignExpression"));
        }
        return list;
    }

    @NotNull
    protected final Collection<PsiElement> resolveImport(@NotNull PsiElement element, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
        }
        if (visited != null && !visited.add(element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
            }
            return list;
        }
        if (element instanceof TypeScriptImportStatement) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), visited);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifier) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((ES6ImportExportSpecifier)element).resolveOverAliases()), visited);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
            }
            return collection;
        }
        if (element instanceof ES6ImportedBinding) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(), visited);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(specifier.resolveOverAliases()), visited);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
                }
                return collection;
            }
        } else if (element instanceof JSExportAssignment) {
            Collection<PsiElement> collection = this.processAssignExpression((JSExportAssignment)element);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
            }
            return collection;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "resolveImport"));
        }
        return list;
    }

    @NotNull
    protected final Collection<? extends PsiElement> getLocalElements(@NotNull String name, @NotNull PsiElement scopeElement, @Nullable PsiElement parentScopeElement, boolean isQualifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "getLocalElements"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "getLocalElements"));
        }
        PsiElement module = ES6PsiUtil.getNonStrictExportScope(scopeElement);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        if (!(module instanceof JSElement)) {
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "getLocalElements"));
            }
            return linkedHashSet;
        }
        PsiElement realPlace = parentScopeElement == null ? scopeElement : parentScopeElement;
        TypeScriptModuleDeclarationsProcessor processor = ES6QualifiedNameResolver.createProcessor(name, this.isStrictTypeContext(), true);
        JSQualifiedNameResolver.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), module, realPlace, !isQualifier);
        List list = ContainerUtil.notNullize(processor.getResults());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "getLocalElements"));
        }
        return list;
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, final boolean includeExportSpecifiers) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processES6DeclarationsInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processES6DeclarationsInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processES6DeclarationsInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver", "processES6DeclarationsInScope"));
        }
        JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$1", "execute"));
                }
                if (!includeExportSpecifiers && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                return processor.execute(element, state);
            }
        };
        if (!JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor, state, lastParent, place)) {
            return false;
        }
        JSModuleElementsProcessor moduleElementsProcessor = processor instanceof JSModuleElementsResolveProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor){

            @Override
            @Nullable
            public String getName() {
                return processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
            }

            @Override
            public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$2", "process"));
                }
                if (evaluateContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$2", "process"));
                }
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$2", "execute"));
                }
                return processor.execute(element, state);
            }
        };
        return ES6PsiUtil.processExportAllDeclarations(scope, place, moduleElementsProcessor, null);
    }
}

