/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSRecursionGuard {
    @NotNull
    private final List<Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace>> processingItems = new SmartList();
    @NotNull
    private final Set<PsiElement> processingItemsSet = new THashSet();

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "isAlreadyProcessingItem"));
        }
        return this.isAlreadyProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "isAlreadyProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "isAlreadyProcessingItem"));
        }
        if (!this.processingItemsSet.contains(element)) {
            return false;
        }
        for (int i = this.processingItems.size() - 1; i >= 0; --i) {
            Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace> pair = this.processingItems.get(i);
            if (element.equals(pair.first) && place.equals(pair.second)) {
                return true;
            }
            if (((JSEvaluateContext.JSEvaluationPlace)((Object)pair.second)).ordinal() >= place.ordinal()) continue;
            return false;
        }
        return false;
    }

    public void addProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "addProcessingItem"));
        }
        this.addProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public void addProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "addProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "addProcessingItem"));
        }
        this.processingItemsSet.add(element);
        this.processingItems.add((Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace>)Pair.create((Object)element, (Object)((Object)place)));
    }

    public void removeProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "removeProcessingItem"));
        }
        this.removeProcessingItem(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public void removeProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "removeProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSRecursionGuard", "removeProcessingItem"));
        }
        Pair<PsiElement, JSEvaluateContext.JSEvaluationPlace> removed = this.processingItems.remove(this.processingItems.size() - 1);
        this.processingItemsSet.remove(element);
        assert (((PsiElement)removed.first).equals(element) && ((JSEvaluateContext.JSEvaluationPlace)((Object)removed.second)).equals((Object)place)) : "wrong element removed";
    }
}

