/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveResultSink
extends ResultSink {
    private static final Logger LOG = Logger.getInstance(ResolveResultSink.class);
    private final String myName;
    private List<JSResolveStatus> myResolveStatus;
    private final boolean myAcceptAllResults;
    private Set<PsiElement> myCandidateResults;

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "<init>"));
        }
        this(place, name, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "<init>"));
        }
        super(place);
        this.myName = name;
        this.myAcceptAllResults = acceptAllResults;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiElement getResult() {
        PsiElement completeResult = this.getCompleteResult();
        if (completeResult != null) {
            return completeResult;
        }
        return (PsiElement)ContainerUtil.getFirstItem((List)this.myResults);
    }

    @Nullable
    public PsiElement getCompleteResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
            return (PsiElement)this.myResults.get(i);
        }
        return null;
    }

    @Nullable
    public JSResolveResult getCandidateResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) continue;
            return new JSResolveResult((PsiElement)this.myResults.get(i), null, this.myResolveStatus.get((int)i).myResolveProblem);
        }
        return null;
    }

    @Override
    public List<PsiElement> getResults() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        boolean hasCandidateResult = false;
        boolean hasCompleteResult = false;
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) {
                hasCompleteResult = true;
                continue;
            }
            hasCandidateResult = true;
        }
        List results = this.myResults;
        if (hasCompleteResult && hasCandidateResult) {
            results = new SmartList();
            for (int i = 0; i < this.myResults.size(); ++i) {
                if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
                results.add(this.myResults.get(i));
            }
        }
        return results;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (element instanceof PsiNamedElement && !this.myName.equals(ResolveProcessor.getName(element))) {
            return false;
        }
        if (element instanceof ES6ImportExportSpecifier && !this.myName.equals(((ES6ImportExportSpecifier)element).getReferenceName())) {
            return false;
        }
        return super.accepts(element);
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        ReadWriteAccessDetector.Access expressionAccess;
        JSFunction fun;
        int previousResultsSize;
        List<PsiElement> results = super.getResults();
        int n = previousResultsSize = results != null ? results.size() : 0;
        if (this.myAcceptAllResults) {
            this.doAddResult(element, state, resolveProcessor);
            return true;
        }
        boolean stopProcessing = true;
        PsiElement elementForPropertyProcessing = element;
        if (element instanceof JSProperty) {
            elementForPropertyProcessing = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (this.place != null && elementForPropertyProcessing instanceof JSFunction && ((fun = (JSFunction)elementForPropertyProcessing).isGetProperty() || fun.isSetProperty()) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(this.place)) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement psiElement;
            if (previousResultsSize == 0) {
                stopProcessing = false;
            }
            if (previousResultsSize == 1 && (psiElement = results.get(0)) instanceof JSFunction) {
                JSFunction prevFun = (JSFunction)psiElement;
                if (prevFun.isGetProperty() && fun.isGetProperty()) {
                    return true;
                }
                if (prevFun.isSetProperty() && fun.isSetProperty()) {
                    return true;
                }
            }
            if (previousResultsSize == 2) {
                return true;
            }
        }
        this.doAddResult(element, state, resolveProcessor);
        return !stopProcessing;
    }

    private void doAddResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        super.addResult(element, state, resolveProcessor);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(this.getResolveStatus(element, state, resolveProcessor));
    }

    private JSResolveStatus getResolveStatus(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        JSImportStatement s = state != null ? (JSImportStatement)state.get(ActionScriptResolveUtil.IMPORT_KEY) : null;
        return this.checkQualifiedNameHasNecessaryImport(element, s, resolveProcessor);
    }

    @NotNull
    private JSResolveStatus checkQualifiedNameHasNecessaryImport(PsiElement element, JSImportStatement s, SinkResolveProcessor resolveProcessor) {
        PsiElement placeTopParent;
        String resolveProblem = null;
        if (s == null && this.isActionScript() && (element instanceof JSClass || element instanceof JSFunction || element instanceof JSVariable || element instanceof JSNamespaceDeclaration) && (placeTopParent = resolveProcessor.getPlaceTopParent()) instanceof JSReferenceExpression && !(placeTopParent.getParent() instanceof JSImportStatement)) {
            String qName;
            if (placeTopParent.getParent() instanceof JSNewExpression && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                element = element.getParent();
            }
            String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
            if (qName != null && qName.indexOf(46) != -1 && !JSResolveUtil.getPackageName(element).equals(JSResolveUtil.getPackageNameFromPlace(this.place)) && !UnusedImportsUtil.isSomeNodeThatShouldNotHaveImportsWhenQualified((JSReferenceExpression)placeTopParent, element)) {
                boolean noImportNoResolve;
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(this.myName, new ResolveResultSink(null, this.myName)){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1", "execute"));
                        }
                        if (element instanceof JSQualifiedNamedElement) {
                            if (!qName.equals(((JSQualifiedNamedElement)element).getQualifiedName())) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        return super.execute(element, state);
                    }
                };
                processor.putUserData(ResolveProcessor.ASKING_FOR_QUALIFIED_IMPORT, qName);
                PsiNamedElement importOwner = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)placeTopParent, (Class[])new Class[]{JSFunction.class, JSFile.class, JSPackageStatement.class, JSClass.class});
                if (importOwner != null) {
                    PsiElement elt = PsiTreeUtil.getChildOfAnyType((PsiElement)importOwner, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (elt == null) {
                        elt = importOwner.getFirstChild();
                    }
                    JSResolveUtil.treeWalkUp(processor, (PsiElement)importOwner, elt, this.place);
                }
                boolean bl = noImportNoResolve = processor.getResult() == null;
                if (noImportNoResolve) {
                    resolveProblem = "javascript.qualified.name.is.not.imported.message";
                } else {
                    ResolveResult[] resultsAsResolveResults = ((ResolveResultSink)processor.getResultSink()).getResultsAsResolveResults();
                    if (resultsAsResolveResults.length != 0) {
                        s = ((JSResolveResult)resultsAsResolveResults[0]).getActionScriptImport();
                    }
                }
            }
        }
        JSResolveStatus jSResolveStatus = new JSResolveStatus(s, true, resolveProblem);
        if (jSResolveStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "checkQualifiedNameHasNecessaryImport"));
        }
        return jSResolveStatus;
    }

    public ResolveResult[] getResultsAsResolveResults() {
        if (this.myResults == null || this.myResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return (ResolveResult[])this.getFilteredResults().stream().map(p -> (ResolveResult)p.first).toArray(ResolveResult[]::new);
    }

    @Nullable
    protected ResolveResult[] resolveImportExportSpecifiers(PsiElement element) {
        if (!(element instanceof ES6ImportExportSpecifier)) {
            return null;
        }
        ResolveResult[] results = ((ES6ImportExportSpecifier)element).multiResolve(false);
        return results.length == 0 ? null : results;
    }

    @NotNull
    public List<Pair<ResolveResult, Boolean>> getFilteredResults() {
        int i;
        List<PsiElement> processorResults = super.getResults();
        if (processorResults == null || processorResults.isEmpty()) {
            List<Pair<ResolveResult, Boolean>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "getFilteredResults"));
            }
            return list;
        }
        SmartList results = new SmartList();
        THashSet completeResults = new THashSet();
        for (i = 0; i < processorResults.size(); ++i) {
            PsiElement processorResult = processorResults.get(i);
            JSResolveStatus resolveStatus = this.myResolveStatus.get(i);
            if (!resolveStatus.myIsComplete || resolveStatus.myResolveProblem != null || !completeResults.add(Pair.create((Object)processorResult, (Object)resolveStatus))) continue;
            this.fillResults(processorResult, resolveStatus, (List<Pair<ResolveResult, Boolean>>)results);
        }
        if (results.isEmpty()) {
            for (i = 0; i < processorResults.size(); ++i) {
                JSResolveStatus resolveStatus = this.myResolveStatus.get(i);
                if (resolveStatus.myIsComplete && resolveStatus.myResolveProblem == null) continue;
                this.fillResults(processorResults.get(i), resolveStatus, (List<Pair<ResolveResult, Boolean>>)results);
            }
        }
        SmartList smartList = results;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "getFilteredResults"));
        }
        return smartList;
    }

    private void fillResults(@NotNull PsiElement element, @NotNull JSResolveStatus resolveStatus, @NotNull List<Pair<ResolveResult, Boolean>> outResults) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "fillResults"));
        }
        if (resolveStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveStatus", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "fillResults"));
        }
        if (outResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outResults", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "fillResults"));
        }
        Object[] resolvedImports = this.resolveImportExportSpecifiers(element);
        if (resolvedImports != null && resolvedImports.length > 0 && resolvedImports[0].isValidResult()) {
            JSElement importElement = element instanceof JSElement ? (JSElement)element : null;
            outResults.addAll(ContainerUtil.map((Object[])resolvedImports, r -> {
                if (resolveStatus == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveStatus", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "lambda$fillResults$2"));
                }
                JSResolveResult first = new JSResolveResult(r.getElement(), importElement, resolveStatus.myResolveProblem);
                return Pair.create((Object)first, (Object)true);
            }));
        } else {
            JSResolveResult first = new JSResolveResult(element, (JSElement)resolveStatus.myImportUsed, resolveStatus.myResolveProblem);
            outResults.add((Pair<ResolveResult, Boolean>)Pair.create((Object)first, (Object)resolveStatus.myIsComplete));
        }
    }

    @Override
    public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
        if (this.myCandidateResults == null) {
            this.myCandidateResults = new THashSet();
        }
        if (!this.myCandidateResults.add(element)) {
            return;
        }
        super.addResult(element, null, null);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(new JSResolveStatus(null, isCompleteMatch, problemKey));
    }

    static class JSResolveStatus {
        @Nullable
        final JSImportStatement myImportUsed;
        final boolean myIsComplete;
        @Nullable
        final String myResolveProblem;

        public JSResolveStatus(@Nullable JSImportStatement importUsed, boolean isComplete, @Nullable String resolveProblem) {
            this.myImportUsed = importUsed;
            this.myIsComplete = isComplete;
            this.myResolveProblem = resolveProblem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSResolveStatus status = (JSResolveStatus)o;
            return this.myIsComplete == status.myIsComplete && Objects.equals(this.myImportUsed, status.myImportUsed) && Objects.equals(this.myResolveProblem, status.myResolveProblem);
        }

        public int hashCode() {
            return Objects.hash(this.myImportUsed, this.myIsComplete, this.myResolveProblem);
        }
    }
}

