/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyContextUtil {
    @Nullable
    public static JSType getTypeWithAppliedContext(@NotNull JSType type, @NotNull JSEvaluateContext context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "getTypeWithAppliedContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "getTypeWithAppliedContext"));
        }
        if (context.isJSElementsToApplyEmpty()) {
            return type;
        }
        JSApplyContextElement pop = context.popJSElementToApply();
        JSType result = null;
        if (pop instanceof JSApplyCallElement) {
            if (type instanceof JSFunctionTypeImpl) {
                JSType innerType;
                JSCallExpression callExpression = ((JSApplyCallElement)pop).getCallExpression();
                boolean isNew = callExpression instanceof JSNewExpression;
                JSType jSType = innerType = isNew ? ((JSFunctionTypeImpl)type).getNewType() : ((JSFunctionTypeImpl)type).getReturnType();
                if (innerType != null) {
                    result = JSApplyContextUtil.getTypeWithAppliedContext(innerType, context);
                }
            }
        } else if (pop instanceof JSApplyPropertyElement) {
            if (type instanceof JSRecordType) {
                JSType propertyType;
                JSRecordType.PropertySignature signature = ((JSRecordType)type).findPropertySignature(((JSApplyPropertyElement)pop).getName());
                JSType jSType = propertyType = signature != null ? signature.getType() : null;
                if (propertyType != null) {
                    result = JSApplyContextUtil.getTypeWithAppliedContext(propertyType, context);
                }
            }
        } else if (pop instanceof JSApplyIndexedAccessElement) {
            Ref componentType = Ref.create();
            JSApplyContextUtil.applyContextAndProcessDestructuringArray((JSApplyIndexedAccessElement)pop, type, arg_0 -> ((Ref)componentType).set(arg_0));
            if (!componentType.isNull()) {
                result = JSApplyContextUtil.getTypeWithAppliedContext((JSType)componentType.get(), context);
            }
        }
        context.pushJSElementToApply(pop);
        return result;
    }

    public static void applyContextAndProcessDestructuringArray(@NotNull JSApplyIndexedAccessElement pop, @NotNull JSType _type, @NotNull java.util.function.Consumer<JSType> callback) {
        if (pop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pop", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyContextAndProcessDestructuringArray"));
        }
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyContextAndProcessDestructuringArray"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyContextAndProcessDestructuringArray"));
        }
        JSDestructuringArray destructuringArray = pop.getDestructuringArray();
        PsiElement arrayElement = pop.getArrayElement();
        JSDestructuringArrayRestElement restElement = destructuringArray.getRestElement();
        if (_type instanceof JSTupleTypeImpl) {
            JSType newType;
            JSTupleTypeImpl tupleType = (JSTupleTypeImpl)_type;
            int indexMatched = ArrayUtil.indexOf((Object[])destructuringArray.getElements(), (Object)arrayElement);
            JSType toProcess = tupleType.getTypeByIndex(indexMatched);
            if (toProcess != null) {
                callback.accept(toProcess);
                return;
            }
            if (restElement != null && arrayElement == restElement && (newType = tupleType.excludePrefix(destructuringArray.getElements().length)) != null) {
                callback.accept(newType);
                return;
            }
        }
        if (restElement != null && arrayElement == restElement) {
            callback.accept(_type);
            return;
        }
        JSType componentType = JSTypeUtils.getIndexableComponentType(_type);
        if (componentType != null) {
            JSType optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(componentType);
            if (optimizeTypeIfComposite instanceof JSCompositeTypeImpl) {
                optimizeTypeIfComposite = JSTypeUtils.copyWithExplicitlyDeclared(optimizeTypeIfComposite, false);
            }
            callback.accept(optimizeTypeIfComposite);
        }
    }

    public static void applyTypeToContext(@NotNull JSType type, @Nullable JSEvaluationResultContext evaluateContext, @NotNull BiConsumer<JSType, JSEvaluationResultContext> consumer) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyTypeToContext"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyTypeToContext"));
        }
        if (evaluateContext == null) {
            consumer.accept(type, null);
            return;
        }
        JSApplyCallElement newElement = null;
        JSType baseType = null;
        if (type instanceof JSApplyCallType) {
            baseType = ((JSApplyCallType)type).getBaseType();
            newElement = new JSApplyCallElement(null);
        }
        if (newElement == null) {
            consumer.accept(type, evaluateContext);
            return;
        }
        JSType _baseType = baseType;
        JSEvaluateContext.processWithJSElementToApply(newElement, evaluateContext, (Consumer<JSEvaluationResultContext>)((Consumer)newContext -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "lambda$applyTypeToContext$0"));
            }
            consumer.accept(_baseType, (JSEvaluationResultContext)newContext);
        }));
    }
}

