/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import org.jetbrains.annotations.NotNull;

public class JSBaseTypesIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"JS.base.types.index");
    private static final int VERSION = 1;

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return super.getVersion() + 1;
    }

    @NotNull
    public static String getTypeToSearchBaseTypes(@NotNull String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex", "getTypeToSearchBaseTypes"));
        }
        JSType jsType = JSTypeUtils.createType(typeString, JSTypeSource.EMPTY_TS);
        if (jsType == null) {
            String string = typeString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex", "getTypeToSearchBaseTypes"));
            }
            return string;
        }
        String result = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
        if (result != null && jsType instanceof JSNamedType && ((JSNamedType)jsType).isStaticOrInstance() == JSContext.STATIC) {
            result = JSNamedType.appendStaticSuffix(result);
        }
        String string = result != null ? result : typeString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex", "getTypeToSearchBaseTypes"));
        }
        return string;
    }
}

