/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitFunctionImpl
extends JSImplicitElementImpl
implements JSFunctionItem {
    @NotNull
    private final JSParameterItem[] myParameters;
    @Nullable
    private String myCachedFunctionTypeString;

    public JSImplicitFunctionImpl(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "<init>"));
        }
        super(builder.setType(JSImplicitElement.Type.Function));
        List<JSImplicitParameterStructure> parameters = builder.myParameters;
        this.myParameters = parameters == null ? JSParameterItem.EMPTY_ARRAY : (JSParameterItem[])parameters.stream().map(s -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "lambda$new$0"));
            }
            return new JSImplicitParameterImpl((JSImplicitParameterStructure)s, builder.getProvider());
        }).toArray(JSParameterItem[]::new);
    }

    public JSImplicitFunctionImpl(@NotNull JSImplicitElementStructureImpl structure, @NotNull List<JSImplicitParameterStructure> parameters, @Nullable PsiElement provider) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "<init>"));
        }
        super(structure, provider);
        this.myParameters = (JSParameterItem[])parameters.stream().map(s -> new JSImplicitParameterImpl((JSImplicitParameterStructure)s, provider)).toArray(JSParameterItem[]::new);
    }

    @Override
    protected JSImplicitFunctionStructureImpl createStructure(JSImplicitElementImpl.Builder builder) {
        return new JSImplicitFunctionStructureImpl(builder);
    }

    @Nullable
    public JSType getReturnType() {
        String typeString = this.myStructure.getTypeString();
        return typeString != null ? JSTypeUtils.createType(typeString, JSTypeSource.EXPLICITLY_DECLARED) : null;
    }

    @NotNull
    public JSParameterItem[] getParameters() {
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "getParameters"));
        }
        return this.myParameters;
    }

    @NotNull
    public JSParameterItem[] getParameterVariables() {
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "getParameterVariables"));
        }
        return this.myParameters;
    }

    public boolean isGetProperty() {
        return ((JSImplicitFunctionStructureImpl)this.myStructure).isGetProperty();
    }

    public boolean isSetProperty() {
        return ((JSImplicitFunctionStructureImpl)this.myStructure).isSetProperty();
    }

    public boolean isReferencesArguments() {
        return false;
    }

    @Override
    @NotNull
    public String getTypeString() {
        if (this.myCachedFunctionTypeString == null) {
            SmartList parameters = new SmartList();
            for (JSParameterItem parameter : this.getParameters()) {
                parameters.add(new JSParameterTypeDecoratorImpl(parameter.getType(), parameter.isOptional(), parameter.isRest(), true));
            }
            this.myCachedFunctionTypeString = new JSFunctionTypeImpl(JSTypeSource.EXPLICITLY_DECLARED, (List<JSParameterTypeDecorator>)parameters, this.getReturnType()).getTypeText(JSType.TypeTextFormat.SERIALIZED);
        }
        String string = this.myCachedFunctionTypeString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitFunctionImpl", "getTypeString"));
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean open) {
        return JSFunctionImpl.getFunctionIcon(this, 0);
    }

    public boolean isOverride() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

