/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    private boolean myIsOptimized;
    public static final int TYPES_NUMBER_LIMIT = 5;
    public static final Comparator<JSType> GENERIC_PARAMETER_LAST = (o1, o2) -> {
        if (o1 instanceof JSGenericParameterImpl) {
            return 1;
        }
        if (o2 instanceof JSGenericParameterImpl) {
            return -1;
        }
        return 0;
    };

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true);
    }

    @Contract(value="!null,_ -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve) {
        if (!(currentType instanceof JSCompositeTypeImpl)) {
            return currentType;
        }
        JSCompositeTypeImpl compositeType = (JSCompositeTypeImpl)currentType;
        if (compositeType.isOptimized()) {
            return compositeType;
        }
        List<JSType> originalNestedTypes = compositeType.getTypes();
        if (originalNestedTypes.isEmpty()) {
            return compositeType;
        }
        List preFilteredTypes = originalNestedTypes.stream().filter(el -> !JSCompositeTypeImpl.isEmptyType(el)).collect(Collectors.toList());
        if (preFilteredTypes.size() == 0) {
            return (JSType)ContainerUtil.getFirstItem(originalNestedTypes);
        }
        if (preFilteredTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(preFilteredTypes);
        }
        List<JSType> types = JSCompositeTypeImpl.flattenTypes(preFilteredTypes.stream().map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)).filter(el -> !JSCompositeTypeImpl.isEmptyType(el)), JSCompositeTypeImpl.class);
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        ArrayList filteredEqualsTypes = ContainerUtil.newArrayList(types);
        HashSet removedTypes = ContainerUtil.newHashSet();
        ProcessingContext context = new ProcessingContext();
        for (JSType fromCompare : types) {
            if (removedTypes.contains(fromCompare)) continue;
            Iterator iterator = filteredEqualsTypes.iterator();
            while (iterator.hasNext()) {
                JSType toCompare = (JSType)iterator.next();
                if (fromCompare == toCompare || !fromCompare.isEquivalentTo(toCompare, context, allowResolve)) continue;
                iterator.remove();
                removedTypes.add(toCompare);
            }
        }
        int filteredSize = filteredEqualsTypes.size();
        if (filteredSize == 1) {
            return (JSType)filteredEqualsTypes.get(0);
        }
        if (filteredSize == originalNestedTypes.size() && !allowResolve) {
            return currentType;
        }
        return new JSCompositeTypeImpl(compositeType.getSource(), allowResolve, filteredEqualsTypes);
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSCompositeTypeImpl.class);
        if (source == null) {
            source = type1 instanceof JSCompositeTypeImpl || !(type2 instanceof JSCompositeTypeImpl) ? type1.getSource() : type2.getSource();
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        return jSType;
    }

    public static JSType getCommonType(@NotNull List<JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allCommonTypes", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getCommonType"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSType currentType : allCommonTypes) {
            if (currentType instanceof JSAnyType) {
                return currentType;
            }
            if (JSCompositeTypeImpl.isEmptyType(currentType)) continue;
            boolean add = true;
            for (JSType resultedType : result) {
                if (!currentType.isEquivalentTo(resultedType, null, allowResolve)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(currentType);
        }
        if (result.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem((Collection)result, null);
        }
        return new JSCompositeTypeImpl(source, result);
    }

    @NotNull
    private static JSType getTypeOfType(JSType type, boolean allowResolve) {
        if (!allowResolve) {
            JSType jSType = type;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getTypeOfType"));
            }
            return jSType;
        }
        JSType jSType = type instanceof JSEvaluableType ? type.substitute() : type;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getTypeOfType"));
        }
        return jSType;
    }

    private JSCompositeTypeImpl(JSTypeSource source, boolean isOptimized, List<JSType> _types) {
        super(source, _types);
        this.myIsOptimized = false;
        this.myIsOptimized = isOptimized;
    }

    public JSCompositeTypeImpl(JSTypeSource source, JSType ... _types) {
        super(source, _types);
        this.myIsOptimized = false;
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, List<JSType> _types) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "<init>"));
        }
        super(source, _types);
        this.myIsOptimized = false;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("|" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "getTypeSeparator"));
        }
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof JSCompositeTypeImpl && this.isTypeScript()) {
            return JSTypeCastUtil.checkAssignableComposite(this, (JSCompositeTypeImpl)elementType, processingContext, true);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult common = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (common.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = common;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        for (JSType t : this.getTypes()) {
            if (!t.isDirectlyAssignableType(elementType, processingContext)) continue;
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = common;
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult;
    }

    private boolean isOptimized() {
        return this.myIsOptimized;
    }

    @Override
    @NotNull
    protected JSCompositeTypeImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformedTypes", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "createType"));
        }
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "createType"));
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(newSource, transformedTypes);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "createType"));
        }
        return jSCompositeTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeIfComposite(this);
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        PsiElement sourceElement = this.getSource().getSourceElement();
        ArrayList resultMembers = ContainerUtil.newArrayList();
        block0: for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            JSType commonType = null;
            JSRecordType.PropertySignature memberProperty = null;
            for (JSRecordType resolvedType : resolvedTypes) {
                boolean hasCurrent = false;
                for (JSRecordType.TypeMember typeMember : resolvedType.getTypeMembers()) {
                    if (member.isEquivalentTo(typeMember, true)) {
                        hasCurrent = true;
                        continue;
                    }
                    if (!(member instanceof JSRecordType.PropertySignature) || !(typeMember instanceof JSRecordType.PropertySignature)) continue;
                    memberProperty = (JSRecordType.PropertySignature)member;
                    JSRecordType.PropertySignature typeMemberProperty = (JSRecordType.PropertySignature)typeMember;
                    if (sourceElement == null || !StringUtil.equals((CharSequence)memberProperty.getMemberName(), (CharSequence)typeMemberProperty.getMemberName())) continue;
                    JSType type1 = memberProperty.getType();
                    JSType type2 = typeMemberProperty.getType();
                    if (type1 == null || type2 == null) continue;
                    commonType = JSTypeUtils.getCommonType(commonType == null ? type1 : commonType, type2, DialectDetector.dialectOfElement(sourceElement), true);
                    hasCurrent = true;
                }
                if (hasCurrent) continue;
                continue block0;
            }
            if (commonType != null) {
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(memberProperty.getMemberName(), commonType, memberProperty.isOptional()));
                continue;
            }
            resultMembers.add(member);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl", "substitute"));
        }
        return jSRecordTypeImpl;
    }
}

