/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericParameterImpl
extends JSTypeBaseImpl {
    public static final Key<Boolean> CALL_ENV_KEY = Key.create((String)"js.type.is.call.env");
    @NotNull
    private final String myName;
    @Nullable
    private final JSType myConstraintType;
    private final boolean isCallEnvironment;

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        this(name, source, null);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        this(name, source, constraintType, false);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType, boolean env) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        super(source);
        this.myName = name;
        this.myConstraintType = constraintType;
        this.isCallEnvironment = env;
    }

    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType;
    }

    public boolean isCallEnvironment() {
        return this.isCallEnvironment;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericParameter((JSType)this);
    }

    @NotNull
    protected JSGenericParameterImpl createNewParameter(JSType newConstraint) {
        JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.getName(), this.getSource(), newConstraint, this.isCallEnvironment);
        if (jSGenericParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "createNewParameter"));
        }
        return jSGenericParameterImpl;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = format == JSType.TypeTextFormat.SERIALIZED ? '%' + this.myName + '%' : this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean isJavaScriptContext;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.myConstraintType == null) {
            return true;
        }
        boolean currentCallEnv = this.isCallEnvironment;
        if (!currentCallEnv && processingContext != null) {
            currentCallEnv = Boolean.TRUE.equals(processingContext.get(CALL_ENV_KEY));
        }
        boolean bl = isJavaScriptContext = !this.isTypeScript() || !elementType.getSource().isTypeScript();
        if (this.myConstraintType != null && (currentCallEnv || isJavaScriptContext)) {
            return this.myConstraintType.isDirectlyAssignableType(elementType, processingContext);
        }
        return currentCallEnv || this.isEquivalentTo(elementType, processingContext);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "getName"));
        }
        return string;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "isEquivalentToImpl"));
        }
        if (!allowResolve) {
            return false;
        }
        if (type instanceof JSGenericParameterImpl) {
            if (!this.myName.equals(((JSGenericParameterImpl)type).myName)) {
                return false;
            }
            JSType secondConstraintType = ((JSGenericParameterImpl)type).myConstraintType;
            if (this.myConstraintType == secondConstraintType) {
                return true;
            }
            if (this.myConstraintType == null || secondConstraintType == null) {
                return false;
            }
            return this.myConstraintType.isEquivalentTo(secondConstraintType, processingContext);
        }
        return false;
    }

    public static JSGenericParameterImpl cloneWithEnvironment(JSGenericParameterImpl type, boolean isMethodCall) {
        return new JSGenericParameterImpl(type.myName, type.getSource(), type.myConstraintType, isMethodCall);
    }

    @Override
    protected final boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return false;
    }

    @Override
    @NotNull
    protected JSGenericParameterImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyWithNewSource"));
        }
        JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.getTypeText(), source, this.getConstraintType());
        if (jSGenericParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyWithNewSource"));
        }
        return jSGenericParameterImpl;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyTypeHierarchy"));
        }
        JSGenericParameterImpl jSGenericParameterImpl = this;
        if (jSGenericParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyTypeHierarchy"));
        }
        return jSGenericParameterImpl;
    }
}

