/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMixinTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    JSType myBaseType;
    @NotNull
    JSType myMixedType;

    public JSMixinTypeImpl(@NotNull JSType baseType, @NotNull JSType mixedType, @NotNull JSTypeSource source) {
        if (baseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "<init>"));
        }
        if (mixedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mixedType", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "<init>"));
        }
        super(source);
        this.myBaseType = baseType;
        this.myMixedType = mixedType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = this.myBaseType.getTypeText(format) + "+" + this.myMixedType.getTypeText(format);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = this.myBaseType.getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        return this.myBaseType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "isEquivalentToImpl"));
        }
        if (!(type instanceof JSMixinTypeImpl)) {
            return false;
        }
        JSMixinTypeImpl other = (JSMixinTypeImpl)type;
        return this.myBaseType.isEquivalentTo(other.myBaseType, processingContext, allowResolve) && this.myMixedType.isEquivalentTo(other.myMixedType, processingContext, allowResolve);
    }

    @NotNull
    public JSType getBaseType() {
        JSType jSType = this.myBaseType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "getBaseType"));
        }
        return jSType;
    }

    @NotNull
    public JSType getMixedType() {
        JSType jSType = this.myMixedType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "getMixedType"));
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "copyTypeHierarchy"));
        }
        JSMixinTypeImpl jSMixinTypeImpl = new JSMixinTypeImpl(JSTypeUtils.transformTypeHierarchySafe(this.getBaseType(), childTransform), JSTypeUtils.transformTypeHierarchySafe(this.getMixedType(), childTransform), this.getSource());
        if (jSMixinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "copyTypeHierarchy"));
        }
        return jSMixinTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "copyWithNewSource"));
        }
        JSMixinTypeImpl jSMixinTypeImpl = new JSMixinTypeImpl(this.getBaseType(), this.getMixedType(), source);
        if (jSMixinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSMixinTypeImpl", "copyWithNewSource"));
        }
        return jSMixinTypeImpl;
    }
}

