/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    private final List<JSRecordType.TypeMember> myTypeMembers;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        if (typeMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMembers", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "<init>"));
        }
        super(source);
        THashMap overloads = new THashMap();
        boolean hasOverloads = false;
        for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            List addedWithSameName = (List)overloads.get(name);
            if (addedWithSameName == null) {
                overloads.put(name, new SmartList((Object)((JSRecordType.PropertySignature)member)));
                continue;
            }
            hasOverloads = true;
            addedWithSameName.add((JSRecordType.PropertySignature)member);
        }
        if (hasOverloads) {
            List<JSRecordType.TypeMember> newTypeMembers = JSRecordTypeImpl.collectMergedMembers(source, typeMembers, (Map<String, List<JSRecordType.PropertySignature>>)overloads);
            this.myTypeMembers = Collections.unmodifiableList(newTypeMembers);
        } else {
            this.myTypeMembers = Collections.unmodifiableList(typeMembers);
        }
    }

    @NotNull
    private static List<JSRecordType.TypeMember> collectMergedMembers(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers, @NotNull Map<String, List<JSRecordType.PropertySignature>> overloads) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "collectMergedMembers"));
        }
        if (typeMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMembers", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "collectMergedMembers"));
        }
        if (overloads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloads", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "collectMergedMembers"));
        }
        ArrayList<JSRecordType.TypeMember> newTypeMembers = new ArrayList<JSRecordType.TypeMember>(typeMembers.size());
        block0: for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof JSRecordType.PropertySignature)) {
                newTypeMembers.add(member);
                continue;
            }
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            List<JSRecordType.PropertySignature> signaturesToMerge = overloads.get(name);
            if (signaturesToMerge == null) continue;
            if (signaturesToMerge.size() == 1) {
                newTypeMembers.add((JSRecordType.TypeMember)signaturesToMerge.get(0));
                continue;
            }
            ArrayList<JSRecordType.PropertySignature> toMerge = new ArrayList<JSRecordType.PropertySignature>(signaturesToMerge.size());
            boolean isAllMergedSignatureOptional = true;
            for (JSRecordType.PropertySignature signature : signaturesToMerge) {
                JSType type;
                if (!signature.isOptional()) {
                    isAllMergedSignatureOptional = false;
                }
                if (!((type = signature.getType()) instanceof JSFunctionTypeImpl)) {
                    newTypeMembers.add((JSRecordType.TypeMember)signature);
                    continue block0;
                }
                toMerge.add(signature);
            }
            newTypeMembers.add((JSRecordType.TypeMember)new JSCompositeFunctionPropertySignatureImpl(name, toMerge, isAllMergedSignatureOptional, source));
            overloads.remove(name);
        }
        ArrayList<JSRecordType.TypeMember> arrayList = newTypeMembers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "collectMergedMembers"));
        }
        return arrayList;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder("{");
        String prefix = "";
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript();
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            builder.append(prefix);
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSType propertyType;
                JSRecordType.PropertySignature property = (JSRecordType.PropertySignature)typeMember;
                String name = property.getMemberName();
                boolean hasDot = name.contains(".");
                builder.append(format == JSType.TypeTextFormat.SERIALIZED || !hasDot ? name : "[" + name + "]");
                if (property.isOptional()) {
                    builder.append('?');
                }
                if ((propertyType = property.getType()) != null) {
                    builder.append(": ");
                    boolean appendBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                    if (appendBrackets) {
                        builder.append("(");
                    }
                    builder.append(propertyType.getTypeText(format));
                    if (appendBrackets) {
                        builder.append(")");
                    }
                }
            } else if (typeMember instanceof JSRecordType.CallSignature) {
                JSRecordType.CallSignature call = (JSRecordType.CallSignature)typeMember;
                if (call.hasNew()) {
                    builder.append("new");
                }
                builder.append(((JSFunctionTypeImpl)call.getFunctionType()).getTypeText(format, false));
            } else if (typeMember instanceof JSRecordType.IndexSignature) {
                JSRecordType.IndexSignature indexSignature = (JSRecordType.IndexSignature)typeMember;
                if (format == JSType.TypeTextFormat.SERIALIZED) {
                    builder.append("#idx(");
                }
                builder.append("[");
                if (format != JSType.TypeTextFormat.SERIALIZED) {
                    builder.append("p: ");
                }
                builder.append(indexSignature.getMemberParameterType().getTypeText(format));
                builder.append("]");
                builder.append(": ");
                builder.append(indexSignature.getMemberType().getTypeText(format));
                if (format == JSType.TypeTextFormat.SERIALIZED) {
                    builder.append(")");
                }
            }
            prefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (elementType instanceof JSFunctionTypeImpl || elementType instanceof JSTypeBaseImpl && ((JSTypeBaseImpl)elementType).isTypeScript() && (elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                if (processingContext == null) {
                    processingContext = new ProcessingContext();
                }
                if (JSTypeCastUtil.startRecursiveTypesComparison(this, elementType, processingContext)) {
                    boolean result = this.isDirectlyAssignableType(substitute, processingContext);
                    JSTypeCastUtil.endRecursiveTypesComparison(this, elementType, processingContext);
                    return result;
                }
            }
            elementType = elementType.asRecordType();
        }
        if (elementType instanceof JSArrayType && elementType.getSource().isTypeScript()) {
            elementType = ((JSArrayType)elementType).asGenericType().asRecordType();
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType recordType, @Nullable ProcessingContext processingContext) {
        if (recordType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isDirectlyAssignableRecordType"));
        }
        THashMap recTypeProperties = new THashMap(recordType.getTypeMembers().size());
        List callSignatures = null;
        for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.CallSignature) {
                if (callSignatures == null) {
                    callSignatures = ContainerUtil.newSmartList();
                }
                callSignatures.add((JSRecordType.CallSignature)typeMember);
                continue;
            }
            if (!(typeMember instanceof JSRecordType.PropertySignature)) continue;
            JSRecordTypeImpl.addPropertyToMap((Map<String, List<JSRecordType.PropertySignature>>)recTypeProperties, (JSRecordType.PropertySignature)typeMember);
        }
        JSTypeSource source = recordType.getSource();
        JSUndefinedType undefinedType = null;
        JSRecordType functionRecord = null;
        for (JSRecordType.TypeMember typeMember : this.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.PropertySignature) {
                String propName = ((JSRecordType.PropertySignature)typeMember).getMemberName();
                List recordPropertyTypes = (List)recTypeProperties.get(propName);
                if (recordPropertyTypes == null && !((JSRecordType.PropertySignature)typeMember).isOptional()) {
                    if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                        if (undefinedType == null) {
                            undefinedType = new JSUndefinedType(source);
                        }
                        if (JSRecordTypeImpl.isUndefinedProperty((JSRecordType.PropertySignature)typeMember, undefinedType, processingContext)) continue;
                    }
                    if (callSignatures != null) {
                        if (functionRecord == null) {
                            functionRecord = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                        }
                        if (functionRecord != null && this.checkFunctionInterfaceProperties(processingContext, functionRecord, typeMember)) continue;
                    }
                    return false;
                }
                if (recordPropertyTypes == null || this.checkPropertySignaturesAssignable((JSRecordType.PropertySignature)typeMember, recordPropertyTypes, processingContext)) continue;
                return false;
            }
            if (!(typeMember instanceof JSRecordType.CallSignature)) continue;
            if (callSignatures == null) {
                return false;
            }
            if (this.checkCallSignaturesAssignable((JSRecordType.CallSignature)typeMember, callSignatures, processingContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPropertySignaturesAssignable(@NotNull JSRecordType.PropertySignature propertySignature, @NotNull List<JSRecordType.PropertySignature> recordPropertyTypes, @Nullable ProcessingContext processingContext) {
        JSRecordType.PropertySignature recordPropertyTypeMember;
        if (propertySignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertySignature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkPropertySignaturesAssignable"));
        }
        if (recordPropertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordPropertyTypes", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkPropertySignaturesAssignable"));
        }
        JSType propertyType = propertySignature.getType();
        boolean hasAssignable = false;
        Iterator<JSRecordType.PropertySignature> iterator = recordPropertyTypes.iterator();
        while (iterator.hasNext() && !(hasAssignable = this.checkPropertySignatureAssignable(propertySignature, propertyType, recordPropertyTypeMember = iterator.next(), processingContext))) {
        }
        return hasAssignable;
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        if (typeMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMember", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isUndefinedProperty"));
        }
        if (undefinedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undefinedType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isUndefinedProperty"));
        }
        JSType propertyType = typeMember.getType();
        return propertyType == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @Nullable JSType type, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkPropertySignatureAssignable"));
        }
        if (otherSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherSignature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkPropertySignatureAssignable"));
        }
        if (signature.isEquivalentTo((JSRecordType.TypeMember)otherSignature, false)) {
            return true;
        }
        JSType otherType = otherSignature.getType();
        return this.skipTypeChecking(type) || this.skipTypeChecking(otherType) || type.isDirectlyAssignableType(otherType, processingContext);
    }

    private boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature typeMember, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (typeMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMember", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkCallSignaturesAssignable"));
        }
        if (callSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSignatures", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkCallSignaturesAssignable"));
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            typeMember.isEquivalentTo((JSRecordType.TypeMember)callSignature, false);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (typeMember.hasNew() != callSignature.hasNew()) continue;
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)typeMember.getFunctionType();
            JSType returnType = functionType.getReturnType();
            JSFunctionTypeImpl otherFunctionType = (JSFunctionTypeImpl)callSignature.getFunctionType();
            JSType otherReturnType = otherFunctionType.getReturnType();
            if (!this.checkFunctionsArguments(processingContext, functionType, otherFunctionType) || returnType != null && !(returnType instanceof JSVoidType) && !returnType.isDirectlyAssignableType(otherReturnType, processingContext)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFunctionsArguments(@Nullable ProcessingContext processingContext, JSFunctionTypeImpl functionType, JSFunctionTypeImpl otherFunctionType) {
        return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !this.isTypeScript(), this.isTypeScript());
    }

    private boolean checkFunctionInterfaceProperties(@Nullable ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.TypeMember typeMember) {
        if (functionRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionRecord", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkFunctionInterfaceProperties"));
        }
        if (typeMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMember", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "checkFunctionInterfaceProperties"));
        }
        boolean exists = false;
        JSRecordType.PropertySignature propertyWithName = null;
        for (JSRecordType.TypeMember member : functionRecord.getTypeMembers()) {
            PsiElement memberSource = member.getSource();
            if (memberSource != null && memberSource.isEquivalentTo(typeMember.getSource()) || typeMember.isEquivalentTo(member, true)) {
                exists = true;
                break;
            }
            if (!(member instanceof JSRecordType.PropertySignature) || !((JSRecordType.PropertySignature)typeMember).getMemberName().equals(((JSRecordType.PropertySignature)member).getMemberName())) continue;
            propertyWithName = (JSRecordType.PropertySignature)member;
        }
        if (!exists && propertyWithName != null) {
            exists = new JSRecordTypeImpl(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)typeMember)).isDirectlyAssignableRecordType(new JSRecordTypeImpl(functionRecord.getSource(), ContainerUtil.createMaybeSingletonList(propertyWithName)), processingContext);
        }
        return exists;
    }

    private static void addPropertyToMap(Map<String, List<JSRecordType.PropertySignature>> recTypeProperties, JSRecordType.PropertySignature typeMember) {
        String name = typeMember.getMemberName();
        List<JSRecordType.PropertySignature> types = recTypeProperties.get(name);
        if (types != null) {
            types.add(typeMember);
        } else {
            recTypeProperties.put(name, ContainerUtil.newSmartList((Object)typeMember));
        }
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "isEquivalentToImpl"));
        }
        if (!(type instanceof JSRecordType)) {
            return false;
        }
        JSRecordType otherType = (JSRecordType)type;
        List otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            JSRecordType.TypeMember member;
            JSRecordType.TypeMember otherMember = (JSRecordType.TypeMember)otherMembers.get(i);
            if (otherMember.isEquivalentTo(member = members.get(i), allowResolve)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myTypeMembers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "getTypeMembers"));
        }
        return list;
    }

    public boolean hasProperty(String name) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "findPropertySignature"));
        }
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
            return (JSRecordType.PropertySignature)typeMember;
        }
        return null;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSRecordType((JSType)this);
    }

    private boolean skipTypeChecking(JSType type) {
        return type == null || this.isTypeScript() && !type.getSource().isExplicitlyDeclared();
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            JSType type;
            if (typeMember instanceof JSRecordType.PropertySignature) {
                type = ((JSRecordType.PropertySignature)typeMember).getType();
                if (type == null) continue;
                type.accept(visitor);
                continue;
            }
            if (typeMember instanceof JSRecordType.CallSignature) {
                type = ((JSRecordType.CallSignature)typeMember).getFunctionType();
                type.accept(visitor);
                continue;
            }
            if (!(typeMember instanceof JSRecordType.IndexSignature)) continue;
            JSType parameterType = ((JSRecordType.IndexSignature)typeMember).getMemberParameterType();
            parameterType.accept(visitor);
            JSType type2 = ((JSRecordType.IndexSignature)typeMember).getMemberType();
            type2.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyTypeHierarchy"));
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>();
        JSTypeSource appliedTypeSource = this.getSource();
        boolean shouldCleanSource = appliedTypeSource.getSourceElement() == null;
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform, shouldCleanSource));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyTypeHierarchy"));
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), newMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyTypeHierarchy"));
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    public static JSRecordType.CallSignature copyCallSignature(@NotNull JSRecordType.CallSignature callSignature, @NotNull Function<JSType, JSType> childTransform) {
        JSFunctionTypeImpl newType;
        if (callSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSignature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyCallSignature"));
        }
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyCallSignature"));
        }
        JSType oldType = callSignature.getFunctionType();
        if (oldType == (newType = (JSFunctionTypeImpl)JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
            JSRecordType.CallSignature callSignature2 = callSignature;
            if (callSignature2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyCallSignature"));
            }
            return callSignature2;
        }
        CallSignatureImpl callSignatureImpl = new CallSignatureImpl(callSignature.hasNew(), newType);
        if (callSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyCallSignature"));
        }
        return callSignatureImpl;
    }

    @NotNull
    public static JSRecordType.IndexSignature copyIndexSignature(@NotNull JSRecordType.IndexSignature indexSignature, @NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSource) {
        if (indexSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexSignature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyIndexSignature"));
        }
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyIndexSignature"));
        }
        JSType oldMemberParameterType = indexSignature.getMemberParameterType();
        JSType newMemberParameterType = JSTypeUtils.transformTypeHierarchySafe(oldMemberParameterType, childTransform);
        JSType oldType = indexSignature.getMemberType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        if (!shouldCleanSource && oldMemberParameterType == newMemberParameterType && oldType == newType) {
            JSRecordType.IndexSignature indexSignature2 = indexSignature;
            if (indexSignature2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyIndexSignature"));
            }
            return indexSignature2;
        }
        PsiElement sourceElement = shouldCleanSource ? null : indexSignature.getSource();
        IndexSignatureImpl indexSignatureImpl = new IndexSignatureImpl(newMemberParameterType, newType, sourceElement);
        if (indexSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyIndexSignature"));
        }
        return indexSignatureImpl;
    }

    @NotNull
    public static JSRecordType.PropertySignature copyPropertySignature(@NotNull JSRecordType.PropertySignature propertySignature, @NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSource) {
        if (propertySignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertySignature", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyPropertySignature"));
        }
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyPropertySignature"));
        }
        JSType oldType = propertySignature.getType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        if (!shouldCleanSource && oldType == type) {
            JSRecordType.PropertySignature propertySignature2 = propertySignature;
            if (propertySignature2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyPropertySignature"));
            }
            return propertySignature2;
        }
        PsiElement sourceElement = shouldCleanSource ? null : propertySignature.getSource();
        PropertySignatureImpl propertySignatureImpl = new PropertySignatureImpl(propertySignature.getMemberName(), type, propertySignature.isOptional(), sourceElement);
        if (propertySignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyPropertySignature"));
        }
        return propertySignatureImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        ArrayList newMembers = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : members) {
            JSCompositeFunctionPropertySignatureImpl propertySignature;
            if (member instanceof JSCompositeFunctionPropertySignatureImpl && ((propertySignature = (JSCompositeFunctionPropertySignatureImpl)member).getTypeSource() == JSTypeSource.EMPTY || source == JSTypeSource.EMPTY)) {
                newMembers.add(propertySignature.copyWithNewSource(source));
                continue;
            }
            newMembers.add(member);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, newMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "copyWithNewSource"));
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl", "asRecordType"));
        }
        return jSRecordTypeImpl;
    }

    public static class PropertySignatureImpl
    implements JSRecordType.PropertySignature {
        @NotNull
        private final String name;
        @Nullable
        private final JSType type;
        private final boolean optional;
        @Nullable
        private PsiElement mySource;

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement source) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "<init>"));
            }
            this(name, type, optional);
            this.mySource = source;
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "<init>"));
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
        }

        @NotNull
        public String getMemberName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "getMemberName"));
            }
            return string;
        }

        @Nullable
        public JSType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            return JSRecordType.arePropertySignaturesEqual((JSRecordType.PropertySignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }

        @NotNull
        public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "copyTypeHierarchy"));
            }
            JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.copyPropertySignature(this, childTransform, shouldCleanSourceElement);
            if (propertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "copyTypeHierarchy"));
            }
            return propertySignature;
        }
    }

    public static class IndexSignatureImpl
    implements JSRecordType.IndexSignature {
        @Nullable
        private final JSType parameterType;
        @Nullable
        private final JSType type;
        @Nullable
        private final PsiElement mySource;

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @Nullable PsiElement source) {
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
        }

        @NotNull
        public final JSType getMemberParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "getMemberParameterType"));
            }
            return object;
        }

        @NotNull
        public final JSType getMemberType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "getMemberType"));
            }
            return object;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            return JSRecordType.areIndexSignaturesEqual((JSRecordType.IndexSignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @Nullable
        public final PsiElement getSource() {
            return this.mySource;
        }

        @NotNull
        public final JSRecordType.IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "copyTypeHierarchy"));
            }
            JSRecordType.IndexSignature indexSignature = JSRecordTypeImpl.copyIndexSignature(this, childTransform, shouldCleanSourceElement);
            if (indexSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl", "copyTypeHierarchy"));
            }
            return indexSignature;
        }
    }

    public static class CallSignatureImpl
    implements JSRecordType.CallSignature {
        private final boolean hasNew;
        @NotNull
        private final JSFunctionTypeImpl functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionTypeImpl functionType) {
            if (functionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "<init>"));
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionTypeImpl getFunctionType() {
            JSFunctionTypeImpl jSFunctionTypeImpl = this.functionType;
            if (jSFunctionTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "getFunctionType"));
            }
            return jSFunctionTypeImpl;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof JSRecordType.CallSignature)) {
                return false;
            }
            return JSRecordType.areCallSignaturesEqual((JSRecordType.CallSignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @Nullable
        public PsiElement getSource() {
            return this.functionType.getSource().getSourceElement();
        }

        @NotNull
        public JSRecordType.CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "copyTypeHierarchy"));
            }
            JSRecordType.CallSignature callSignature = JSRecordTypeImpl.copyCallSignature(this, childTransform);
            if (callSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl", "copyTypeHierarchy"));
            }
            return callSignature;
        }
    }
}

