/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeOfJSTypeImpl
extends JSSimpleTypeBaseImpl
implements JSEvaluableType {
    private static final ParameterizedCachedValueProvider<Collection<? extends PsiElement>, Pair<PsiElement, String>> PROVIDER = new ParameterizedCachedValueProvider<Collection<? extends PsiElement>, Pair<PsiElement, String>>(){

        @NotNull
        public CachedValueProvider.Result<Collection<? extends PsiElement>> compute(@NotNull Pair<PsiElement, String> param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl$1", "compute"));
            }
            PsiElement sourceElement = (PsiElement)param.first;
            String refString = (String)param.second;
            JSTypeResolveResult result = TypeScriptTypeOfJSTypeImpl.resolveName(sourceElement, refString);
            if (result.hasElements()) {
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create(result.getElements(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl$1", "compute"));
                }
                return result2;
            }
            int lastDot = refString.lastIndexOf(46);
            if (lastDot > 0 && refString.length() > lastDot + 1) {
                String qualifier = refString.substring(0, lastDot);
                String elementName = refString.substring(lastDot + 1);
                JSTypeResolveResult qualifierResult = TypeScriptTypeOfJSTypeImpl.resolveName(sourceElement, qualifier);
                if (qualifierResult.hasElements()) {
                    Collection<? extends PsiElement> elements = qualifierResult.getElements();
                    ResolveResultSink sink = new ResolveResultSink(sourceElement, elementName, true);
                    QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(sourceElement).createQualifiedItemProcessor(sink, sourceElement);
                    processor.getAccessibilityProcessingHandler().setProcessStatics(true);
                    elements.forEach(el -> el.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), el, el));
                    ResolveResult[] results = sink.getResultsAsResolveResults();
                    Collection<PsiElement> resolvedElements = JSResolveResult.toElements(results);
                    if (!resolvedElements.isEmpty()) {
                        CachedValueProvider.Result result3 = CachedValueProvider.Result.create(resolvedElements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                        if (result3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl$1", "compute"));
                        }
                        return result3;
                    }
                }
            }
            CachedValueProvider.Result result4 = CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl$1", "compute"));
            }
            return result4;
        }
    };
    public static final Key<ParameterizedCachedValue<Collection<? extends PsiElement>, Pair<PsiElement, String>>> TYPEOF_RESOLVE_KEY = Key.create((String)"typeof.resolve.store");
    @NotNull
    private final String myText;

    public TypeScriptTypeOfJSTypeImpl(@NotNull String typeOfText, @NotNull JSTypeSource source) {
        if (typeOfText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeOfText", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "<init>"));
        }
        super(source);
        this.myText = typeOfText;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "#tstypeof(" + this.myText + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = "typeof " + this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        return this.substitute().isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "copyWithNewSource"));
        }
        TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = new TypeScriptTypeOfJSTypeImpl(this.myText, source);
        if (typeScriptTypeOfJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "copyWithNewSource"));
        }
        return typeScriptTypeOfJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        JSTypeSource typeSource;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "isEquivalentToImpl"));
        }
        JSTypeSource source = type.getSource();
        PsiElement element = source.getSourceElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        if (type instanceof TypeScriptTypeOfJSTypeImpl && ((TypeScriptTypeOfJSTypeImpl)type).myText.equals(this.myText) && (typeSource = type.getSource()).getSourceElement() == element) {
            return true;
        }
        if (!allowResolve) {
            return false;
        }
        return this.substitute().isEquivalentTo(type, context, true);
    }

    @Override
    @NotNull
    public JSType substitute() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (sourceElement == null || !sourceElement.isValid()) {
            JSAnyType jSAnyType = JSAnyType.get(sourceElement, false);
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeOfJSTypeImpl.getTypeOfResultElements(sourceElement, this.myText);
        if (elements.size() > 0) {
            JSType jSType = this.convertResolvedElementsToType(elements);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get(sourceElement, false);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
        }
        return jSAnyType;
    }

    @NotNull
    public static Collection<? extends PsiElement> getTypeOfResultElements(@NotNull PsiElement sourceElement, @NotNull String refString) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeOfResultElements"));
        }
        if (refString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refString", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeOfResultElements"));
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)sourceElement.getProject()).getParameterizedCachedValue((UserDataHolder)sourceElement, TYPEOF_RESOLVE_KEY, PROVIDER, false, (Object)Pair.create((Object)sourceElement, (Object)refString));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeOfResultElements"));
        }
        return collection;
    }

    @NotNull
    private static JSTypeResolveResult resolveName(@NotNull PsiElement sourceElement, @NotNull String text) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "resolveName"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "resolveName"));
        }
        JSTypeResolveResult jSTypeResolveResult = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveName(text, sourceElement);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private JSType convertResolvedElementsToType(Collection<? extends PsiElement> elements) {
        List<JSType> results = elements.stream().filter(el -> el != null && !(el instanceof TypeScriptInterface) && !(el instanceof TypeScriptTypeAlias) && (!(el instanceof TypeScriptModule) || ((TypeScriptModule)el).isInstantiated())).map(el -> {
            if (el instanceof TypeScriptModule) {
                return TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)el);
            }
            Ref ref = Ref.create();
            JSTypeEvaluator.processWithEvaluationGuard(el, JSEvaluateContext.JSEvaluationPlace.TS_TYPEOF_TYPE, toProcess -> ref.set((Object)JSTypeEvaluator.getElementType(toProcess)));
            JSTypeEvaluationResult type = (JSTypeEvaluationResult)ref.get();
            return type != null ? type.getType() : null;
        }).filter(el -> el != null).collect(Collectors.toList());
        JSIntersectionTypeImpl jSIntersectionTypeImpl = results.size() == 1 ? (JSType)results.get(0) : new JSIntersectionTypeImpl(this.getSource(), results);
        if (jSIntersectionTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "convertResolvedElementsToType"));
        }
        return jSIntersectionTypeImpl;
    }
}

