/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class TypeScriptMethodDescriptor
extends JSMethodDescriptor {
    public TypeScriptMethodDescriptor(JSFunction method, boolean forceConstructor) {
        super(method, forceConstructor);
    }

    @Override
    public String getVisibility() {
        if (this.isClassMember()) {
            return this.getVisibilityImpl(JSAttributeList.AccessType.PUBLIC);
        }
        JSAttributeList list = this.myMethod.getAttributeList();
        if (list != null && list.getAccessType() != null) {
            return list.getAccessType().name();
        }
        return super.getVisibility();
    }

    @Override
    protected String getPrefixFunction() {
        return this.isClassMember() ? "" : super.getPrefixFunction();
    }

    @Override
    public List<JSAttributeList.AccessType> getPossibleVisibility() {
        if (!this.isClassMember()) {
            return super.getPossibleVisibility();
        }
        if (this.myMethod.isConstructor()) {
            return ContainerUtil.newArrayList((Object[])new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC});
        }
        return JSAttributeList.TYPESCRIPT_ACCESS_TYPE_LIST;
    }

    @Override
    public String getReturnType() {
        if (this.myMethod.getReturnTypeElement() == null) {
            return "";
        }
        JSType returnType = this.myMethod.getReturnType();
        return StringUtil.notNullize(returnType != null ? returnType.getTypeText(JSType.TypeTextFormat.CODE) : null);
    }

    @Override
    boolean canHaveType() {
        return true;
    }

    @Override
    boolean canHaveInitializers() {
        return true;
    }

    @Override
    public boolean resolveTypes() {
        return false;
    }

    @Override
    boolean canHaveOptional() {
        return false;
    }

    @Override
    public boolean canChangeVisibility() {
        return this.canChangeVisibilityImpl();
    }

    @Override
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (this.isConstructor()) {
            return MethodDescriptor.ReadWriteOption.None;
        }
        if (this.myMethod.isSetProperty()) {
            return MethodDescriptor.ReadWriteOption.Read;
        }
        return MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    private boolean isClassMember() {
        return JSUtils.getMemberContainingClass((PsiElement)this.myMethod) != null;
    }
}

