/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.InheritanceBuilder;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassInheritanceNode {
    public static final String INHERITS = "inherits";
    @NotNull
    private final JSFunction myFunction;
    private PsiElement mySearchTarget;
    private UsageInfo[] myInfos;
    private final List<JSReferenceExpression> myUsedAsError;
    private JSItemToClassDataProcessor myDataProcessor;
    @Nullable
    private ClassInheritanceNode myParent;
    private final List<ClassInheritanceNode> myDescendants;
    private MultiMap<PsiElement, String> myConflicts;
    private final List<PsiElement> myConflictShowOrder;
    private final Map<String, Integer> myConflictDescriptions;

    public ClassInheritanceNode(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "<init>"));
        }
        this.myConflictShowOrder = new ArrayList<PsiElement>();
        this.myConflictDescriptions = new HashMap<String, Integer>();
        this.myFunction = function;
        this.myUsedAsError = new ArrayList<JSReferenceExpression>();
        this.myDescendants = new ArrayList<ClassInheritanceNode>();
    }

    public void process(@Nullable JSFunction causeChild, boolean goUp, @NotNull Set<JSFunction> controlSet) {
        if (controlSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlSet", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "process"));
        }
        if (controlSet.contains(this.myFunction)) {
            return;
        }
        controlSet.add(this.myFunction);
        this.processNonRecursively();
        InheritanceBuilder inheritanceBuilder = this.myDataProcessor.getInheritanceBuilder();
        if (goUp && inheritanceBuilder.getAncestor() != null) {
            this.myParent = new ClassInheritanceNode(inheritanceBuilder.getAncestor());
            this.myParent.process(this.myFunction, true, controlSet);
        }
        Set<JSFunction> descendants = inheritanceBuilder.getDescendants();
        for (JSFunction descendant : descendants) {
            if (descendant.equals(causeChild)) continue;
            ClassInheritanceNode node = new ClassInheritanceNode(descendant);
            this.myDescendants.add(node);
            node.process(null, false, controlSet);
        }
    }

    private void processNonRecursively() {
        this.myConflicts = new MultiMap();
        this.findUsages();
        this.parseUsages();
    }

    public JSItemToClassDataProcessor getDataProcessor() {
        return this.myDataProcessor;
    }

    public MultiMap<PsiElement, String> getConflicts() {
        return this.myConflicts;
    }

    public List<PsiElement> getConflictShowOrder() {
        return this.myConflictShowOrder;
    }

    @NotNull
    public JSFunction getFunction() {
        JSFunction jSFunction = this.myFunction;
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "getFunction"));
        }
        return jSFunction;
    }

    @Nullable
    public ClassInheritanceNode getParent() {
        return this.myParent;
    }

    public List<ClassInheritanceNode> getDescendants() {
        return this.myDescendants;
    }

    public UsageInfo[] getInfos() {
        return this.myInfos;
    }

    private void parseUsages() {
        List<UsageInfo> usagesList = ClassInheritanceNode.sortUsages(this.myInfos);
        String name = this.mySearchTarget instanceof JSNamedElement ? ((JSNamedElement)this.mySearchTarget).getName() : this.myFunction.getName();
        this.myDataProcessor = new JSItemToClassDataProcessor(this.myFunction, null, name);
        List<Pair<String, UsageInfo>> conflictUsages = this.myDataProcessor.prepareAndFindConflicts(usagesList, this.myUsedAsError);
        Collections.sort(conflictUsages, (o1, o2) -> {
            int namesResult = ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            if (namesResult != 0) {
                return namesResult;
            }
            if (((UsageInfo)o1.getSecond()).getElement() == null || ((UsageInfo)o2.getSecond()).getElement() == null) {
                return 0;
            }
            return Integer.compare(((UsageInfo)o1.getSecond()).getElement().getTextRange().getStartOffset(), ((UsageInfo)o2.getSecond()).getElement().getTextRange().getStartOffset());
        });
        for (Pair<String, UsageInfo> pair : conflictUsages) {
            PsiReference topReference;
            UsageInfo usage = (UsageInfo)pair.getSecond();
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiElement target = element;
            if (element instanceof JSReferenceExpression && (topReference = ClassInheritanceNode.getTopReference((PsiReference)element)) instanceof PsiElement) {
                target = (PsiElement)topReference;
            }
            this.addConflict(element, ClassInheritanceNode.getDuplicateElementDescription(target, (String)pair.getFirst()));
        }
        Map<JSExpression, JSNamedElementBase> allAncestors = this.myDataProcessor.getInheritanceBuilder().getAllAncestors();
        if (allAncestors.size() > 1) {
            ArrayList<JSExpression> list = new ArrayList<JSExpression>(allAncestors.keySet());
            Collections.sort(list, (o1, o2) -> {
                JSNamedElementBase v1 = (JSNamedElementBase)allAncestors.get(o1);
                JSNamedElementBase v2 = (JSNamedElementBase)allAncestors.get(o2);
                int result = Comparing.compare((Comparable)((Object)v1.getName()), (Comparable)((Object)v2.getName()));
                if (result != 0) {
                    return result;
                }
                return Integer.compare(o1.getTextRange().getStartOffset(), o2.getTextRange().getStartOffset());
            });
            for (JSExpression key : list) {
                this.addConflict((PsiElement)key, this.myDataProcessor.getConstructorFunction().getFunctionName() + " has conflicting ancestor declarations: from " + allAncestors.get(key).getName() + " in " + key.getText());
            }
        }
    }

    private void addConflict(@NotNull PsiElement key, @NotNull String description) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "addConflict"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "addConflict"));
        }
        this.myConflictShowOrder.add(key);
        if (this.myConflictDescriptions.containsKey(description)) {
            Integer integer = this.myConflictDescriptions.get(description);
            description = description + " (" + integer + ")";
            this.myConflictDescriptions.put(description, integer + 1);
        } else {
            this.myConflictDescriptions.put(description, 1);
        }
        this.myConflicts.putValue((Object)key, (Object)description);
    }

    private boolean nonRecursiveHasInheritanceConflicts() {
        return this.myDataProcessor.getInheritanceBuilder().getAllAncestors().size() > 1;
    }

    public boolean hasInheritanceConflicts() {
        ClassInheritanceNode parent;
        if (this.nonRecursiveHasInheritanceConflicts()) {
            return true;
        }
        for (parent = this; parent != null && parent.getParent() != null; parent = parent.getParent()) {
        }
        ArrayDeque<ClassInheritanceNode> queue = new ArrayDeque<ClassInheritanceNode>();
        queue.add(parent);
        while (!queue.isEmpty()) {
            List<ClassInheritanceNode> descendants = ((ClassInheritanceNode)queue.removeFirst()).getDescendants();
            for (ClassInheritanceNode descendant : descendants) {
                if (descendant.nonRecursiveHasInheritanceConflicts()) {
                    return true;
                }
                queue.add(descendant);
            }
        }
        return false;
    }

    private static String getDuplicateElementDescription(PsiElement target, String name) {
        JSCallExpression call;
        String targetText = target.getText();
        if (target instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)target).getReferenceName()) && target.getParent() instanceof JSArgumentList && target.getParent().getParent() instanceof JSCallExpression && ClassInheritanceNode.checkForObjectMethod((call = (JSCallExpression)target.getParent().getParent()).getMethodExpression(), ContainerUtil.set((Object[])new String[]{"defineProperties", "defineProperty", "create"}))) {
            return targetText + "." + name + " inside " + call.getMethodExpression().getText() + " has duplicate definition";
        }
        return targetText + " has duplicate definition";
    }

    public void findUsages() {
        this.mySearchTarget = this.myFunction;
        boolean wasReference = false;
        if (this.myFunction instanceof JSFunctionExpression) {
            if (this.myFunction.getParent() instanceof JSVariable) {
                this.mySearchTarget = this.myFunction.getParent();
            } else if (this.myFunction.getParent() instanceof JSAssignmentExpression && ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression() != null) {
                this.mySearchTarget = ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression().getExpression();
                this.mySearchTarget = this.mySearchTarget instanceof JSReferenceExpression ? ((JSReferenceExpression)this.mySearchTarget).resolve() : this.mySearchTarget;
                wasReference = this.mySearchTarget != null;
                this.mySearchTarget = this.mySearchTarget == null ? this.myFunction : this.mySearchTarget;
            }
        }
        List references = JSDefaultRenameProcessor.getReferences(this.mySearchTarget, false, JSDefaultRenameProcessor.ReferencesType.JS);
        if (wasReference) {
            references = ContainerUtil.filter(references, reference -> this.myFunction.getContainingFile().equals(reference.getElement().getContainingFile()));
        }
        references = ContainerUtil.filter(references, reference -> ClassInheritanceNode.isAssignmentStatement(reference) || ClassInheritanceNode.checkForProcessedObjectMethods(reference) || ClassInheritanceNode.checkForOtherUtilityMethods(reference) || this.checkForThrows((PsiReference)reference));
        List usages = ContainerUtil.map((Collection)references, reference -> new UsageInfo(reference));
        this.myInfos = usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @NotNull
    private static List<UsageInfo> sortUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "sortUsages"));
        }
        ArrayList<UsageInfo> usagesList = new ArrayList<UsageInfo>(Arrays.asList(usages));
        Collections.sort(usagesList, (o1, o2) -> {
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
                PsiReference ref1 = ClassInheritanceNode.getTopReference((PsiReference)e1);
                PsiReference ref2 = ClassInheritanceNode.getTopReference((PsiReference)e2);
                if (ref1 instanceof PsiElement && ref2 instanceof PsiElement) {
                    return ((PsiElement)ref1).getText().compareTo(((PsiElement)ref2).getText());
                }
            }
            if (e1 != null && e2 != null) {
                return e1.getText().compareTo(e2.getText());
            }
            return 0;
        });
        ArrayList<UsageInfo> arrayList = usagesList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "sortUsages"));
        }
        return arrayList;
    }

    private static boolean checkForOtherUtilityMethods(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "checkForOtherUtilityMethods"));
        }
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement parent = ((JSReferenceExpression)topReference).getParent();
        return parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ClassInheritanceNode.isNodeJSInheritsCall((JSCallExpression)parent.getParent());
    }

    static boolean isNodeJSInheritsCall(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "isNodeJSInheritsCall"));
        }
        NodeJsCoreLibraryManager coreLibraryManager = NodeJsCoreLibraryManager.getInstance(call.getProject());
        JSExpression methodExpression = call.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            PsiElement resolve;
            JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
            if (INHERITS.equals(((JSReferenceExpression)methodExpression).getReferenceName()) && qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null && ((resolve = JSChangeUtil.deepResolve((JSReferenceExpression)qualifier)) != null && coreLibraryManager.isCoreModuleLibraryFile(resolve.getContainingFile().getVirtualFile()) || "util".equals(((JSReferenceExpression)qualifier).getReferenceName()))) {
                return true;
            }
        }
        return false;
    }

    private boolean checkForThrows(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "checkForThrows"));
        }
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement parent = ((JSReferenceExpression)topReference).getParent();
        if (parent instanceof JSNewExpression && ((JSNewExpression)parent).getMethodExpression().equals(topReference) && parent.getParent() instanceof JSThrowStatement) {
            this.myUsedAsError.add((JSReferenceExpression)reference);
        }
        return false;
    }

    static PsiReference getTopReference(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "getTopReference"));
        }
        if (!(reference instanceof PsiElement)) {
            return null;
        }
        PsiElement current = (PsiElement)reference;
        while (current instanceof JSReferenceExpression) {
            if (!(current.getParent() instanceof PsiReference)) {
                return (PsiReference)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private static boolean checkForProcessedObjectMethods(@NotNull PsiReference reference) {
        JSCallExpression call;
        JSExpression methodExpression;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "checkForProcessedObjectMethods"));
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof PsiElement)) {
            return false;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        return parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ClassInheritanceNode.checkForObjectMethod(methodExpression = (call = (JSCallExpression)parent.getParent()).getMethodExpression(), JSConvertToClassProcessor.OBJECT_METHODS);
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull Set<String> names) {
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "checkForObjectMethod"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "checkForObjectMethod"));
        }
        return methodExpression instanceof JSReferenceExpression && names.contains(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && "Object".equals(((JSReferenceExpression)methodExpression).getQualifier().getText());
    }

    @Nullable
    static JSAssignmentExpression findParentAssignment(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "findParentAssignment"));
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof PsiElement)) {
            return null;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        if (parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression) {
            return (JSAssignmentExpression)parent.getParent();
        }
        return null;
    }

    private static boolean isAssignmentStatement(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode", "isAssignmentStatement"));
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof PsiElement)) {
            return false;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        return parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression || parent instanceof JSNewExpression && parent.getParent() instanceof JSAssignmentExpression || parent instanceof JSAssignmentExpression;
    }
}

