/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSToClassConversionConstructorFunction {
    @NotNull
    private final JSFunction myFunction;
    @NotNull
    private final String myFunctionName;
    private final Map<String, JSAssignmentExpression> myInnerProperties;
    private final Map<JSReferenceExpression, JSAssignmentExpression> myParameterAssignments;

    public JSToClassConversionConstructorFunction(@NotNull JSFunction function, @Nullable String name) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction", "<init>"));
        }
        this.myInnerProperties = new HashMap<String, JSAssignmentExpression>();
        this.myFunction = function;
        this.myFunctionName = name == null ? StringUtil.notNullize((String)function.getName()) : name;
        this.myParameterAssignments = new HashMap<JSReferenceExpression, JSAssignmentExpression>();
        JSBlockStatement constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (constructorBlock != null) {
            Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)constructorBlock, JSAssignmentExpression.class);
            for (JSAssignmentExpression expression : assignments) {
                PsiElement element;
                if (expression.getDefinitionExpression() == null || !this.isThisMember((PsiElement)expression.getDefinitionExpression())) continue;
                this.myInnerProperties.put(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)expression.getDefinitionExpression(), false), expression);
                JSExpression initializer = expression.getDefinitionExpression().getInitializer();
                if (!(initializer instanceof JSReferenceExpression) || (element = ((JSReferenceExpression)initializer).resolve()) == null || !element.isValid() || !(element instanceof JSParameter) || !(element.getParent() instanceof JSParameterList) || !this.myFunction.equals(element.getParent().getParent())) continue;
                this.myParameterAssignments.put((JSReferenceExpression)initializer, expression);
            }
        }
    }

    public Collection<JSAssignmentExpression> getOnlyPropertyDefinitions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> !(assignment.getDefinitionExpression().getInitializer() instanceof JSFunction));
    }

    public Collection<JSAssignmentExpression> getOnlyFunctions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> assignment.getDefinitionExpression().getInitializer() instanceof JSFunction);
    }

    @Nullable
    public JSAssignmentExpression getInnerProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction", "getInnerProperty"));
        }
        return this.myInnerProperties.get(key);
    }

    public boolean isEmpty() {
        return this.myInnerProperties.isEmpty();
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction", "getFunctionName"));
        }
        return string;
    }

    @NotNull
    public JSFunction getFunction() {
        JSFunction jSFunction = this.myFunction;
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction", "getFunction"));
        }
        return jSFunction;
    }

    private boolean isThisMember(PsiElement element) {
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        JSElementBase base = (JSElementBase)element;
        return JSContext.INSTANCE.equals((Object)base.getJSContext()) && base.getNamespace() != null && (this.myFunctionName.equals(base.getNamespace().getName()) || "constructor".equals(this.myFunctionName) && this.myFunction.getParent() instanceof ES6Class && Comparing.equal((String)((ES6Class)this.myFunction.getParent()).getName(), (String)base.getNamespace().getName()));
    }

    public void replaceUsedParameters() {
        JSParameterListElement[] parameters;
        for (JSParameterListElement parameter : parameters = this.myFunction.getParameters()) {
            if (parameter.getName() == null) continue;
            Ref existingRebindTarget = new Ref();
            JSChangeUtil.rebindIfThereAreUsages((PsiElement)parameter, (PsiElement)this.myFunction, (Convertor<Collection<PsiReference>, PsiElement>)((Convertor)references -> {
                for (Object reference : references) {
                    JSAssignmentExpression expression;
                    if (!(reference instanceof PsiElement) || (expression = this.myParameterAssignments.get(reference)) == null) continue;
                    existingRebindTarget.set((Object)expression.getDefinitionExpression());
                    break;
                }
                boolean toReplace = false;
                block1: for (PsiReference reference : references) {
                    for (JSAssignmentExpression assignmentExpression : this.getOnlyFunctions()) {
                        JSExpression initializer;
                        JSExpression jSExpression = initializer = assignmentExpression.getDefinitionExpression() == null ? null : assignmentExpression.getDefinitionExpression().getInitializer();
                        if (initializer != null && reference instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)((PsiElement)reference), (boolean)false)) {
                            toReplace = true;
                            continue block1;
                        }
                        if (!toReplace) continue;
                        continue block1;
                    }
                }
                if (!toReplace) {
                    return null;
                }
                String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myFunction).FIELD_PREFIX + parameter.getName();
                return !existingRebindTarget.isNull() ? (PsiElement)existingRebindTarget.get() : JSItemToClassConvertor.addPropertyAssignment((PsiElement)this.myFunction, innerName, parameter.getName());
            }), (Processor<PsiReference>)((Processor)reference -> existingRebindTarget.isNull() || !reference.equals(((JSDefinitionExpression)existingRebindTarget.get()).getInitializer())));
        }
    }

    public void removeInnerProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction", "removeInnerProperty"));
        }
        this.myInnerProperties.remove(name);
    }
}

